/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

class graphPanel
extends JPanel {
    Hashtable data;
    Vector keys = new Vector();
    Vector colorList = new Vector();

    public graphPanel() {
    }

    public graphPanel(Hashtable data) {
        this.data = data;
        Enumeration e = data.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.keys.addElement(key);
        }
        for (int a = 51; a < 255; a += 102) {
            for (int b = 51; b < 255; b += 102) {
                for (int c = 51; c < 255; c += 102) {
                    this.colorList.addElement(new Color(a, b, c));
                }
            }
        }
    }

    public float getMax() {
        float maxValue = 0.0f;
        for (int t = 0; t < this.keys.size(); ++t) {
            String key = (String)this.keys.elementAt(t);
            Vector temp = (Vector)this.data.get(key);
            for (int j = 0; j < temp.size(); ++j) {
                float f = ((Integer)temp.elementAt(j)).intValue();
                maxValue = Math.max(f, maxValue);
            }
        }
        return (float)((double)maxValue + (double)maxValue * 0.1);
    }

    public float getMin() {
        float minValue = 9999999.0f;
        for (int t = 0; t < this.keys.size(); ++t) {
            String key = (String)this.keys.elementAt(t);
            Vector temp = (Vector)this.data.get(key);
            for (int j = 0; j < temp.size(); ++j) {
                float f = ((Integer)temp.elementAt(j)).intValue();
                minValue = Math.min(f, minValue);
            }
        }
        return (float)((double)minValue - (double)minValue * 0.1);
    }

    public JPanel getLegend() {
        JPanel main = new JPanel();
        GridBagLayout g = new GridBagLayout();
        main.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 3, 3, 3);
        c.fill = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        int t = 0;
        while (t < this.keys.size()) {
            String key = (String)this.keys.elementAt(t);
            JLabel colorSwatch = new JLabel("  ");
            colorSwatch.setBackground((Color)this.colorList.elementAt(t % this.colorList.size()));
            colorSwatch.setOpaque(true);
            c.gridx = 1;
            c.gridy = t;
            g.setConstraints(colorSwatch, c);
            main.add(colorSwatch);
            JLabel name = new JLabel(key);
            c.gridx = 2;
            c.gridy = t++;
            g.setConstraints(name, c);
            main.add(name);
        }
        return main;
    }

    public JPanel getStats() {
        int total = 0;
        float totalValue = 0.0f;
        float maxValue = 0.0f;
        float minValue = 999999.0f;
        for (int t = 0; t < this.keys.size(); ++t) {
            String key = (String)this.keys.elementAt(t);
            Vector temp = (Vector)this.data.get(key);
            for (int j = 0; j < temp.size(); ++j) {
                float f = ((Integer)temp.elementAt(j)).intValue();
                minValue = Math.min(f, minValue);
                maxValue = Math.max(f, maxValue);
                totalValue += f;
                ++total;
            }
        }
        float averageValue = totalValue / (float)total;
        JPanel main = new JPanel();
        GridBagLayout g = new GridBagLayout();
        main.setLayout(g);
        DecimalFormat df = new DecimalFormat("#0.0");
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 6, 3, 6);
        c.fill = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        JLabel count = new JLabel("Count: " + total);
        c.gridx = 1;
        c.gridy = 1;
        g.setConstraints(count, c);
        JLabel min = new JLabel("Min: " + df.format(new Float(minValue)));
        c.gridx = 1;
        c.gridy = 2;
        g.setConstraints(min, c);
        JLabel max = new JLabel("Max: " + df.format(new Float(maxValue)));
        c.gridx = 1;
        c.gridy = 3;
        g.setConstraints(max, c);
        JLabel average = new JLabel("Average: " + df.format(new Float(averageValue)));
        c.gridx = 1;
        c.gridy = 4;
        g.setConstraints(average, c);
        main.add(count);
        main.add(min);
        main.add(max);
        main.add(average);
        return main;
    }

    public int getDataWidth() {
        int size = 0;
        for (int t = 0; t < this.keys.size(); ++t) {
            String key = (String)this.keys.elementAt(t);
            Vector v = (Vector)this.data.get(key);
            size = Math.max(size, v.size());
        }
        return size;
    }

    public void update(Graphics g) {
        int base = 10;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int width = this.getSize().width;
        int height = this.getSize().height;
        float maxValue = this.getMax();
        float minValue = this.getMin();
        g.setColor(Color.gray);
        int dataWidth = this.getDataWidth();
        int increment = Math.round((width - 1) / (dataWidth - 1));
        int yIncrement = Math.round(((float)height - (float)(1 + base)) / 9.0f);
        for (int t = 1; t < dataWidth; t += dataWidth / 25 + 1) {
            g.drawString(new Integer(t).toString(), t * increment + 2, height - 2);
        }
        float incrementValue = (maxValue - minValue) / 9.0f;
        for (int t = 0; t < 10; ++t) {
            g.drawString(new Integer(Math.round(minValue + (float)t * incrementValue)).toString(), 2, height - t * yIncrement - 2 - base);
        }
        int start = 0;
        for (int t = 0; t < this.keys.size(); ++t) {
            String key = (String)this.keys.elementAt(t);
            Vector v = (Vector)this.data.get(key);
            start = 0;
            g.setColor((Color)this.colorList.elementAt(t % this.colorList.size()));
            for (int i = 0; i < v.size() - 1; ++i) {
                float y1 = ((Integer)v.elementAt(i)).intValue();
                float y2 = ((Integer)v.elementAt(i + 1)).intValue();
                int Y1 = Math.round((float)height * (y1 -= minValue) / (maxValue - minValue));
                int Y2 = Math.round((float)height * (y2 -= minValue) / (maxValue - minValue));
                Y1 = height - Y1 - base;
                Y2 = height - Y2 - base;
                g.drawLine(start, Y1, start + increment, Y2);
                start += increment;
            }
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }
}

