/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.reporters.ResultSaver;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;

public class ResultSaverGui
extends AbstractPostProcessorGui {
    private JTextField filename;
    private JCheckBox errorsOnly;

    public ResultSaverGui() {
        this.init();
    }

    public String getLabelResource() {
        return "resultsaver_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.filename.setText(el.getPropertyAsString("FileSaver.filename"));
        this.errorsOnly.setSelected(el.getPropertyAsBoolean("FileSaver.errorsonly"));
    }

    public TestElement createTestElement() {
        ResultSaver ResultSaver2 = new ResultSaver();
        this.modifyTestElement(ResultSaver2);
        return ResultSaver2;
    }

    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        te.setProperty("FileSaver.filename", this.filename.getText());
        te.setProperty("FileSaver.errorsonly", JOrphanUtils.booleanToString((boolean)this.errorsOnly.isSelected()));
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createFilenamePanel());
        this.errorsOnly = new JCheckBox(JMeterUtils.getResString("resultsaver_errors"));
        box.add(this.errorsOnly);
        this.add((Component)box, "North");
    }

    private JPanel createFilenamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString("resultsaver_prefix"));
        this.filename = new JTextField(10);
        this.filename.setName("FileSaver.filename");
        label.setLabelFor(this.filename);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }
}

