/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HoldSampleSender
implements SampleSender,
Serializable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    List sampleStore = new ArrayList();
    RemoteSampleListener listener;

    HoldSampleSender(RemoteSampleListener listener) {
        log.info("Using Sample store for this test run");
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded() {
        log.info("Test ended()");
        try {
            List list = this.sampleStore;
            synchronized (list) {
                Iterator i = this.sampleStore.iterator();
                while (i.hasNext()) {
                    SampleEvent se = (SampleEvent)i.next();
                    this.listener.sampleOccurred(se);
                }
            }
            this.listener.testEnded();
            this.sampleStore = null;
        }
        catch (Throwable ex) {
            log.warn("testEnded()", ex);
        }
    }

    public void testEnded(String host) {
        log.info("Test Ended on " + host);
        try {
            Iterator i = this.sampleStore.iterator();
            while (i.hasNext()) {
                SampleEvent se = (SampleEvent)i.next();
                this.listener.sampleOccurred(se);
            }
            this.listener.testEnded(host);
            this.sampleStore = null;
        }
        catch (Throwable ex) {
            log.error("testEnded(host)", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SampleOccurred(SampleEvent e) {
        log.debug("Sample occurred");
        List list = this.sampleStore;
        synchronized (list) {
            this.sampleStore.add(e);
        }
    }
}

