/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.samplers.SampleSenderFactory;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RemoteListenerWrapper
extends AbstractTestElement
implements SampleListener,
TestListener,
Serializable,
NoThreadClone {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private RemoteSampleListener listener = null;
    SampleSender mode;

    public RemoteListenerWrapper(RemoteSampleListener l) {
        this.listener = l;
        this.mode = SampleSenderFactory.getInstance(this.listener);
    }

    public RemoteListenerWrapper() {
    }

    public void testStarted() {
        log.info("Test Started()");
        try {
            this.listener.testStarted();
        }
        catch (Throwable ex) {
            log.warn("testStarted()", ex);
        }
    }

    public void testEnded() {
        this.mode.testEnded();
    }

    public void testStarted(String host) {
        log.info("Test Started on " + host);
        try {
            this.listener.testStarted(host);
        }
        catch (Throwable ex) {
            log.error("testStarted(host)", ex);
        }
    }

    public void testEnded(String host) {
        this.mode.testEnded(host);
    }

    public void sampleOccurred(SampleEvent e) {
        this.mode.SampleOccurred(e);
    }

    public void sampleStarted(SampleEvent e) {
        log.debug("Sample started");
        try {
            this.listener.sampleStarted(e);
        }
        catch (RemoteException err) {
            log.error("sampleStarted", (Throwable)err);
        }
    }

    public void sampleStopped(SampleEvent e) {
        log.debug("Sample stopped");
        try {
            this.listener.sampleStopped(e);
        }
        catch (RemoteException err) {
            log.error("sampleStopped", (Throwable)err);
        }
    }

    public void testIterationStart(LoopIterationEvent event) {
    }
}

