/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.format.Formatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.output.io.WriterTarget;

public class SampleResult
implements Serializable {
    private static final String DEFAULT_ENCODING = JMeterUtils.getPropDefault("sampleresult.default.encoding", "ISO-8859-1");
    public static final String TEXT = "text";
    public static final String BINARY = "bin";
    private static final byte[] EMPTY_BA = new byte[0];
    private static final SampleResult[] EMPTY_SR = new SampleResult[0];
    private static final AssertionResult[] EMPTY_AR = new AssertionResult[0];
    private SampleSaveConfiguration saveConfig;
    private SampleResult parent = null;
    private byte[] responseData = EMPTY_BA;
    private String responseCode;
    private String label;
    private String samplerData;
    private String threadName;
    private String responseMessage = "";
    private String responseHeaders = "";
    private String contentType = "";
    private String requestHeaders = "";
    private long timeStamp = 0L;
    private long startTime = 0L;
    private long endTime = 0L;
    private long idleTime = 0L;
    private long pauseTime = 0L;
    private List assertionResults;
    private List subResults;
    private String dataType;
    private boolean success;
    private Set files;
    private String dataEncoding;
    private long time = 0L;
    private long latency = 0L;
    private boolean stopThread = false;
    private boolean stopTest = false;
    private boolean isMonitor = false;
    private int sampleCount = 1;
    private int bytes = 0;
    private static final String TOTAL_TIME = "totalTime";
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static final boolean startTimeStamp = JMeterUtils.getPropDefault("sampleresult.timestamp.start", false);
    private URL location;

    public void setSaveConfig(SampleSaveConfiguration propertiesToSave) {
        this.saveConfig = propertiesToSave;
    }

    public SampleSaveConfiguration getSaveConfig() {
        return this.saveConfig;
    }

    public SampleResult() {
        this.time = 0L;
    }

    public SampleResult(SampleResult res) {
        this.setStartTime(res.getStartTime());
        this.setTime(0L);
        this.setSampleLabel(res.getSampleLabel());
        this.setRequestHeaders(res.getRequestHeaders());
        this.setResponseData(res.getResponseData());
        this.setResponseCode(res.getResponseCode());
        this.setSuccessful(res.isSuccessful());
        this.setResponseMessage(res.getResponseMessage());
        this.setDataType(res.getDataType());
        this.setResponseHeaders(res.getResponseHeaders());
        this.addSubResult(res);
    }

    public boolean isStampedAtStart() {
        return startTimeStamp;
    }

    protected SampleResult(long elapsed, boolean atend) {
        long now = System.currentTimeMillis();
        if (atend) {
            this.setTimes(now - elapsed, now);
        } else {
            this.setTimes(now, now + elapsed);
        }
    }

    public static SampleResult createTestSample(long start, long end) {
        SampleResult res = new SampleResult();
        res.setStartTime(start);
        res.setEndTime(end);
        return res;
    }

    public static SampleResult createTestSample(long elapsed) {
        long now = System.currentTimeMillis();
        return SampleResult.createTestSample(now, now + elapsed);
    }

    public SampleResult(long stamp, long elapsed) {
        if (startTimeStamp) {
            this.setTimes(stamp, stamp + elapsed);
        } else {
            this.setTimes(stamp - elapsed, stamp);
        }
    }

    public void setTime(long elapsed) {
        long now = System.currentTimeMillis();
        this.setTimes(now - elapsed, now);
    }

    public void setMarked(String filename) {
        if (this.files == null) {
            this.files = new HashSet();
        }
        this.files.add(filename);
    }

    public boolean isMarked(String filename) {
        return this.files != null && this.files.contains(filename);
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String code) {
        this.responseCode = code;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String msg) {
        this.responseMessage = msg;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getSampleLabel() {
        return this.label;
    }

    public void setSampleLabel(String label) {
        this.label = label;
    }

    public void addAssertionResult(AssertionResult assertResult) {
        if (this.assertionResults == null) {
            this.assertionResults = new ArrayList();
        }
        this.assertionResults.add(assertResult);
    }

    public AssertionResult[] getAssertionResults() {
        if (this.assertionResults == null) {
            return EMPTY_AR;
        }
        return this.assertionResults.toArray(new AssertionResult[0]);
    }

    public void addSubResult(SampleResult subResult) {
        subResult.setThreadName(this.getThreadName());
        if (this.subResults == null) {
            this.subResults = new ArrayList();
        }
        this.subResults.add(subResult);
        this.setTime(this.getTime() + subResult.getTime());
        subResult.setParent(this);
    }

    public SampleResult[] getSubResults() {
        if (this.subResults == null) {
            return EMPTY_SR;
        }
        return this.subResults.toArray(new SampleResult[0]);
    }

    public void configure(Configuration info) {
        this.time = info.getAttributeAsLong(TOTAL_TIME, 0L);
    }

    public void setResponseData(byte[] response) {
        this.responseData = response;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public byte[] responseDataAsBA() {
        return this.responseData == null ? EMPTY_BA : this.responseData;
    }

    public void setSamplerData(String s) {
        this.samplerData = s;
    }

    public String getSamplerData() {
        return this.samplerData;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setSuccessful(boolean success) {
        this.success = success;
    }

    public String toString() {
        return this.getSampleLabel();
    }

    public String getDataEncoding() {
        if (this.dataEncoding != null) {
            return this.dataEncoding;
        }
        return DEFAULT_ENCODING;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public boolean isStopTest() {
        return this.stopTest;
    }

    public boolean isStopThread() {
        return this.stopThread;
    }

    public void setStopTest(boolean b) {
        this.stopTest = b;
    }

    public void setStopThread(boolean b) {
        this.stopThread = b;
    }

    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setRequestHeaders(String string) {
        this.requestHeaders = string;
    }

    public void setResponseHeaders(String string) {
        this.responseHeaders = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected final void setStartTime(long start) {
        this.startTime = start;
        if (startTimeStamp) {
            this.timeStamp = this.startTime;
        }
    }

    private void setEndTime(long end) {
        this.endTime = end;
        if (!startTimeStamp) {
            this.timeStamp = this.endTime;
        }
        if (this.startTime == 0L) {
            log.error("setEndTime must be called after setStartTime", new Throwable("Invalid call sequence"));
        } else {
            this.time = this.endTime - this.startTime - this.idleTime;
        }
    }

    private void setTimes(long start, long end) {
        this.setStartTime(start);
        this.setEndTime(end);
    }

    public void sampleStart() {
        if (this.startTime == 0L) {
            this.setStartTime(System.currentTimeMillis());
        } else {
            log.error("sampleStart called twice", new Throwable("Invalid call sequence"));
        }
    }

    public void sampleEnd() {
        if (this.endTime == 0L) {
            this.setEndTime(System.currentTimeMillis());
        } else {
            log.error("sampleEnd called twice", new Throwable("Invalid call sequence"));
        }
    }

    public void samplePause() {
        if (this.pauseTime != 0L) {
            log.error("samplePause called twice", new Throwable("Invalid call sequence"));
        }
        this.pauseTime = System.currentTimeMillis();
    }

    public void sampleResume() {
        if (this.pauseTime == 0L) {
            log.error("sampleResume without samplePause", new Throwable("Invalid call sequence"));
        }
        this.idleTime += System.currentTimeMillis() - this.pauseTime;
        this.pauseTime = 0L;
    }

    public void setMonitor(boolean monitor) {
        this.isMonitor = monitor;
    }

    public boolean isMonitor() {
        return this.isMonitor;
    }

    public void setSampleCount(int count) {
        this.sampleCount = count;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setBytes(int length) {
        this.bytes = length;
    }

    public int getBytes() {
        return this.bytes;
    }

    public long getLatency() {
        return this.latency;
    }

    public void latencyEnd() {
        this.latency = System.currentTimeMillis() - this.startTime - this.idleTime;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setURL(URL location) {
        this.location = location;
    }

    public URL getURL() {
        return this.location;
    }

    public SampleResult getParent() {
        return this.parent;
    }

    public void setParent(SampleResult parent) {
        this.parent = parent;
    }

    static {
        if (startTimeStamp) {
            log.info("Note: Sample TimeStamps are START times");
        } else {
            log.info("Note: Sample TimeStamps are END times");
        }
        log.info("sampleresult.default.encoding is set to " + DEFAULT_ENCODING);
    }

    public static class Test
    extends TestCase {
        private static Formatter fmt = new RawFormatter();
        private StringWriter wr = null;

        public Test(String name) {
            super(name);
        }

        public void testElapsed() throws Exception {
            SampleResult res = new SampleResult();
            res.sampleStart();
            Thread.sleep(100L);
            res.sampleEnd();
            Test.assertTrue((res.getTime() >= 100L ? 1 : 0) != 0);
        }

        public void testPause() throws Exception {
            SampleResult res = new SampleResult();
            res.sampleStart();
            Thread.sleep(100L);
            res.samplePause();
            Thread.sleep(200L);
            res.sampleResume();
            Thread.sleep(100L);
            res.sampleEnd();
            long sampleTime = res.getTime();
            if (sampleTime < 200L || sampleTime > 290L) {
                Test.fail((String)("Accumulated time (" + sampleTime + ") was not between 200 and 290 ms"));
            }
        }

        public void divertLog() {
            this.wr = new StringWriter(1000);
            LogTarget[] lt = new LogTarget[]{new WriterTarget((Writer)this.wr, fmt)};
            log.setLogTargets(lt);
        }

        public void testPause2() throws Exception {
            this.divertLog();
            SampleResult res = new SampleResult();
            res.sampleStart();
            res.samplePause();
            Test.assertTrue((this.wr.toString().length() == 0 ? 1 : 0) != 0);
            res.samplePause();
            Test.assertFalse((this.wr.toString().length() == 0 ? 1 : 0) != 0);
        }
    }
}

