/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.SaveServiceConstants;
import org.apache.jmeter.save.TestElementSaver;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public final class OldSaveService
implements SaveServiceConstants {
    private static final transient Logger log = LoggingManager.getLoggerForClass();
    private static final SampleSaveConfiguration _saveConfig = SampleSaveConfiguration.staticConfig();
    private static DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
    static /* synthetic */ Class class$org$apache$jmeter$testelement$property$StringProperty;

    private OldSaveService() {
    }

    public static SampleResult makeResultFromDelimitedString(String delim) {
        SampleResult result = null;
        long timeStamp = 0L;
        long elapsed = 0L;
        StringTokenizer splitter = new StringTokenizer(delim, _saveConfig.getDelimiter());
        String text = null;
        try {
            if (_saveConfig.printMilliseconds()) {
                text = splitter.nextToken();
                timeStamp = Long.parseLong(text);
            } else if (_saveConfig.formatter() != null) {
                text = splitter.nextToken();
                Date stamp = _saveConfig.formatter().parse(text);
                timeStamp = stamp.getTime();
            }
            if (_saveConfig.saveTime()) {
                text = splitter.nextToken();
                elapsed = Long.parseLong(text);
            }
            result = new SampleResult(timeStamp, elapsed);
            if (_saveConfig.saveLabel()) {
                text = splitter.nextToken();
                result.setSampleLabel(text);
            }
            if (_saveConfig.saveCode()) {
                text = splitter.nextToken();
                result.setResponseCode(text);
            }
            if (_saveConfig.saveMessage()) {
                text = splitter.nextToken();
                result.setResponseMessage(text);
            }
            if (_saveConfig.saveThreadName()) {
                text = splitter.nextToken();
                result.setThreadName(text);
            }
            if (_saveConfig.saveDataType()) {
                text = splitter.nextToken();
                result.setDataType(text);
            }
            if (_saveConfig.saveSuccess()) {
                text = splitter.nextToken();
                result.setSuccessful(Boolean.valueOf(text));
            }
            if (_saveConfig.saveAssertionResultsFailureMessage()) {
                text = splitter.nextToken();
            }
        }
        catch (NumberFormatException e) {
            log.warn("Error parsing number " + e);
            throw e;
        }
        catch (ParseException e) {
            log.warn("Error parsing line " + e);
            throw new RuntimeException(e.toString());
        }
        return result;
    }

    public static String printableFieldNamesToString() {
        return OldSaveService.printableFieldNamesToString(_saveConfig);
    }

    public static String printableFieldNamesToString(SampleSaveConfiguration saveConfig) {
        int delSize;
        StringBuffer text = new StringBuffer();
        String delim = saveConfig.getDelimiter();
        if (saveConfig.saveTimestamp() || saveConfig.formatter() != null) {
            text.append("timeStamp");
            text.append(delim);
        }
        if (saveConfig.saveTime()) {
            text.append("time");
            text.append(delim);
        }
        if (saveConfig.saveLabel()) {
            text.append("label");
            text.append(delim);
        }
        if (saveConfig.saveCode()) {
            text.append("responseCode");
            text.append(delim);
        }
        if (saveConfig.saveMessage()) {
            text.append("responseMessage");
            text.append(delim);
        }
        if (saveConfig.saveThreadName()) {
            text.append("threadName");
            text.append(delim);
        }
        if (saveConfig.saveDataType()) {
            text.append("dataType");
            text.append(delim);
        }
        if (saveConfig.saveSuccess()) {
            text.append("success");
            text.append(delim);
        }
        if (saveConfig.saveAssertionResultsFailureMessage()) {
            text.append("failureMessage");
            text.append(delim);
        }
        String resultString = null;
        int size = text.length();
        resultString = size >= (delSize = delim.length()) ? text.substring(0, size - delSize) : text.toString();
        return resultString;
    }

    public static void saveSubTree(HashTree subTree, OutputStream writer) throws IOException {
        Configuration config = (Configuration)OldSaveService.getConfigsFromTree(subTree).get(0);
        DefaultConfigurationSerializer saver = new DefaultConfigurationSerializer();
        saver.setIndent(true);
        try {
            saver.serialize(writer, config);
        }
        catch (SAXException e) {
            throw new IOException("SAX implementation problem");
        }
        catch (ConfigurationException e) {
            throw new IOException("Problem using Avalon Configuration tools");
        }
    }

    public static void saveCSVStats(Vector data, FileWriter writer) throws IOException {
        for (int idx = 0; idx < data.size(); ++idx) {
            Vector row = (Vector)data.elementAt(idx);
            for (int idy = 0; idy < row.size(); ++idy) {
                if (idy > 0) {
                    writer.write(",");
                }
                Object item = row.elementAt(idy);
                writer.write(String.valueOf(item));
            }
            writer.write(System.getProperty("line.separator"));
        }
    }

    public static SampleResult getSampleResult(Configuration config) {
        SampleResult result = new SampleResult(config.getAttributeAsLong("timeStamp", 0L), config.getAttributeAsLong("time", 0L));
        result.setThreadName(config.getAttribute("threadName", ""));
        result.setDataType(config.getAttribute("dataType", ""));
        result.setResponseCode(config.getAttribute("responseCode", ""));
        result.setResponseMessage(config.getAttribute("responseMessage", ""));
        result.setSuccessful(config.getAttributeAsBoolean("success", false));
        result.setSampleLabel(config.getAttribute("label", ""));
        result.setResponseData(OldSaveService.getBinaryData(config.getChild("binary")));
        Configuration[] subResults = config.getChildren("sampleResult");
        for (int i = 0; i < subResults.length; ++i) {
            result.addSubResult(OldSaveService.getSampleResult(subResults[i]));
        }
        Configuration[] assResults = config.getChildren("assertionResult");
        for (int i = 0; i < assResults.length; ++i) {
            result.addAssertionResult(OldSaveService.getAssertionResult(assResults[i]));
        }
        Configuration[] samplerData = config.getChildren("property");
        for (int i = 0; i < samplerData.length; ++i) {
            result.setSamplerData(samplerData[i].getValue(""));
        }
        return result;
    }

    private static List getConfigsFromTree(HashTree subTree) {
        Iterator iter = subTree.list().iterator();
        LinkedList<DefaultConfiguration> configs = new LinkedList<DefaultConfiguration>();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            DefaultConfiguration config = new DefaultConfiguration("node", "node");
            config.addChild(OldSaveService.getConfigForTestElement(null, item));
            List configList = OldSaveService.getConfigsFromTree(subTree.getTree((Object)item));
            Iterator iter2 = configList.iterator();
            while (iter2.hasNext()) {
                config.addChild((Configuration)iter2.next());
            }
            configs.add(config);
        }
        return configs;
    }

    public static Configuration getConfiguration(byte[] bin) {
        DefaultConfiguration config = new DefaultConfiguration("binary", "JMeter Save Service");
        try {
            config.setValue(new String(bin, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        return config;
    }

    public static byte[] getBinaryData(Configuration config) {
        if (config == null) {
            return new byte[0];
        }
        try {
            return config.getValue("").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static AssertionResult getAssertionResult(Configuration config) {
        AssertionResult result = new AssertionResult();
        result.setError(config.getAttributeAsBoolean("error", false));
        result.setFailure(config.getAttributeAsBoolean("failure", false));
        result.setFailureMessage(config.getAttribute("failureMessage", ""));
        return result;
    }

    public static Configuration getConfiguration(AssertionResult assResult) {
        DefaultConfiguration config = new DefaultConfiguration("assertionResult", "JMeter Save Service");
        config.setAttribute("failureMessage", assResult.getFailureMessage());
        config.setAttribute("error", "" + assResult.isError());
        config.setAttribute("failure", "" + assResult.isFailure());
        return config;
    }

    public static Configuration getConfiguration(SampleResult result, SampleSaveConfiguration saveConfig) {
        SampleResult[] subResults;
        DefaultConfiguration config = new DefaultConfiguration("sampleResult", "JMeter Save Service");
        if (saveConfig.saveTime()) {
            config.setAttribute("time", "" + result.getTime());
        }
        if (saveConfig.saveLabel()) {
            config.setAttribute("label", result.getSampleLabel());
        }
        if (saveConfig.saveCode()) {
            config.setAttribute("responseCode", result.getResponseCode());
        }
        if (saveConfig.saveMessage()) {
            config.setAttribute("responseMessage", result.getResponseMessage());
        }
        if (saveConfig.saveThreadName()) {
            config.setAttribute("threadName", result.getThreadName());
        }
        if (saveConfig.saveDataType()) {
            config.setAttribute("dataType", result.getDataType());
        }
        if (saveConfig.printMilliseconds()) {
            config.setAttribute("timeStamp", "" + result.getTimeStamp());
        } else if (saveConfig.formatter() != null) {
            String stamp = saveConfig.formatter().format(new Date(result.getTimeStamp()));
            config.setAttribute("timeStamp", stamp);
        }
        if (saveConfig.saveSuccess()) {
            config.setAttribute("success", JOrphanUtils.booleanToString((boolean)result.isSuccessful()));
        }
        if ((subResults = result.getSubResults()) != null) {
            for (int i = 0; i < subResults.length; ++i) {
                config.addChild(OldSaveService.getConfiguration(subResults[i], saveConfig));
            }
        }
        AssertionResult[] assResults = result.getAssertionResults();
        if (saveConfig.saveSamplerData(result)) {
            config.addChild(OldSaveService.createConfigForString("samplerData", result.getSamplerData()));
        }
        if (saveConfig.saveAssertions() && assResults != null) {
            for (int i = 0; i < assResults.length; ++i) {
                config.addChild(OldSaveService.getConfiguration(assResults[i]));
            }
        }
        if (saveConfig.saveResponseData(result)) {
            config.addChild(OldSaveService.getConfiguration(result.getResponseData()));
        }
        return config;
    }

    public static String resultToDelimitedString(SampleResult sample) {
        return OldSaveService.resultToDelimitedString(sample, sample.getSaveConfig().getDelimiter());
    }

    public static String resultToDelimitedString(SampleResult sample, String delimiter) {
        int delSize;
        StringBuffer text = new StringBuffer();
        SampleSaveConfiguration saveConfig = sample.getSaveConfig();
        if (saveConfig.saveTimestamp()) {
            text.append(sample.getTimeStamp());
            text.append(delimiter);
        } else if (saveConfig.formatter() != null) {
            String stamp = saveConfig.formatter().format(new Date(sample.getTimeStamp()));
            text.append(stamp);
            text.append(delimiter);
        }
        if (saveConfig.saveTime()) {
            text.append(sample.getTime());
            text.append(delimiter);
        }
        if (saveConfig.saveLabel()) {
            text.append(sample.getSampleLabel());
            text.append(delimiter);
        }
        if (saveConfig.saveCode()) {
            text.append(sample.getResponseCode());
            text.append(delimiter);
        }
        if (saveConfig.saveMessage()) {
            text.append(sample.getResponseMessage());
            text.append(delimiter);
        }
        if (saveConfig.saveThreadName()) {
            text.append(sample.getThreadName());
            text.append(delimiter);
        }
        if (saveConfig.saveDataType()) {
            text.append(sample.getDataType());
            text.append(delimiter);
        }
        if (saveConfig.saveSuccess()) {
            text.append(sample.isSuccessful());
            text.append(delimiter);
        }
        if (saveConfig.saveAssertionResultsFailureMessage()) {
            String message = null;
            AssertionResult[] results = sample.getAssertionResults();
            if (results != null && results.length > 0) {
                message = results[0].getFailureMessage();
            }
            if (message != null) {
                text.append(message);
            }
            text.append(delimiter);
        }
        String resultString = null;
        int size = text.length();
        resultString = size >= (delSize = delimiter.length()) ? text.substring(0, size - delSize) : text.toString();
        return resultString;
    }

    public static Configuration getConfigForTestElement(String named, TestElement item) {
        TestElementSaver saver = new TestElementSaver(named);
        item.traverse(saver);
        Configuration config = saver.getConfiguration();
        return config;
    }

    private static Configuration createConfigForString(String name, String value) {
        if (value == null) {
            value = "";
        }
        DefaultConfiguration config = new DefaultConfiguration("property", "property");
        config.setAttribute("name", name);
        config.setValue(value);
        config.setAttribute("xml:space", "preserve");
        return config;
    }

    public static synchronized HashTree loadSubTree(InputStream in) throws IOException {
        try {
            Configuration config = builder.build(in);
            HashTree loadedTree = OldSaveService.generateNode(config);
            return loadedTree;
        }
        catch (ConfigurationException e) {
            String message = "Problem loading using Avalon Configuration tools";
            log.error(message, (Throwable)e);
            throw new IOException(message);
        }
        catch (SAXException e) {
            String message = "Problem with SAX implementation";
            log.error(message, (Throwable)e);
            throw new IOException(message);
        }
    }

    public static TestElement createTestElement(Configuration config) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        TestElement element = null;
        String testClass = config.getAttribute("class");
        String gui_class = "";
        Configuration[] children = config.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getName().equals("property") || !children[i].getAttribute("name").equals("TestElement.gui_class")) continue;
            gui_class = children[i].getValue();
        }
        String newClass = NameUpdater.getCurrentTestName(testClass, gui_class);
        element = (TestElement)Class.forName(newClass).newInstance();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getName().equals("property")) {
                try {
                    JMeterProperty prop = OldSaveService.createProperty(children[i], newClass);
                    if (prop == null) continue;
                    element.setProperty(prop);
                }
                catch (Exception ex) {
                    log.error("Problem loading property", (Throwable)ex);
                    element.setProperty(children[i].getAttribute("name"), "");
                }
                continue;
            }
            if (children[i].getName().equals("testelement")) {
                element.setProperty(new TestElementProperty(children[i].getAttribute("name", ""), OldSaveService.createTestElement(children[i])));
                continue;
            }
            if (children[i].getName().equals("collection")) {
                element.setProperty(new CollectionProperty(children[i].getAttribute("name", ""), OldSaveService.createCollection(children[i], newClass)));
                continue;
            }
            if (!children[i].getName().equals("map")) continue;
            element.setProperty(new MapProperty(children[i].getAttribute("name", ""), OldSaveService.createMap(children[i], newClass)));
        }
        return element;
    }

    private static Collection createCollection(Configuration config, String testClass) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Collection coll = (Collection)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] items = config.getChildren();
        for (int i = 0; i < items.length; ++i) {
            JMeterProperty prop;
            if (items[i].getName().equals("property")) {
                prop = OldSaveService.createProperty(items[i], testClass);
                if (prop == null) continue;
                coll.add(prop);
                continue;
            }
            if (items[i].getName().equals("testelement")) {
                coll.add(new TestElementProperty(items[i].getAttribute("name", ""), OldSaveService.createTestElement(items[i])));
                continue;
            }
            if (items[i].getName().equals("collection")) {
                coll.add(new CollectionProperty(items[i].getAttribute("name", ""), OldSaveService.createCollection(items[i], testClass)));
                continue;
            }
            if (items[i].getName().equals("string")) {
                prop = OldSaveService.createProperty(items[i], testClass);
                if (prop == null) continue;
                coll.add(prop);
                continue;
            }
            if (!items[i].getName().equals("map")) continue;
            coll.add(new MapProperty(items[i].getAttribute("name", ""), OldSaveService.createMap(items[i], testClass)));
        }
        return coll;
    }

    private static JMeterProperty createProperty(Configuration config, String testClass) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        String name;
        String value = config.getValue("");
        String oname = name = config.getAttribute("name", value);
        String type = config.getAttribute("propType", (class$org$apache$jmeter$testelement$property$StringProperty == null ? (class$org$apache$jmeter$testelement$property$StringProperty = OldSaveService.class$("org.apache.jmeter.testelement.property.StringProperty")) : class$org$apache$jmeter$testelement$property$StringProperty).getName());
        value = "TestElement.gui_class".equals(name = NameUpdater.getCurrentName(name, testClass)) ? NameUpdater.getCurrentName(value) : ("TestElement.test_class".equals(name) ? testClass : NameUpdater.getCurrentName(value, name, testClass));
        if (oname.length() != 0 && name.length() == 0) {
            return null;
        }
        JMeterProperty prop = (JMeterProperty)Class.forName(type).newInstance();
        prop.setName(name);
        prop.setObjectValue(value);
        return prop;
    }

    private static Map createMap(Configuration config, String testClass) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Map map = (Map)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] items = config.getChildren();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getName().equals("property")) {
                JMeterProperty prop = OldSaveService.createProperty(items[i], testClass);
                if (prop == null) continue;
                map.put(prop.getName(), prop);
                continue;
            }
            if (items[i].getName().equals("testelement")) {
                map.put(items[i].getAttribute("name", ""), new TestElementProperty(items[i].getAttribute("name", ""), OldSaveService.createTestElement(items[i])));
                continue;
            }
            if (items[i].getName().equals("collection")) {
                map.put(items[i].getAttribute("name"), new CollectionProperty(items[i].getAttribute("name", ""), OldSaveService.createCollection(items[i], testClass)));
                continue;
            }
            if (!items[i].getName().equals("map")) continue;
            map.put(items[i].getAttribute("name", ""), new MapProperty(items[i].getAttribute("name", ""), OldSaveService.createMap(items[i], testClass)));
        }
        return map;
    }

    private static HashTree generateNode(Configuration config) {
        TestElement element = null;
        try {
            element = OldSaveService.createTestElement(config.getChild("testelement"));
        }
        catch (Exception e) {
            log.error("Problem loading part of file", (Throwable)e);
            return null;
        }
        ListedHashTree subTree = new ListedHashTree((Object)element);
        Configuration[] subNodes = config.getChildren("node");
        for (int i = 0; i < subNodes.length; ++i) {
            HashTree t = OldSaveService.generateNode(subNodes[i]);
            if (t == null) continue;
            subTree.add((Object)element, t);
        }
        return subTree;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

