/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.jmeter.save.SaveServiceConstants;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementTraverser;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;

public class TestElementSaver
implements TestElementTraverser,
SaveServiceConstants {
    String name;
    LinkedList stack = new LinkedList();
    DefaultConfiguration rootConfig = null;

    public TestElementSaver(String name) {
        this.name = name;
    }

    public Configuration getConfiguration() {
        return this.rootConfig;
    }

    public void startTestElement(TestElement el) {
        DefaultConfiguration config = new DefaultConfiguration("testelement", "testelement");
        config.setAttribute("class", el.getClass().getName());
        if (this.rootConfig == null) {
            this.rootConfig = config;
            if (this.name != null && this.name.length() > 0) {
                this.rootConfig.setAttribute("name", this.name);
            }
        } else {
            this.setConfigName(config);
        }
        this.stack.add(config);
    }

    public void setConfigName(DefaultConfiguration config) {
        if (!(this.stack.getLast() instanceof Configuration)) {
            Object key = this.stack.removeLast();
            config.setAttribute("name", key.toString());
        }
    }

    public void endTestElement(TestElement el) {
    }

    public void simplePropertyValue(JMeterProperty value) {
        try {
            DefaultConfiguration config;
            Object parent = this.stack.getLast();
            if (!(parent instanceof Configuration)) {
                config = new DefaultConfiguration("property", "property");
                config.setValue(value != null ? value.toString() : "");
                config.setAttribute("name", parent.toString());
                config.setAttribute("xml:space", "preserve");
                this.stack.removeLast();
                this.stack.add(config);
            }
            if (parent instanceof DefaultConfiguration && value instanceof Configuration) {
                ((DefaultConfiguration)parent).addChild((Configuration)value);
            } else if (parent instanceof DefaultConfiguration && !(value instanceof Configuration)) {
                config = new DefaultConfiguration("string", "string");
                config.setValue(value.toString());
                config.setAttribute("xml:space", "preserve");
                ((DefaultConfiguration)parent).addChild((Configuration)config);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void startMap(MapProperty map) {
        DefaultConfiguration config = new DefaultConfiguration("map", "map");
        config.setAttribute("class", map.getObjectValue().getClass().getName());
        config.setAttribute("name", map.getName());
        config.setAttribute("propType", map.getClass().getName());
        this.stack.add(config);
    }

    public void startCollection(CollectionProperty col) {
        DefaultConfiguration config = new DefaultConfiguration("collection", "collection");
        config.setAttribute("class", col.getObjectValue().getClass().getName());
        config.setAttribute("name", col.getName());
        config.setAttribute("propType", col.getClass().getName());
        this.stack.add(config);
    }

    public void endProperty(JMeterProperty key) {
        this.finishConfig();
    }

    private void finishConfig() {
        if (this.stack.size() > 1) {
            Configuration config = (Configuration)this.stack.removeLast();
            ((DefaultConfiguration)this.stack.getLast()).addChild(config);
        }
    }

    public void startProperty(JMeterProperty key) {
        if (key instanceof CollectionProperty) {
            this.startCollection((CollectionProperty)key);
        } else if (key instanceof MapProperty) {
            this.startMap((MapProperty)key);
        } else if (key instanceof TestElementProperty) {
            this.stack.addLast(key.getName());
        } else {
            DefaultConfiguration config = new DefaultConfiguration("property", "property");
            config.setValue(key.getStringValue());
            config.setAttribute("name", key.getName());
            config.setAttribute("propType", key.getClass().getName());
            config.setAttribute("xml:space", "preserve");
            this.stack.addLast(config);
        }
    }
}

