/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import java.io.UnsupportedEncodingException;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class ConversionHelp {
    private static final String CHAR_SET = "UTF-8";
    private static final transient Logger log = LoggingManager.getLoggerForClass();
    private static String inVersion;
    private static String outVersion;

    public static void setInVersion(String v) {
        inVersion = v;
    }

    public static void setOutVersion(String v) {
        outVersion = v;
    }

    public static String encode(String p) {
        if (!"1.0".equals(outVersion)) {
            return p;
        }
        if (p == null) {
            return "";
        }
        try {
            String p1 = JOrphanUtils.encode((String)p, (String)CHAR_SET);
            return p1;
        }
        catch (UnsupportedEncodingException e) {
            log.warn("System doesn't support UTF-8", (Throwable)e);
            return p;
        }
    }

    public static String decode(String p) {
        if (!"1.0".equals(inVersion)) {
            return p;
        }
        if (p == null) {
            return null;
        }
        try {
            return JOrphanUtils.decode((String)p, (String)CHAR_SET);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("System doesn't support UTF-8", (Throwable)e);
            return p;
        }
    }

    public static String cdata(byte[] chars, String encoding) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer("<![CDATA[");
        buf.append(new String(chars, encoding));
        buf.append("]]>");
        return buf.toString();
    }

    static {
        outVersion = "1.1";
    }
}

