/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.save.converters.ConversionHelp;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TestElementPropertyConverter
extends AbstractCollectionConverter {
    Logger log = LoggingManager.getLoggerForClass();
    static /* synthetic */ Class class$org$apache$jmeter$testelement$property$TestElementProperty;

    public static String getVersion() {
        return "$Revision: 1.7 $";
    }

    public boolean canConvert(Class arg0) {
        return arg0.equals(class$org$apache$jmeter$testelement$property$TestElementProperty == null ? (class$org$apache$jmeter$testelement$property$TestElementProperty = TestElementPropertyConverter.class$("org.apache.jmeter.testelement.property.TestElementProperty")) : class$org$apache$jmeter$testelement$property$TestElementProperty);
    }

    public void marshal(Object arg0, HierarchicalStreamWriter writer, MarshallingContext context) {
        TestElementProperty prop = (TestElementProperty)arg0;
        writer.addAttribute("name", ConversionHelp.encode(prop.getName()));
        writer.addAttribute("elementType", prop.getObjectValue().getClass().getName());
        PropertyIterator iter = prop.iterator();
        while (iter.hasNext()) {
            this.writeItem(iter.next(), context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            TestElementProperty prop = (TestElementProperty)this.createCollection(context.getRequiredType());
            prop.setName(ConversionHelp.decode(reader.getAttribute("name")));
            String element = reader.getAttribute("elementType");
            boolean isHeader = "org.apache.jmeter.protocol.http.control.Header".equals(element);
            prop.setObjectValue(Class.forName(element).newInstance());
            while (reader.hasMoreChildren()) {
                String name;
                reader.moveDown();
                JMeterProperty subProp = (JMeterProperty)this.readItem(reader, context, prop);
                if (isHeader && "TestElement.name".equals(name = subProp.getName())) {
                    subProp.setName("Header.name");
                }
                prop.addProperty(subProp);
                reader.moveUp();
            }
            return prop;
        }
        catch (Exception e) {
            this.log.error("Couldn't unmarshall TestElementProperty", (Throwable)e);
            return new TestElementProperty("ERROR", new ConfigTestElement());
        }
    }

    public TestElementPropertyConverter(ClassMapper arg0, String arg1) {
        super(arg0, arg1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

