/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.services;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FileServer {
    static Logger log = LoggingManager.getLoggerForClass();
    File base;
    Map files = new HashMap();
    private static FileServer server = new FileServer();
    private Random random = new Random();

    private FileServer() {
        this.base = new File(JMeterUtils.getProperty("user.dir"));
    }

    public static FileServer getFileServer() {
        return server;
    }

    public void setBasedir(String basedir) throws IOException {
        if (this.filesOpen()) {
            throw new IOException("Files are still open, cannot change base directory");
        }
        this.files.clear();
        if (basedir != null) {
            this.base = new File(basedir);
            if (!this.base.isDirectory()) {
                this.base = this.base.getParentFile();
            }
        }
    }

    public String getBaseDir() {
        return this.base.getAbsolutePath();
    }

    public synchronized void reserveFile(String filename) {
        if (!this.files.containsKey(filename)) {
            Object[] file = new Object[]{new File(this.base, filename), null};
            this.files.put(filename, file);
        }
    }

    public synchronized String readLine(String filename) throws IOException {
        Object[] file = (Object[])this.files.get(filename);
        if (file != null) {
            BufferedReader reader;
            String line;
            if (file[1] == null) {
                BufferedReader r = new BufferedReader(new FileReader((File)file[0]));
                file[1] = r;
            }
            if ((line = (reader = (BufferedReader)file[1]).readLine()) == null) {
                reader.close();
                reader = new BufferedReader(new FileReader((File)file[0]));
                file[1] = reader;
                line = reader.readLine();
            }
            return line;
        }
        throw new IOException("File never reserved");
    }

    public synchronized void write(String filename, String value) throws IOException {
        Object[] file = (Object[])this.files.get(filename);
        if (file != null) {
            if (file[1] == null) {
                file[1] = new BufferedWriter(new FileWriter((File)file[0]));
            } else if (!(file[1] instanceof Writer)) {
                throw new IOException("File " + filename + " already in use");
            }
            BufferedWriter writer = (BufferedWriter)file[1];
            writer.write(value);
        }
    }

    public void closeFiles() throws IOException {
        Iterator iter = this.files.keySet().iterator();
        while (iter.hasNext()) {
            this.closeFile((String)iter.next());
        }
        this.files.clear();
    }

    public synchronized void closeFile(String name) throws IOException {
        Object[] file = (Object[])this.files.get(name);
        if (file != null && file.length == 2 && file[1] != null) {
            ((Reader)file[1]).close();
            file[1] = null;
        }
    }

    protected boolean filesOpen() {
        Iterator iter = this.files.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object[] file = (Object[])this.files.get(name);
            if (file[1] == null) continue;
            return true;
        }
        return false;
    }

    public File getRandomFile(String basedir, String[] extensions) {
        File src;
        File input = null;
        if (basedir != null && (src = new File(basedir)).isDirectory() && src.list() != null) {
            File[] lfiles = src.listFiles(new JMeterFileFilter(extensions));
            int count = lfiles.length;
            input = lfiles[this.random.nextInt(count)];
        }
        return input;
    }
}

