/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.jmeter.testbeans.gui.GenericTestBeanCustomizer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class BeanInfoSupport
extends SimpleBeanInfo {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    public static final String TAGS = "tags";
    public static final String NOT_UNDEFINED = "notUndefined";
    public static final String NOT_EXPRESSION = "notExpression";
    public static final String NOT_OTHER = "notOther";
    public static final String DEFAULT = "default";
    public static final String RESOURCE_BUNDLE = "resourceBundle";
    private BeanInfo rootBeanInfo;
    private Image[] icons = new Image[5];
    private int numCreatedGroups = 0;

    protected BeanInfoSupport(Class beanClass) {
        try {
            this.rootBeanInfo = Introspector.getBeanInfo(beanClass, 2);
        }
        catch (IntrospectionException e) {
            log.error("Can't introspect.", (Throwable)e);
            throw new Error(e.toString());
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(beanClass.getName() + "Resources", JMeterUtils.getLocale());
            this.getBeanDescriptor().setValue(RESOURCE_BUNDLE, resourceBundle);
            try {
                this.getBeanDescriptor().setDisplayName(resourceBundle.getString("displayName"));
            }
            catch (MissingResourceException e) {
                log.debug("Localized display name not available for bean " + beanClass.getName());
            }
            PropertyDescriptor[] properties = this.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                String name = properties[i].getName();
                try {
                    properties[i].setDisplayName(resourceBundle.getString(name + ".displayName"));
                }
                catch (MissingResourceException e) {
                    log.debug("Localized display name not available for property " + name);
                }
                try {
                    properties[i].setShortDescription(resourceBundle.getString(name + ".shortDescription"));
                    continue;
                }
                catch (MissingResourceException e) {
                    log.debug("Localized short description not available for property " + name);
                }
            }
        }
        catch (MissingResourceException e) {
            log.warn("Localized strings not available for bean " + beanClass, (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Something bad happened when loading bean info", (Throwable)e);
        }
    }

    protected PropertyDescriptor property(String name) {
        PropertyDescriptor[] properties = this.getPropertyDescriptors();
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getName().equals(name)) continue;
            return properties[i];
        }
        return null;
    }

    protected void setIcon(String resourceName) {
        this.icons[1] = this.loadImage(resourceName);
    }

    protected void createPropertyGroup(String group, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            log.debug("Getting property for: " + names[i]);
            PropertyDescriptor p = this.property(names[i]);
            p.setValue("group", group);
            p.setValue("order", new Integer(i));
        }
        ++this.numCreatedGroups;
        this.getBeanDescriptor().setValue(GenericTestBeanCustomizer.ORDER(group), new Integer(this.numCreatedGroups));
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return this.rootBeanInfo.getAdditionalBeanInfo();
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.rootBeanInfo.getBeanDescriptor();
    }

    public int getDefaultEventIndex() {
        return this.rootBeanInfo.getDefaultEventIndex();
    }

    public int getDefaultPropertyIndex() {
        return this.rootBeanInfo.getDefaultPropertyIndex();
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.rootBeanInfo.getEventSetDescriptors();
    }

    public Image getIcon(int iconKind) {
        return this.icons[iconKind];
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.rootBeanInfo.getMethodDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.rootBeanInfo.getPropertyDescriptors();
    }
}

