/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.Converter;
import org.apache.log.Logger;

public class TestBeanHelper {
    protected static final Logger log = LoggingManager.getLoggerForClass();

    public static void prepare(TestElement el) {
        if (!(el instanceof TestBean)) {
            return;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(el.getClass());
            PropertyDescriptor[] desc = beanInfo.getPropertyDescriptors();
            Object[] param = new Object[1];
            if (log.isDebugEnabled()) {
                log.debug("Preparing " + el.getClass());
            }
            for (int x = 0; x < desc.length; ++x) {
                JMeterProperty jprop = el.getProperty(desc[x].getName());
                Class<?> type = desc[x].getPropertyType();
                Object value = Converter.convert((Object)jprop.getStringValue(), type);
                if (log.isDebugEnabled()) {
                    log.debug("Setting " + jprop.getName() + "=" + value);
                }
                if (value == null && type.isPrimitive()) continue;
                param[0] = value;
                TestBeanHelper.invokeOrBailOut(el, desc[x].getWriteMethod(), param);
            }
        }
        catch (IntrospectionException e) {
            log.error("Couldn't set properties for " + el.getClass().getName(), (Throwable)e);
        }
    }

    private static Object invokeOrBailOut(Object invokee, Method method, Object[] params) {
        try {
            return method.invoke(invokee, params);
        }
        catch (IllegalArgumentException e) {
            log.error("This should never happen.", (Throwable)e);
            throw new Error(e.toString());
        }
        catch (IllegalAccessException e) {
            log.error("This should never happen.", (Throwable)e);
            throw new Error(e.toString());
        }
        catch (InvocationTargetException e) {
            log.error("This should never happen.", (Throwable)e);
            throw new Error(e.toString());
        }
    }

    private static Object unwrapProperty(JMeterProperty property, Class type) {
        return Converter.convert((Object)property.getObjectValue(), (Class)type);
    }
}

