/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jmeter.testbeans.gui.WrapperEditor;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FileEditor
implements PropertyEditor,
ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JPanel panel;
    private PropertyEditor editor;

    public FileEditor() {
        JButton button = new JButton("Browse...");
        button.addActionListener(this);
        this.editor = new WrapperEditor(this, new SimpleFileEditor(), new ComboStringEditor(), true, true, true, null);
        this.panel = new JPanel(new BorderLayout(5, 0));
        this.panel.add(this.editor.getCustomEditor(), "Center");
        this.panel.add((Component)button, "East");
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = FileDialoger.promptToOpenFile();
        File file = chooser.getSelectedFile();
        this.setValue(file.getPath());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.editor.addPropertyChangeListener(listener);
    }

    public String getAsText() {
        return this.editor.getAsText();
    }

    public Component getCustomEditor() {
        return this.panel;
    }

    public String getJavaInitializationString() {
        return this.editor.getJavaInitializationString();
    }

    public String[] getTags() {
        return this.editor.getTags();
    }

    public Object getValue() {
        return this.editor.getValue();
    }

    public boolean isPaintable() {
        return this.editor.isPaintable();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        this.editor.paintValue(gfx, box);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.editor.removePropertyChangeListener(listener);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.editor.setAsText(text);
    }

    public void setValue(Object value) {
        this.editor.setValue(value);
    }

    public boolean supportsCustomEditor() {
        return this.editor.supportsCustomEditor();
    }

    private static class SimpleFileEditor
    extends PropertyEditorSupport {
        private SimpleFileEditor() {
        }

        public String getAsText() {
            return ((File)super.getValue()).getPath();
        }

        public void setAsText(String text) throws IllegalArgumentException {
            super.setValue(new File(text));
        }

        public Object getValue() {
            return this.getAsText();
        }

        public void setValue(Object file) {
            this.setAsText((String)file);
        }
    }
}

