/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JPopupMenu;
import org.apache.commons.collections.LRUMap;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testbeans.gui.GenericTestBeanCustomizer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TestBeanGUI
extends AbstractJMeterGuiComponent
implements JMeterGUIComponent {
    private static Logger log = LoggingManager.getLoggerForClass();
    private Class testBeanClass;
    private BeanInfo beanInfo;
    private Class customizerClass;
    private Customizer customizer = null;
    private Map customizers = new LRUMap(20);
    private int customizerIndexInPanel;
    private Map propertyMap = new HashMap();
    private boolean initialized = false;
    static /* synthetic */ Class class$org$apache$jmeter$testbeans$TestBean;
    static /* synthetic */ Class class$org$apache$jmeter$timers$Timer;
    static /* synthetic */ Class class$org$apache$jmeter$samplers$Sampler;
    static /* synthetic */ Class class$org$apache$jmeter$config$ConfigTestElement;
    static /* synthetic */ Class class$org$apache$jmeter$assertions$Assertion;
    static /* synthetic */ Class class$org$apache$jmeter$processor$PostProcessor;
    static /* synthetic */ Class class$org$apache$jmeter$processor$PreProcessor;
    static /* synthetic */ Class class$org$apache$jmeter$reporters$AbstractListenerElement;
    static /* synthetic */ Class class$org$apache$jmeter$assertions$gui$AbstractAssertionGui;
    static /* synthetic */ Class class$org$apache$jmeter$config$ConfigElement;
    static /* synthetic */ Class class$org$apache$jmeter$config$gui$AbstractConfigGui;
    static /* synthetic */ Class class$org$apache$jmeter$control$Controller;
    static /* synthetic */ Class class$org$apache$jmeter$control$gui$AbstractControllerGui;
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$Visualizer;
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$gui$AbstractVisualizer;
    static /* synthetic */ Class class$org$apache$jmeter$processor$gui$AbstractPostProcessorGui;
    static /* synthetic */ Class class$org$apache$jmeter$processor$gui$AbstractPreProcessorGui;
    static /* synthetic */ Class class$org$apache$jmeter$samplers$gui$AbstractSamplerGui;
    static /* synthetic */ Class class$org$apache$jmeter$timers$gui$AbstractTimerGui;
    static /* synthetic */ Class class$org$apache$jmeter$testbeans$gui$SharedCustomizer;

    TestBeanGUI() {
        log.warn("Only for use in testing");
    }

    public TestBeanGUI(Class testBeanClass) {
        log.debug("testing class: " + testBeanClass.getName());
        if (!(class$org$apache$jmeter$testbeans$TestBean == null ? (class$org$apache$jmeter$testbeans$TestBean = TestBeanGUI.class$("org.apache.jmeter.testbeans.TestBean")) : class$org$apache$jmeter$testbeans$TestBean).isAssignableFrom(testBeanClass)) {
            Error e = new Error();
            log.error("This should never happen!", (Throwable)e);
            throw e;
        }
        this.testBeanClass = testBeanClass;
        try {
            this.beanInfo = Introspector.getBeanInfo(testBeanClass);
        }
        catch (IntrospectionException e) {
            log.error("Can't get beanInfo for " + testBeanClass.getName(), (Throwable)e);
            throw new Error(e.toString());
        }
        this.customizerClass = this.beanInfo.getBeanDescriptor().getCustomizerClass();
        this.initialized = false;
    }

    private Customizer createCustomizer() {
        try {
            return (Customizer)this.customizerClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Could not instantiate customizer of class " + this.customizerClass, (Throwable)e);
            throw new Error(e.toString());
        }
        catch (IllegalAccessException e) {
            log.error("Could not instantiate customizer of class " + this.customizerClass, (Throwable)e);
            throw new Error(e.toString());
        }
    }

    public String getStaticLabel() {
        if (this.beanInfo == null) {
            return "null";
        }
        return this.beanInfo.getBeanDescriptor().getDisplayName();
    }

    public TestElement createTestElement() {
        try {
            TestElement element = (TestElement)this.testBeanClass.newInstance();
            this.modifyTestElement(element);
            return element;
        }
        catch (InstantiationException e) {
            log.error("Can't create test element", (Throwable)e);
            throw new Error(e.toString());
        }
        catch (IllegalAccessException e) {
            log.error("Can't create test element", (Throwable)e);
            throw new Error(e.toString());
        }
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            String name = props[i].getName();
            Object value = this.propertyMap.get(name);
            log.debug("Modify " + name + " to " + value);
            if (value == null) {
                if (((Boolean)props[i].getValue("notUndefined")).booleanValue()) {
                    this.setPropertyInElement(element, name, props[i].getValue("default"));
                    continue;
                }
                element.removeProperty(name);
                continue;
            }
            this.setPropertyInElement(element, name, this.propertyMap.get(name));
        }
    }

    private void setPropertyInElement(TestElement element, String name, Object value) {
        JMeterProperty jprop = AbstractProperty.createProperty(value);
        jprop.setName(name);
        element.setProperty(jprop);
    }

    public JPopupMenu createPopupMenu() {
        if ((class$org$apache$jmeter$timers$Timer == null ? (class$org$apache$jmeter$timers$Timer = TestBeanGUI.class$("org.apache.jmeter.timers.Timer")) : class$org$apache$jmeter$timers$Timer).isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultTimerMenu();
        }
        if ((class$org$apache$jmeter$samplers$Sampler == null ? (class$org$apache$jmeter$samplers$Sampler = TestBeanGUI.class$("org.apache.jmeter.samplers.Sampler")) : class$org$apache$jmeter$samplers$Sampler).isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultSamplerMenu();
        }
        if ((class$org$apache$jmeter$config$ConfigTestElement == null ? (class$org$apache$jmeter$config$ConfigTestElement = TestBeanGUI.class$("org.apache.jmeter.config.ConfigTestElement")) : class$org$apache$jmeter$config$ConfigTestElement).isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultConfigElementMenu();
        }
        if ((class$org$apache$jmeter$assertions$Assertion == null ? (class$org$apache$jmeter$assertions$Assertion = TestBeanGUI.class$("org.apache.jmeter.assertions.Assertion")) : class$org$apache$jmeter$assertions$Assertion).isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultAssertionMenu();
        }
        if ((class$org$apache$jmeter$processor$PostProcessor == null ? (class$org$apache$jmeter$processor$PostProcessor = TestBeanGUI.class$("org.apache.jmeter.processor.PostProcessor")) : class$org$apache$jmeter$processor$PostProcessor).isAssignableFrom(this.testBeanClass) || (class$org$apache$jmeter$processor$PreProcessor == null ? (class$org$apache$jmeter$processor$PreProcessor = TestBeanGUI.class$("org.apache.jmeter.processor.PreProcessor")) : class$org$apache$jmeter$processor$PreProcessor).isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultExtractorMenu();
        }
        if ((class$org$apache$jmeter$reporters$AbstractListenerElement == null ? (class$org$apache$jmeter$reporters$AbstractListenerElement = TestBeanGUI.class$("org.apache.jmeter.reporters.AbstractListenerElement")) : class$org$apache$jmeter$reporters$AbstractListenerElement).isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultVisualizerMenu();
        }
        return MenuFactory.getDefaultControllerMenu();
    }

    public void configure(TestElement element) {
        if (!this.initialized) {
            this.init();
        }
        this.clear();
        super.configure(element);
        PropertyIterator jprops = element.propertyIterator();
        while (jprops.hasNext()) {
            JMeterProperty jprop = jprops.next();
            this.propertyMap.put(jprop.getName(), jprop.getObjectValue());
        }
        if (this.customizer != null) {
            this.customizer.setObject(this.propertyMap);
        } else {
            Customizer c;
            if (this.initialized) {
                this.remove(this.customizerIndexInPanel);
            }
            if ((c = (Customizer)this.customizers.get(element)) == null) {
                c = this.createCustomizer();
                c.setObject(this.propertyMap);
                this.customizers.put(element, c);
            }
            this.add((Component)((Object)c), "Center");
        }
        this.initialized = true;
    }

    public Collection getMenuCategories() {
        LinkedList<String> menuCategories = new LinkedList<String>();
        BeanDescriptor bd = this.beanInfo.getBeanDescriptor();
        if (bd.isExpert() && !JMeterUtils.isExpertMode()) {
            return null;
        }
        int matches = 0;
        if ((class$org$apache$jmeter$assertions$Assertion == null ? (class$org$apache$jmeter$assertions$Assertion = TestBeanGUI.class$("org.apache.jmeter.assertions.Assertion")) : class$org$apache$jmeter$assertions$Assertion).isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_assertions");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$assertions$gui$AbstractAssertionGui == null ? (class$org$apache$jmeter$assertions$gui$AbstractAssertionGui = TestBeanGUI.class$("org.apache.jmeter.assertions.gui.AbstractAssertionGui")) : class$org$apache$jmeter$assertions$gui$AbstractAssertionGui).getName());
            ++matches;
        }
        if ((class$org$apache$jmeter$config$ConfigElement == null ? (class$org$apache$jmeter$config$ConfigElement = TestBeanGUI.class$("org.apache.jmeter.config.ConfigElement")) : class$org$apache$jmeter$config$ConfigElement).isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_config_element");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$config$gui$AbstractConfigGui == null ? (class$org$apache$jmeter$config$gui$AbstractConfigGui = TestBeanGUI.class$("org.apache.jmeter.config.gui.AbstractConfigGui")) : class$org$apache$jmeter$config$gui$AbstractConfigGui).getName());
            ++matches;
        }
        if ((class$org$apache$jmeter$control$Controller == null ? (class$org$apache$jmeter$control$Controller = TestBeanGUI.class$("org.apache.jmeter.control.Controller")) : class$org$apache$jmeter$control$Controller).isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_logic_controller");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$control$gui$AbstractControllerGui == null ? (class$org$apache$jmeter$control$gui$AbstractControllerGui = TestBeanGUI.class$("org.apache.jmeter.control.gui.AbstractControllerGui")) : class$org$apache$jmeter$control$gui$AbstractControllerGui).getName());
            ++matches;
        }
        if ((class$org$apache$jmeter$visualizers$Visualizer == null ? (class$org$apache$jmeter$visualizers$Visualizer = TestBeanGUI.class$("org.apache.jmeter.visualizers.Visualizer")) : class$org$apache$jmeter$visualizers$Visualizer).isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_listener");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$visualizers$gui$AbstractVisualizer == null ? (class$org$apache$jmeter$visualizers$gui$AbstractVisualizer = TestBeanGUI.class$("org.apache.jmeter.visualizers.gui.AbstractVisualizer")) : class$org$apache$jmeter$visualizers$gui$AbstractVisualizer).getName());
            ++matches;
        }
        if ((class$org$apache$jmeter$processor$PostProcessor == null ? (class$org$apache$jmeter$processor$PostProcessor = TestBeanGUI.class$("org.apache.jmeter.processor.PostProcessor")) : class$org$apache$jmeter$processor$PostProcessor).isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_post_processors");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$processor$gui$AbstractPostProcessorGui == null ? (class$org$apache$jmeter$processor$gui$AbstractPostProcessorGui = TestBeanGUI.class$("org.apache.jmeter.processor.gui.AbstractPostProcessorGui")) : class$org$apache$jmeter$processor$gui$AbstractPostProcessorGui).getName());
            ++matches;
        }
        if ((class$org$apache$jmeter$processor$PreProcessor == null ? (class$org$apache$jmeter$processor$PreProcessor = TestBeanGUI.class$("org.apache.jmeter.processor.PreProcessor")) : class$org$apache$jmeter$processor$PreProcessor).isAssignableFrom(this.testBeanClass)) {
            ++matches;
            menuCategories.add("menu_pre_processors");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$processor$gui$AbstractPreProcessorGui == null ? (class$org$apache$jmeter$processor$gui$AbstractPreProcessorGui = TestBeanGUI.class$("org.apache.jmeter.processor.gui.AbstractPreProcessorGui")) : class$org$apache$jmeter$processor$gui$AbstractPreProcessorGui).getName());
        }
        if ((class$org$apache$jmeter$samplers$Sampler == null ? (class$org$apache$jmeter$samplers$Sampler = TestBeanGUI.class$("org.apache.jmeter.samplers.Sampler")) : class$org$apache$jmeter$samplers$Sampler).isAssignableFrom(this.testBeanClass)) {
            ++matches;
            menuCategories.add("menu_generative_controller");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$samplers$gui$AbstractSamplerGui == null ? (class$org$apache$jmeter$samplers$gui$AbstractSamplerGui = TestBeanGUI.class$("org.apache.jmeter.samplers.gui.AbstractSamplerGui")) : class$org$apache$jmeter$samplers$gui$AbstractSamplerGui).getName());
        }
        if ((class$org$apache$jmeter$timers$Timer == null ? (class$org$apache$jmeter$timers$Timer = TestBeanGUI.class$("org.apache.jmeter.timers.Timer")) : class$org$apache$jmeter$timers$Timer).isAssignableFrom(this.testBeanClass)) {
            ++matches;
            menuCategories.add("menu_timer");
            bd.setValue("TestElement.gui_class", (class$org$apache$jmeter$timers$gui$AbstractTimerGui == null ? (class$org$apache$jmeter$timers$gui$AbstractTimerGui = TestBeanGUI.class$("org.apache.jmeter.timers.gui.AbstractTimerGui")) : class$org$apache$jmeter$timers$gui$AbstractTimerGui).getName());
        }
        if (matches == 0) {
            log.error("Could not assign GUI class to " + this.testBeanClass.getName());
        } else if (matches > 1) {
            log.error("More than 1 GUI class found for " + this.testBeanClass.getName());
        }
        return menuCategories;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        this.customizerIndexInPanel = this.getComponentCount();
        if (this.customizerClass == null) {
            this.customizer = new GenericTestBeanCustomizer(this.beanInfo);
        } else if ((class$org$apache$jmeter$testbeans$gui$SharedCustomizer == null ? (class$org$apache$jmeter$testbeans$gui$SharedCustomizer = TestBeanGUI.class$("org.apache.jmeter.testbeans.gui.SharedCustomizer")) : class$org$apache$jmeter$testbeans$gui$SharedCustomizer).isAssignableFrom(this.customizerClass)) {
            this.customizer = this.createCustomizer();
        }
        if (this.customizer != null) {
            this.add((Component)((Object)this.customizer), "Center");
        }
    }

    public String getLabelResource() {
        return null;
    }

    public void clear() {
        super.clear();
        this.propertyMap.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LinkedList<String> paths = new LinkedList<String>();
        paths.add("org.apache.jmeter.testbeans.gui");
        paths.addAll(Arrays.asList(PropertyEditorManager.getEditorSearchPath()));
        String s = JMeterUtils.getPropDefault("propertyEditorSearchPath", null);
        if (s != null) {
            paths.addAll(Arrays.asList(JMeterUtils.split(s, ",", "")));
        }
        PropertyEditorManager.setEditorSearchPath(paths.toArray(new String[0]));
    }
}

