/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import javax.swing.JOptionPane;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

class WrapperEditor
extends PropertyEditorSupport
implements PropertyChangeListener {
    protected static Logger log = LoggingManager.getLoggerForClass();
    PropertyEditor typeEditor;
    PropertyEditor guiEditor;
    boolean acceptsNull;
    boolean acceptsExpressions;
    boolean acceptsOther;
    private String lastValidValue = null;

    WrapperEditor(Object source, PropertyEditor typeEditor, PropertyEditor guiEditor, boolean acceptsNull, boolean acceptsExpressions, boolean acceptsOther, Object defaultValue) {
        super(source);
        this.initialize(typeEditor, guiEditor, acceptsNull, acceptsExpressions, acceptsOther, defaultValue);
    }

    WrapperEditor(PropertyEditor typeEditor, PropertyEditor guiEditor, boolean acceptsNull, boolean acceptsExpressions, boolean acceptsOther, Object defaultValue) {
        this.initialize(typeEditor, guiEditor, acceptsNull, acceptsExpressions, acceptsOther, defaultValue);
    }

    private void initialize(PropertyEditor typeEditor, PropertyEditor guiEditor, boolean acceptsNull, boolean acceptsExpressions, boolean acceptsOther, Object defaultValue) {
        this.typeEditor = typeEditor;
        this.guiEditor = guiEditor;
        this.acceptsNull = acceptsNull;
        this.acceptsExpressions = acceptsExpressions;
        this.acceptsOther = acceptsOther;
        this.setValue(defaultValue);
        this.lastValidValue = this.getAsText();
        if (guiEditor instanceof ComboStringEditor) {
            String[] tags = ((ComboStringEditor)guiEditor).getTags();
            String v = !acceptsOther ? "${}" : (this.isValidValue("") ? "" : (acceptsExpressions ? "${}" : (tags != null && tags.length > 0 ? tags[0] : this.getAsText())));
            ((ComboStringEditor)guiEditor).setInitialEditValue(v);
        }
        guiEditor.addPropertyChangeListener(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this.guiEditor.getCustomEditor();
    }

    public String[] getTags() {
        return this.guiEditor.getTags();
    }

    private boolean isATag(String text) {
        String[] tags = this.getTags();
        if (tags == null) {
            return false;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].equals(text)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidValue(String text) {
        if (text == null) {
            return this.acceptsNull;
        }
        if (this.acceptsExpressions && this.isExpression(text)) {
            return true;
        }
        if (this.isATag(text)) {
            return true;
        }
        if (!this.acceptsOther) {
            return false;
        }
        try {
            this.typeEditor.setAsText(text);
        }
        catch (IllegalArgumentException e1) {
            return false;
        }
        return true;
    }

    private final void shouldNeverHappen() throws Error {
        throw new Error();
    }

    private final void shouldNeverHappen(Exception e) throws Error {
        throw new Error(e.toString());
    }

    private final boolean isExpression(String text) {
        return text.indexOf("${") != -1;
    }

    private final boolean isExpression(Object text) {
        return text instanceof String && this.isExpression((String)text);
    }

    public Object getValue() {
        Object value;
        String text = (String)this.guiEditor.getValue();
        if (text == null) {
            if (!this.acceptsNull) {
                this.shouldNeverHappen();
            }
            value = null;
        } else if (this.acceptsExpressions && this.isExpression(text)) {
            value = text;
        } else {
            if (!this.acceptsOther && !this.isATag(text)) {
                this.shouldNeverHappen();
            }
            try {
                this.typeEditor.setAsText(text);
            }
            catch (IllegalArgumentException e) {
                this.shouldNeverHappen(e);
            }
            value = this.typeEditor.getValue();
        }
        if (log.isDebugEnabled()) {
            log.debug("->" + (value != null ? value.getClass().getName() : "NULL") + ":" + value);
        }
        return value;
    }

    public void setValue(Object value) {
        String text;
        if (log.isDebugEnabled()) {
            log.debug("<-" + (value != null ? value.getClass().getName() : "NULL") + ":" + value);
        }
        if (value == null) {
            if (!this.acceptsNull) {
                throw new IllegalArgumentException();
            }
            text = null;
        } else if (this.acceptsExpressions && this.isExpression(value)) {
            text = (String)value;
        } else {
            this.typeEditor.setValue(value);
            text = this.typeEditor.getAsText();
            if (!this.acceptsOther && !this.isATag(text)) {
                throw new IllegalArgumentException();
            }
        }
        this.guiEditor.setValue(text);
    }

    public String getAsText() {
        String text = this.guiEditor.getAsText();
        if (text == null) {
            if (!this.acceptsNull) {
                this.shouldNeverHappen();
            }
        } else if (!this.acceptsExpressions || !this.isExpression(text)) {
            try {
                this.typeEditor.setAsText(text);
            }
            catch (IllegalArgumentException e) {
                this.shouldNeverHappen(e);
            }
            text = this.typeEditor.getAsText();
            if (!this.acceptsOther && !this.isATag(text)) {
                this.shouldNeverHappen();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("->\"" + text + "\"");
        }
        return text;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String value;
        if (log.isDebugEnabled()) {
            log.debug(text == null ? "<-null" : "<-\"" + text + "\"");
        }
        if (text == null) {
            if (!this.acceptsNull) {
                throw new IllegalArgumentException();
            }
            value = null;
        } else if (this.acceptsExpressions && this.isExpression(text)) {
            value = text;
        } else {
            this.typeEditor.setAsText(text);
            value = this.typeEditor.getAsText();
            if (!this.acceptsOther && !this.isATag(text)) {
                throw new IllegalArgumentException();
            }
        }
        this.guiEditor.setValue(value);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String text = this.guiEditor.getAsText();
        if (this.isValidValue(text)) {
            this.lastValidValue = text;
            this.firePropertyChange();
        } else {
            JOptionPane.showMessageDialog(this.guiEditor.getCustomEditor().getParent(), JMeterUtils.getResString("property_editor.value_is_invalid_message"), JMeterUtils.getResString("property_editor.value_is_invalid_title"), 2);
            this.guiEditor.setAsText(this.lastValidValue);
        }
    }
}

