/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementTraverser;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.PropertyIteratorImpl;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractTestElement
implements TestElement,
Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private Map propMap = Collections.synchronizedMap(new HashMap());
    private transient Set temporaryProperties;
    private transient boolean runningVersion = false;
    private transient JMeterContext threadContext = null;
    private transient String threadName = null;

    public Object clone() {
        TestElement clonedElement = null;
        try {
            clonedElement = (TestElement)this.getClass().newInstance();
            PropertyIterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                clonedElement.setProperty((JMeterProperty)iter.next().clone());
            }
            clonedElement.setRunningVersion(this.runningVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clonedElement;
    }

    public void clear() {
        this.propMap.clear();
    }

    public void removeProperty(String key) {
        this.propMap.remove(key);
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractTestElement) {
            return ((Object)((AbstractTestElement)o).propMap).equals(this.propMap);
        }
        return false;
    }

    public void addTestElement(TestElement el) {
        this.mergeIn(el);
    }

    public void setName(String name) {
        this.setProperty(new StringProperty("TestElement.name", name));
    }

    public String getName() {
        return this.getProperty("TestElement.name").getStringValue();
    }

    public JMeterProperty getProperty(String key) {
        JMeterProperty prop = (JMeterProperty)this.propMap.get(key);
        if (prop == null) {
            prop = new NullProperty(key);
        }
        return prop;
    }

    public void traverse(TestElementTraverser traverser) {
        PropertyIterator iter = this.propertyIterator();
        traverser.startTestElement(this);
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
        traverser.endTestElement(this);
    }

    protected void traverseProperty(TestElementTraverser traverser, JMeterProperty value) {
        traverser.startProperty(value);
        if (value instanceof TestElementProperty) {
            ((TestElement)value.getObjectValue()).traverse(traverser);
        } else if (value instanceof CollectionProperty) {
            this.traverseCollection((CollectionProperty)value, traverser);
        } else if (value instanceof MapProperty) {
            this.traverseMap((MapProperty)value, traverser);
        }
        traverser.endProperty(value);
    }

    protected void traverseMap(MapProperty map, TestElementTraverser traverser) {
        PropertyIterator iter = map.valueIterator();
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
    }

    protected void traverseCollection(CollectionProperty col, TestElementTraverser traverser) {
        PropertyIterator iter = col.iterator();
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
    }

    public int getPropertyAsInt(String key) {
        return this.getProperty(key).getIntValue();
    }

    public boolean getPropertyAsBoolean(String key) {
        return this.getProperty(key).getBooleanValue();
    }

    public boolean getPropertyAsBoolean(String key, boolean defaultVal) {
        JMeterProperty jmp = this.getProperty(key);
        return jmp instanceof NullProperty ? defaultVal : jmp.getBooleanValue();
    }

    public float getPropertyAsFloat(String key) {
        return this.getProperty(key).getFloatValue();
    }

    public long getPropertyAsLong(String key) {
        return this.getProperty(key).getLongValue();
    }

    public double getPropertyAsDouble(String key) {
        return this.getProperty(key).getDoubleValue();
    }

    public String getPropertyAsString(String key) {
        return this.getProperty(key).getStringValue();
    }

    protected void addProperty(JMeterProperty property) {
        if (this.isRunningVersion()) {
            this.setTemporary(property);
        } else {
            this.clearTemporary(property);
        }
        JMeterProperty prop = this.getProperty(property.getName());
        if (prop instanceof NullProperty || prop instanceof StringProperty && prop.getStringValue().equals("")) {
            this.propMap.put(property.getName(), property);
        } else {
            prop.mergeIn(property);
        }
    }

    protected void clearTemporary(JMeterProperty property) {
        if (this.temporaryProperties != null) {
            this.temporaryProperties.remove(property);
        }
    }

    protected void logProperties() {
        if (log.isDebugEnabled()) {
            PropertyIterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                JMeterProperty prop = iter.next();
                log.debug("Property " + prop.getName() + " is temp? " + this.isTemporary(prop) + " and is a " + prop.getObjectValue());
            }
        }
    }

    public void setProperty(JMeterProperty property) {
        if (this.isRunningVersion()) {
            if (this.getProperty(property.getName()) instanceof NullProperty) {
                this.addProperty(property);
            } else {
                this.getProperty(property.getName()).setObjectValue(property.getObjectValue());
            }
        } else {
            this.propMap.put(property.getName(), property);
        }
    }

    public void setProperty(String name, String value) {
        this.setProperty(new StringProperty(name, value));
    }

    public PropertyIterator propertyIterator() {
        return new PropertyIteratorImpl(this.propMap.values());
    }

    protected void mergeIn(TestElement element) {
        PropertyIterator iter = element.propertyIterator();
        while (iter.hasNext()) {
            JMeterProperty prop = iter.next();
            this.addProperty(prop);
        }
    }

    public boolean isRunningVersion() {
        return this.runningVersion;
    }

    public void setRunningVersion(boolean runningVersion) {
        this.runningVersion = runningVersion;
        PropertyIterator iter = this.propertyIterator();
        while (iter.hasNext()) {
            iter.next().setRunningVersion(runningVersion);
        }
    }

    public void recoverRunningVersion() {
        Iterator iter = this.propMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            JMeterProperty prop = (JMeterProperty)entry.getValue();
            if (this.isTemporary(prop)) {
                iter.remove();
                this.clearTemporary(prop);
                continue;
            }
            prop.recoverRunningVersion(this);
        }
        this.emptyTemporary();
    }

    protected void emptyTemporary() {
        if (this.temporaryProperties != null) {
            this.temporaryProperties.clear();
        }
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        return null;
    }

    public boolean isTemporary(JMeterProperty property) {
        if (this.temporaryProperties == null) {
            return false;
        }
        return this.temporaryProperties.contains(property);
    }

    public void setTemporary(JMeterProperty property) {
        if (this.temporaryProperties == null) {
            this.temporaryProperties = new HashSet();
        }
        this.temporaryProperties.add(property);
        if (property instanceof MultiProperty) {
            PropertyIterator iter = ((MultiProperty)property).iterator();
            while (iter.hasNext()) {
                this.setTemporary(iter.next());
            }
        }
    }

    public JMeterContext getThreadContext() {
        if (this.threadContext == null) {
            this.threadContext = JMeterContextService.getContext();
        }
        return this.threadContext;
    }

    public void setThreadContext(JMeterContext inthreadContext) {
        if (this.threadContext != null && inthreadContext != this.threadContext) {
            throw new RuntimeException("Attempting to reset the thread context");
        }
        this.threadContext = inthreadContext;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String inthreadName) {
        if (this.threadName != null && !this.threadName.equals(inthreadName)) {
            throw new RuntimeException("Attempting to reset the thread name");
        }
        this.threadName = inthreadName;
    }

    public void threadFinished() {
    }

    public void threadStarted() {
    }

    public boolean canRemove() {
        return true;
    }

    public boolean isEnabled() {
        return this.getProperty("TestElement.enabled") instanceof NullProperty || this.getPropertyAsBoolean("TestElement.enabled");
    }
}

