/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.DoubleProperty;
import org.apache.jmeter.testelement.property.FloatProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.PropertyIteratorImpl;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractProperty
implements JMeterProperty {
    protected static final Logger log = LoggingManager.getLoggerForClass();
    private String name;
    private transient boolean runningVersion = false;

    public AbstractProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
    }

    public AbstractProperty() {
        this("");
    }

    protected boolean isEqualType(JMeterProperty prop) {
        return this.getClass().equals(prop.getClass());
    }

    public boolean isRunningVersion() {
        return this.runningVersion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
    }

    public void setRunningVersion(boolean runningVersion) {
        this.runningVersion = runningVersion;
    }

    protected PropertyIterator getIterator(Collection values) {
        return new PropertyIteratorImpl(values);
    }

    public Object clone() {
        try {
            AbstractProperty prop = (AbstractProperty)this.getClass().newInstance();
            prop.name = this.name;
            prop.runningVersion = this.runningVersion;
            return prop;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public int getIntValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getLongValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0L;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public double getDoubleValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            log.error("Tried to parse a non-number string to an integer", (Throwable)e);
            return 0.0;
        }
    }

    public float getFloatValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            log.error("Tried to parse a non-number string to an integer", (Throwable)e);
            return 0.0f;
        }
    }

    public boolean getBooleanValue() {
        String val = this.getStringValue();
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JMeterProperty)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        JMeterProperty jpo = (JMeterProperty)o;
        if (!this.name.equals(jpo.getName())) {
            return false;
        }
        String s1 = this.getStringValue();
        String s2 = jpo.getStringValue();
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.name.hashCode();
        String s = this.getStringValue();
        result = result * 37 + (s == null ? 0 : s.hashCode());
        return result;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof JMeterProperty) {
            String val = this.getStringValue();
            String val2 = ((JMeterProperty)arg0).getStringValue();
            if (val == null) {
                log.warn("Warning: Unexpected null value for property: " + this.name);
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            return val.compareTo(val2);
        }
        return -1;
    }

    protected Class getPropertyType() {
        return this.getClass();
    }

    protected JMeterProperty getBlankProperty() {
        try {
            JMeterProperty prop = (JMeterProperty)this.getPropertyType().newInstance();
            if (prop instanceof NullProperty) {
                return new StringProperty();
            }
            return prop;
        }
        catch (Exception e) {
            return new StringProperty();
        }
    }

    protected static JMeterProperty getBlankProperty(Object item) {
        if (item == null) {
            return new NullProperty();
        }
        if (item instanceof String) {
            return new StringProperty("", item.toString());
        }
        if (item instanceof Boolean) {
            return new BooleanProperty("", (Boolean)item);
        }
        if (item instanceof Float) {
            return new FloatProperty("", ((Float)item).floatValue());
        }
        if (item instanceof Double) {
            return new DoubleProperty("", (Double)item);
        }
        if (item instanceof Integer) {
            return new IntegerProperty("", (Integer)item);
        }
        if (item instanceof Long) {
            return new LongProperty("", (Long)item);
        }
        if (item instanceof Long) {
            return new LongProperty("", (Long)item);
        }
        return new StringProperty("", item.toString());
    }

    protected Collection normalizeList(Collection coll) {
        Iterator iter = coll.iterator();
        Collection newColl = null;
        while (iter.hasNext()) {
            Object item = iter.next();
            if (newColl == null) {
                try {
                    newColl = (Collection)coll.getClass().newInstance();
                }
                catch (Exception e) {
                    log.error("Bad collection", (Throwable)e);
                }
            }
            newColl.add(this.convertObject(item));
        }
        if (newColl != null) {
            return newColl;
        }
        return coll;
    }

    protected Map normalizeMap(Map coll) {
        Iterator iter = coll.keySet().iterator();
        Map newColl = null;
        while (iter.hasNext()) {
            Object item = iter.next();
            Object prop = coll.get(item);
            if (newColl == null) {
                try {
                    newColl = (Map)coll.getClass().newInstance();
                }
                catch (Exception e) {
                    log.error("Bad collection", (Throwable)e);
                }
            }
            newColl.put(item, this.convertObject(prop));
        }
        if (newColl != null) {
            return newColl;
        }
        return coll;
    }

    public static JMeterProperty createProperty(Object item) {
        JMeterProperty prop = AbstractProperty.makeProperty(item);
        if (prop == null) {
            prop = AbstractProperty.getBlankProperty(item);
        }
        return prop;
    }

    protected static JMeterProperty makeProperty(Object item) {
        if (item instanceof JMeterProperty) {
            return (JMeterProperty)item;
        }
        if (item instanceof TestElement) {
            return new TestElementProperty(((TestElement)item).getPropertyAsString("TestElement.name"), (TestElement)item);
        }
        if (item instanceof Collection) {
            return new CollectionProperty("" + item.hashCode(), (Collection)item);
        }
        if (item instanceof Map) {
            return new MapProperty("" + item.hashCode(), (Map)item);
        }
        return null;
    }

    protected JMeterProperty convertObject(Object item) {
        JMeterProperty prop = AbstractProperty.makeProperty(item);
        if (prop == null) {
            prop = this.getBlankProperty();
            prop.setName("" + item.hashCode());
            prop.setObjectValue(item);
        }
        return prop;
    }

    public String toString() {
        return this.getStringValue();
    }

    public void mergeIn(JMeterProperty prop) {
    }
}

