/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;

public class FunctionProperty
extends AbstractProperty {
    CompoundVariable function;
    int testIteration = -1;
    String cacheValue;

    public FunctionProperty(String name, CompoundVariable func) {
        super(name);
        this.function = func;
    }

    public FunctionProperty() {
    }

    public void setObjectValue(Object v) {
        if (v instanceof CompoundVariable && !this.isRunningVersion()) {
            this.function = (CompoundVariable)v;
        } else {
            this.cacheValue = v.toString();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof FunctionProperty && this.function != null) {
            return this.function.equals(((JMeterProperty)o).getObjectValue());
        }
        return false;
    }

    public String getStringValue() {
        int iter;
        JMeterContext ctx = JMeterContextService.getContext();
        if (!this.isRunningVersion()) {
            log.debug("Not running version, return raw function string");
            return this.function.getRawParameters();
        }
        if (!ctx.isSamplingStarted()) {
            return this.function.execute();
        }
        log.debug("Running version, executing function");
        int n = iter = ctx.getVariables() != null ? ctx.getVariables().getIteration() : -1;
        if (iter < this.testIteration) {
            this.testIteration = -1;
        }
        if (iter > this.testIteration || this.cacheValue == null) {
            this.testIteration = iter;
            this.cacheValue = this.function.execute();
        }
        return this.cacheValue;
    }

    public Object getObjectValue() {
        return this.function;
    }

    public Object clone() {
        FunctionProperty prop = (FunctionProperty)super.clone();
        prop.cacheValue = this.cacheValue;
        prop.testIteration = this.testIteration;
        prop.function = this.function;
        return prop;
    }

    public void recoverRunningVersion(TestElement owner) {
        this.cacheValue = null;
    }
}

