/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import org.apache.jmeter.threads.JMeterContext;

public final class JMeterContextService
implements Serializable {
    private static ThreadLocal threadContext = new ThreadLocal(){

        public Object initialValue() {
            return new JMeterContext();
        }
    };
    private static long testStart = 0L;
    private static int numberOfThreads = 0;

    private JMeterContextService() {
    }

    public static JMeterContext getContext() {
        return (JMeterContext)threadContext.get();
    }

    public static void startTest() {
        if (testStart == 0L) {
            numberOfThreads = 0;
            testStart = System.currentTimeMillis();
            threadContext = new ThreadLocal(){

                public Object initialValue() {
                    return new JMeterContext();
                }
            };
        }
    }

    static synchronized void incrNumberOfThreads() {
        ++numberOfThreads;
    }

    static synchronized void decrNumberOfThreads() {
        --numberOfThreads;
    }

    public static synchronized int getNumberOfThreads() {
        return numberOfThreads;
    }

    public static void endTest() {
        testStart = 0L;
        numberOfThreads = 0;
    }

    public static long getTestStartTime() {
        return testStart;
    }
}

