/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopTestException;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class JMeterThread
implements Runnable,
Serializable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private int initialDelay = 0;
    private Controller controller;
    private boolean running;
    private HashTree testTree;
    private transient TestCompiler compiler;
    private JMeterThreadMonitor monitor;
    private String threadName;
    private transient JMeterContext threadContext;
    private transient JMeterVariables threadVars;
    private Collection testListeners;
    private transient ListenerNotifier notifier;
    private int threadNum = 0;
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean scheduler = false;
    private ThreadGroup threadGroup;
    private StandardJMeterEngine engine = null;
    private boolean onErrorStopTest;
    private boolean onErrorStopThread;
    public static final String PACKAGE_OBJECT = "JMeterThread.pack";
    public static final String LAST_SAMPLE_OK = "JMeterThread.last_sample_ok";
    private static final boolean startEarlier = JMeterUtils.getPropDefault("jmeterthread.startearlier", true);
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestListener;

    public JMeterThread() {
    }

    public JMeterThread(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier note) {
        this.monitor = monitor;
        this.threadVars = new JMeterVariables();
        this.testTree = test;
        this.compiler = new TestCompiler(this.testTree, this.threadVars);
        this.controller = (Controller)this.testTree.getArray()[0];
        SearchByClass threadListenerSearcher = new SearchByClass(class$org$apache$jmeter$testelement$TestListener == null ? (class$org$apache$jmeter$testelement$TestListener = JMeterThread.class$("org.apache.jmeter.testelement.TestListener")) : class$org$apache$jmeter$testelement$TestListener);
        test.traverse((HashTreeTraverser)threadListenerSearcher);
        this.testListeners = threadListenerSearcher.getSearchResults();
        this.notifier = note;
        this.running = true;
    }

    public void setInitialContext(JMeterContext context) {
        this.threadVars.putAll(context.getVariables());
    }

    public boolean isScheduled() {
        return this.scheduler;
    }

    public void setScheduled(boolean sche) {
        this.scheduler = sche;
    }

    public void setStartTime(long stime) {
        this.startTime = stime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long etime) {
        this.endTime = etime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private void stopScheduler() {
        long delay = System.currentTimeMillis() - this.endTime;
        if (delay >= 0L) {
            this.running = false;
        }
    }

    private void startScheduler() {
        long delay = this.startTime - System.currentTimeMillis();
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.initRun();
                while (this.running) {
                    Sampler sam;
                    while (this.running && (sam = this.controller.next()) != null) {
                        try {
                            this.threadContext.setCurrentSampler(sam);
                            SamplePackage pack = this.compiler.configureSampler(sam);
                            this.threadContext.getVariables().putObject(PACKAGE_OBJECT, pack);
                            this.delay(pack.getTimers());
                            Sampler sampler = pack.getSampler();
                            sampler.setThreadContext(this.threadContext);
                            sampler.setThreadName(this.threadName);
                            TestBeanHelper.prepare(sampler);
                            SampleResult result = sampler.sample(null);
                            if (result != null) {
                                result.setThreadName(this.threadName);
                                this.threadContext.setPreviousResult(result);
                                this.runPostProcessors(pack.getPostProcessors());
                                this.checkAssertions(pack.getAssertions(), result);
                                this.notifyListeners(pack.getSampleListeners(), result);
                                this.compiler.done(pack);
                                if (result.isStopThread() || !result.isSuccessful() && this.onErrorStopThread) {
                                    this.stopThread();
                                }
                                if (result.isStopTest() || !result.isSuccessful() && this.onErrorStopTest) {
                                    this.stopTest();
                                }
                            }
                            if (!this.scheduler) continue;
                            this.stopScheduler();
                        }
                        catch (JMeterStopTestException e) {
                            log.info("Stopping Test: " + e.toString());
                            this.stopTest();
                        }
                        catch (JMeterStopThreadException e) {
                            log.info("Stopping Thread: " + e.toString());
                            this.stopThread();
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                    }
                    if (!this.controller.isDone()) continue;
                    this.running = false;
                }
                Object var6_13 = null;
                this.threadContext.clear();
            }
            catch (JMeterStopTestException e) {
                log.info("Stopping Test: " + e.toString());
                this.stopTest();
                Object var6_14 = null;
                this.threadContext.clear();
                log.info("Thread " + this.threadName + " is done");
                this.monitor.threadFinished(this);
                this.threadFinished();
                return;
            }
            catch (JMeterStopThreadException e) {
                log.info("Stop Thread seen: " + e.toString());
                Object var6_15 = null;
                this.threadContext.clear();
                log.info("Thread " + this.threadName + " is done");
                this.monitor.threadFinished(this);
                this.threadFinished();
                return;
            }
            catch (Exception e) {
                log.error("Test failed!", (Throwable)e);
                Object var6_16 = null;
                this.threadContext.clear();
                log.info("Thread " + this.threadName + " is done");
                this.monitor.threadFinished(this);
                this.threadFinished();
                return;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error e) {
                log.error("Test failed!", (Throwable)e);
                Object var6_17 = null;
                this.threadContext.clear();
                log.info("Thread " + this.threadName + " is done");
                this.monitor.threadFinished(this);
                this.threadFinished();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_18 = null;
            this.threadContext.clear();
            log.info("Thread " + this.threadName + " is done");
            this.monitor.threadFinished(this);
            this.threadFinished();
            throw throwable;
        }
        log.info("Thread " + this.threadName + " is done");
        this.monitor.threadFinished(this);
        this.threadFinished();
    }

    protected void initRun() {
        JMeterContextService.incrNumberOfThreads();
        this.threadGroup.incrNumberOfThreads();
        this.threadContext = JMeterContextService.getContext();
        this.threadContext.setVariables(this.threadVars);
        this.threadContext.setThreadNum(this.getThreadNum());
        this.threadContext.getVariables().put(LAST_SAMPLE_OK, "true");
        this.threadContext.setThread(this);
        this.testTree.traverse((HashTreeTraverser)this.compiler);
        if (this.scheduler) {
            this.startScheduler();
        }
        this.rampUpDelay();
        log.info("Thread " + Thread.currentThread().getName() + " started");
        if (startEarlier) {
            this.threadContext.setSamplingStarted(true);
        }
        this.controller.initialize();
        this.controller.addIterationListener(new IterationListener());
        if (!startEarlier) {
            this.threadContext.setSamplingStarted(true);
        }
        this.threadStarted();
    }

    private void threadStarted() {
        Traverser startup = new Traverser(true);
        this.testTree.traverse((HashTreeTraverser)startup);
    }

    private void threadFinished() {
        Traverser shut = new Traverser(false);
        this.testTree.traverse((HashTreeTraverser)shut);
        JMeterContextService.decrNumberOfThreads();
        this.threadGroup.decrNumberOfThreads();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void stop() {
        this.running = false;
        log.info("Stopping " + this.threadName);
    }

    private void stopTest() {
        this.running = false;
        log.info("Stop Test detected by thread " + this.threadName);
        if (this.engine != null) {
            this.engine.askThreadsToStop();
        }
    }

    private void stopThread() {
        this.running = false;
        log.info("Stop Thread detected by thread " + this.threadName);
    }

    public void pauseThread(int milis) {
        try {
            Thread.sleep(milis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void checkAssertions(List assertions, SampleResult result) {
        Iterator iter = assertions.iterator();
        while (iter.hasNext()) {
            Assertion assertion = (Assertion)iter.next();
            TestBeanHelper.prepare((TestElement)((Object)assertion));
            AssertionResult assertionResult = assertion.getResult(result);
            result.setSuccessful(result.isSuccessful() && !assertionResult.isError() && !assertionResult.isFailure());
            result.addAssertionResult(assertionResult);
        }
        this.threadContext.getVariables().put(LAST_SAMPLE_OK, JOrphanUtils.booleanToString((boolean)result.isSuccessful()));
    }

    private void runPostProcessors(List extractors) {
        ListIterator iter = extractors.listIterator(extractors.size());
        while (iter.hasPrevious()) {
            PostProcessor ex = (PostProcessor)iter.previous();
            TestBeanHelper.prepare((TestElement)((Object)ex));
            ex.process();
        }
    }

    private void delay(List timers) {
        int sum = 0;
        Iterator iter = timers.iterator();
        while (iter.hasNext()) {
            Timer timer = (Timer)iter.next();
            TestBeanHelper.prepare((TestElement)((Object)timer));
            sum = (int)((long)sum + timer.delay());
        }
        if (sum > 0) {
            try {
                Thread.sleep(sum);
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private void notifyTestListeners() {
        this.threadVars.incIteration();
        Iterator iter = this.testListeners.iterator();
        while (iter.hasNext()) {
            TestListener listener = (TestListener)iter.next();
            if (listener instanceof TestElement) {
                listener.testIterationStart(new LoopIterationEvent(this.controller, this.threadVars.getIteration()));
                ((TestElement)((Object)listener)).recoverRunningVersion();
                continue;
            }
            listener.testIterationStart(new LoopIterationEvent(this.controller, this.threadVars.getIteration()));
        }
    }

    private void notifyListeners(List listeners, SampleResult result) {
        SampleEvent event = new SampleEvent(result, this.controller.getPropertyAsString("TestElement.name"));
        this.compiler.sampleOccurred(event);
        this.notifier.notifyListeners(event, listeners);
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    private void rampUpDelay() {
        if (this.initialDelay > 0) {
            try {
                Thread.sleep(this.initialDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public void setEngine(StandardJMeterEngine engine) {
        this.engine = engine;
    }

    public void setOnErrorStopTest(boolean b) {
        this.onErrorStopTest = b;
    }

    public void setOnErrorStopThread(boolean b) {
        this.onErrorStopThread = b;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void setThreadGroup(ThreadGroup group) {
        this.threadGroup = group;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (startEarlier) {
            log.warn("jmeterthread.startearlier=true (see jmeter.properties)");
        } else {
            log.info("jmeterthread.startearlier=false (see jmeter.properties)");
        }
    }

    private class IterationListener
    implements LoopIterationListener {
        private IterationListener() {
        }

        public void iterationStart(LoopIterationEvent iterEvent) {
            JMeterThread.this.notifyTestListeners();
        }
    }

    private class Traverser
    implements HashTreeTraverser {
        private boolean isStart = false;

        private Traverser(boolean start) {
            this.isStart = start;
        }

        public void addNode(Object node, HashTree subTree) {
            if (node instanceof TestElement) {
                TestElement te = (TestElement)node;
                if (this.isStart) {
                    te.threadStarted();
                } else {
                    te.threadFinished();
                }
            }
        }

        public void subtractNode() {
        }

        public void processPath() {
        }
    }
}

