/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.Timer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SamplePackage {
    private static Logger log = LoggingManager.getLoggerForClass();
    List sampleListeners = new LinkedList();
    List timers = new LinkedList();
    List assertions = new LinkedList();
    List postProcessors = new LinkedList();
    List preProcessors = new LinkedList();
    List responseModifiers;
    List configs;
    List modifiers;
    List controllers;
    Sampler sampler;

    public SamplePackage() {
    }

    public SamplePackage(List configs, List modifiers, List responseModifiers, List listeners, List timers, List assertions, List extractors, List pres, List controllers) {
        log.debug("configs is null: " + (configs == null));
        this.configs = configs;
        this.modifiers = modifiers;
        this.responseModifiers = responseModifiers;
        this.sampleListeners = listeners;
        this.timers = timers;
        this.assertions = assertions;
        this.postProcessors = extractors;
        this.preProcessors = pres;
        this.controllers = controllers;
    }

    public void setRunningVersion(boolean running) {
        this.setRunningVersion(this.configs, running);
        this.setRunningVersion(this.modifiers, running);
        this.setRunningVersion(this.sampleListeners, running);
        this.setRunningVersion(this.assertions, running);
        this.setRunningVersion(this.timers, running);
        this.setRunningVersion(this.responseModifiers, running);
        this.setRunningVersion(this.postProcessors, running);
        this.setRunningVersion(this.preProcessors, running);
        this.setRunningVersion(this.controllers, running);
        this.sampler.setRunningVersion(running);
    }

    private void setRunningVersion(List list, boolean running) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ((TestElement)iter.next()).setRunningVersion(running);
        }
    }

    private void recoverRunningVersion(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ((TestElement)iter.next()).recoverRunningVersion();
        }
    }

    public void recoverRunningVersion() {
        this.recoverRunningVersion(this.configs);
        this.recoverRunningVersion(this.modifiers);
        this.recoverRunningVersion(this.sampleListeners);
        this.recoverRunningVersion(this.assertions);
        this.recoverRunningVersion(this.timers);
        this.recoverRunningVersion(this.responseModifiers);
        this.recoverRunningVersion(this.postProcessors);
        this.recoverRunningVersion(this.preProcessors);
        this.recoverRunningVersion(this.controllers);
        this.sampler.recoverRunningVersion();
    }

    public List getSampleListeners() {
        return this.sampleListeners;
    }

    public void addSampleListener(SampleListener listener) {
        this.sampleListeners.add(listener);
    }

    public List getTimers() {
        return this.timers;
    }

    public void addPostProcessor(PostProcessor ex) {
        this.postProcessors.add(ex);
    }

    public void addPreProcessor(PreProcessor pre) {
        this.preProcessors.add(pre);
    }

    public void addTimer(Timer timer) {
        this.timers.add(timer);
    }

    public void addAssertion(Assertion asser) {
        this.assertions.add(asser);
    }

    public List getAssertions() {
        return this.assertions;
    }

    public List getPostProcessors() {
        return this.postProcessors;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public void setSampler(Sampler s) {
        this.sampler = s;
    }

    public List getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(List preProcessors) {
        this.preProcessors = preProcessors;
    }

    public List getConfigs() {
        return this.configs;
    }

    public List getModifiers() {
        return this.modifiers;
    }

    public List getResponseModifiers() {
        return this.responseModifiers;
    }

    public void setAssertions(List assertions) {
        this.assertions = assertions;
    }

    public void setConfigs(List configs) {
        this.configs = configs;
    }

    public void setModifiers(List modifiers) {
        this.modifiers = modifiers;
    }

    public void setPostProcessors(List postProcessors) {
        this.postProcessors = postProcessors;
    }

    public void setResponseModifiers(List responseModifiers) {
        this.responseModifiers = responseModifiers;
    }

    public void setSampleListeners(List sampleListeners) {
        this.sampleListeners = sampleListeners;
    }

    public void setTimers(List timers) {
        this.timers = timers;
    }
}

