/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.timers.Timer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TestCompiler
implements HashTreeTraverser,
SampleListener {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private LinkedList stack = new LinkedList();
    private Map samplerConfigMap = new HashMap();
    private HashTree testTree;
    private static Set pairing = new HashSet();
    List loopIterListeners = new ArrayList();

    public TestCompiler(HashTree testTree, JMeterVariables vars) {
        this.testTree = testTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Set set = pairing;
        synchronized (set) {
            pairing.clear();
        }
    }

    public void sampleOccurred(SampleEvent e) {
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public SamplePackage configureSampler(Sampler sampler) {
        SamplePackage pack = (SamplePackage)this.samplerConfigMap.get(sampler);
        pack.setSampler(sampler);
        this.configureWithConfigElements(sampler, pack.getConfigs());
        this.runPreProcessors(pack.getPreProcessors());
        return pack;
    }

    private void runPreProcessors(List preProcessors) {
        Iterator iter = preProcessors.iterator();
        while (iter.hasNext()) {
            PreProcessor ex = (PreProcessor)iter.next();
            if (log.isDebugEnabled()) {
                log.debug("Running preprocessor: " + ((AbstractTestElement)((Object)ex)).getName());
            }
            TestBeanHelper.prepare((TestElement)((Object)ex));
            ex.process();
        }
    }

    public void done(SamplePackage pack) {
        pack.recoverRunningVersion();
    }

    public void addNode(Object node, HashTree subTree) {
        this.stack.addLast(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtractNode() {
        log.debug("Subtracting node, stack size = " + this.stack.size());
        TestElement child = (TestElement)this.stack.getLast();
        this.trackIterationListeners(this.stack);
        if (child instanceof Sampler) {
            this.saveSamplerConfigs((Sampler)child);
        }
        this.stack.removeLast();
        if (this.stack.size() > 0) {
            ObjectPair pair = new ObjectPair(child, (TestElement)this.stack.getLast());
            Set set = pairing;
            synchronized (set) {
                if (!pairing.contains(pair)) {
                    pair.addTestElements();
                    pairing.add(pair);
                }
            }
        }
    }

    private void trackIterationListeners(LinkedList p_stack) {
        TestElement child = (TestElement)p_stack.getLast();
        if (child instanceof LoopIterationListener) {
            ListIterator iter = p_stack.listIterator(p_stack.size());
            while (iter.hasPrevious()) {
                TestElement item = (TestElement)iter.previous();
                if (item == child || !(item instanceof Controller)) continue;
                TestBeanHelper.prepare(child);
                ((Controller)item).addIterationListener((LoopIterationListener)((Object)child));
                break;
            }
        }
    }

    public void processPath() {
    }

    private void saveSamplerConfigs(Sampler sam) {
        LinkedList<TestElement> configs = new LinkedList<TestElement>();
        LinkedList modifiers = new LinkedList();
        LinkedList controllers = new LinkedList();
        LinkedList responseModifiers = new LinkedList();
        LinkedList<TestElement> listeners = new LinkedList<TestElement>();
        LinkedList<TestElement> timers = new LinkedList<TestElement>();
        LinkedList<TestElement> assertions = new LinkedList<TestElement>();
        LinkedList posts = new LinkedList();
        LinkedList pres = new LinkedList();
        for (int i = this.stack.size(); i > 0; --i) {
            this.addDirectParentControllers(controllers, (TestElement)this.stack.get(i - 1));
            Iterator iter = this.testTree.list(this.stack.subList(0, i)).iterator();
            LinkedList<TestElement> tempPre = new LinkedList<TestElement>();
            LinkedList<TestElement> tempPost = new LinkedList<TestElement>();
            while (iter.hasNext()) {
                TestElement item = (TestElement)iter.next();
                if (item instanceof ConfigTestElement) {
                    configs.add(item);
                }
                if (item instanceof SampleListener) {
                    listeners.add(item);
                }
                if (item instanceof Timer) {
                    timers.add(item);
                }
                if (item instanceof Assertion) {
                    assertions.add(item);
                }
                if (item instanceof PostProcessor) {
                    tempPost.add(item);
                }
                if (!(item instanceof PreProcessor)) continue;
                tempPre.add(item);
            }
            pres.addAll(0, tempPre);
            posts.addAll(0, tempPost);
        }
        SamplePackage pack = new SamplePackage(configs, modifiers, responseModifiers, listeners, timers, assertions, posts, pres, controllers);
        pack.setSampler(sam);
        pack.setRunningVersion(true);
        this.samplerConfigMap.put(sam, pack);
    }

    private void addDirectParentControllers(List controllers, TestElement maybeController) {
        if (maybeController instanceof Controller) {
            log.debug("adding controller: " + maybeController + " to sampler config");
            controllers.add(maybeController);
        }
    }

    private void configureWithConfigElements(Sampler sam, List configs) {
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            ConfigTestElement config = (ConfigTestElement)iter.next();
            sam.addTestElement(config);
        }
    }

    private class ObjectPair {
        TestElement child;
        TestElement parent;

        public ObjectPair(TestElement one, TestElement two) {
            this.child = one;
            this.parent = two;
        }

        public void addTestElements() {
            if (this.parent instanceof Controller && (this.child instanceof Sampler || this.child instanceof Controller)) {
                this.parent.addTestElement(this.child);
            }
        }

        public int hashCode() {
            return this.child.hashCode() + this.parent.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ObjectPair) {
                return this.child == ((ObjectPair)o).child && this.parent == ((ObjectPair)o).parent;
            }
            return false;
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testConfigGathering() throws Exception {
            ListedHashTree testing = new ListedHashTree();
            GenericController controller = new GenericController();
            ConfigTestElement config1 = new ConfigTestElement();
            config1.setName("config1");
            config1.setProperty("test.property", "A test value");
            TestSampler sampler = new TestSampler();
            sampler.setName("sampler");
            testing.add((Object)controller, (Object)config1);
            testing.add((Object)controller, (Object)sampler);
            TestCompiler.initialize();
            TestCompiler compiler = new TestCompiler((HashTree)testing, new JMeterVariables());
            testing.traverse((HashTreeTraverser)compiler);
            sampler = (TestSampler)compiler.configureSampler(sampler).getSampler();
            Test.assertEquals((String)"A test value", (String)sampler.getPropertyAsString("test.property"));
        }

        class TestSampler
        extends AbstractSampler {
            TestSampler() {
            }

            public SampleResult sample(Entry e) {
                return null;
            }

            public Object clone() {
                return new TestSampler();
            }
        }
    }
}

