/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ThreadGroup
extends AbstractTestElement
implements SampleListener,
Serializable,
Controller {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String NUM_THREADS = "ThreadGroup.num_threads";
    public static final String RAMP_TIME = "ThreadGroup.ramp_time";
    public static final String MAIN_CONTROLLER = "ThreadGroup.main_controller";
    public static final String SCHEDULER = "ThreadGroup.scheduler";
    public static final String START_TIME = "ThreadGroup.start_time";
    public static final String END_TIME = "ThreadGroup.end_time";
    public static final String DURATION = "ThreadGroup.duration";
    public static final String DELAY = "ThreadGroup.delay";
    public static final String ON_SAMPLE_ERROR = "ThreadGroup.on_sample_error";
    public static final String ON_SAMPLE_ERROR_CONTINUE = "continue";
    public static final String ON_SAMPLE_ERROR_STOPTHREAD = "stopthread";
    public static final String ON_SAMPLE_ERROR_STOPTEST = "stoptest";
    private static final int DEFAULT_NUM_THREADS = 1;
    private static final int DEFAULT_RAMP_UP = 0;
    private SampleQueue queue = null;
    private LinkedList listeners = new LinkedList();
    private LinkedList remoteListeners = new LinkedList();
    private int numberOfThreads = 0;

    public void setNumThreads(int numThreads) {
        this.setProperty(new IntegerProperty(NUM_THREADS, numThreads));
    }

    synchronized void incrNumberOfThreads() {
        ++this.numberOfThreads;
    }

    synchronized void decrNumberOfThreads() {
        --this.numberOfThreads;
    }

    public synchronized int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public boolean isDone() {
        return this.getSamplerController().isDone();
    }

    public Sampler next() {
        return this.getSamplerController().next();
    }

    public void setScheduler(boolean Scheduler) {
        this.setProperty(new BooleanProperty(SCHEDULER, Scheduler));
    }

    public boolean getScheduler() {
        return this.getPropertyAsBoolean(SCHEDULER);
    }

    public void setStartTime(long stime) {
        this.setProperty(new LongProperty(START_TIME, stime));
    }

    public long getStartTime() {
        return this.getPropertyAsLong(START_TIME);
    }

    public long getDuration() {
        return this.getPropertyAsLong(DURATION);
    }

    public void setDuration(long duration) {
        this.setProperty(new LongProperty(DURATION, duration));
    }

    public long getDelay() {
        return this.getPropertyAsLong(DELAY);
    }

    public void setDelay(long delay) {
        this.setProperty(new LongProperty(DELAY, delay));
    }

    public void setEndTime(long etime) {
        this.setProperty(new LongProperty(END_TIME, etime));
    }

    public long getEndTime() {
        return this.getPropertyAsLong(END_TIME);
    }

    public void setRampUp(int rampUp) {
        this.setProperty(new IntegerProperty(RAMP_TIME, rampUp));
    }

    public int getRampUp() {
        return this.getPropertyAsInt(RAMP_TIME);
    }

    public Controller getSamplerController() {
        return (Controller)this.getProperty(MAIN_CONTROLLER).getObjectValue();
    }

    public void setSamplerController(LoopController c) {
        c.setContinueForever(false);
        this.setProperty(new TestElementProperty(MAIN_CONTROLLER, c));
    }

    public int getNumThreads() {
        return this.getPropertyAsInt(NUM_THREADS);
    }

    public int getDefaultNumThreads() {
        return 1;
    }

    public int getDefaultRampUp() {
        return 0;
    }

    public void addTestElement(TestElement child) {
        this.getSamplerController().addTestElement(child);
    }

    public void sampleOccurred(SampleEvent e) {
        if (this.queue == null) {
            this.queue = new SampleQueue();
            Thread thread = new Thread(this.queue);
            thread.start();
        }
        this.queue.sampleOccurred(e);
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void addIterationListener(LoopIterationListener lis) {
        this.getSamplerController().addIterationListener(lis);
    }

    public void initialize() {
        this.getSamplerController().initialize();
    }

    public boolean getOnErrorStopThread() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTHREAD);
    }

    public boolean getOnErrorStopTest() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTEST);
    }

    private class SampleQueue
    implements Runnable,
    Serializable {
        List occurredQ = Collections.synchronizedList(new LinkedList());

        public synchronized void sampleOccurred(SampleEvent e) {
            this.occurredQ.add(e);
            this.notifyAll();
        }

        public void run() {
            SampleEvent event = null;
            block6: while (true) {
                try {
                    event = (SampleEvent)this.occurredQ.remove(0);
                }
                catch (Exception ex) {
                    this.waitForSamples();
                    continue;
                }
                try {
                    if (event != null) {
                        Iterator iter = ThreadGroup.this.listeners.iterator();
                        while (iter.hasNext()) {
                            ((SampleListener)iter.next()).sampleOccurred(event);
                        }
                        iter = ThreadGroup.this.remoteListeners.iterator();
                        while (true) {
                            if (!iter.hasNext()) continue block6;
                            try {
                                ((RemoteSampleListener)iter.next()).sampleOccurred(event);
                            }
                            catch (Exception ex) {
                                log.error("", (Throwable)ex);
                            }
                        }
                    }
                    this.waitForSamples();
                    continue;
                }
                catch (Throwable ex) {
                    log.error("", ex);
                    continue;
                }
                break;
            }
        }

        private synchronized void waitForSamples() {
            try {
                this.wait();
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
        }
    }
}

