/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BeanShellServer
implements Runnable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private final int serverport;
    private final String serverfile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public BeanShellServer(int port, String file) {
        this.serverfile = file;
        this.serverport = port;
    }

    private BeanShellServer() {
        this.serverport = 0;
        this.serverfile = "";
    }

    private static String getprop(String s) {
        return JMeterUtils.getPropDefault(s, s);
    }

    private static void setprop(String s, String v) {
        JMeterUtils.getJMeterProperties().setProperty(s, v);
    }

    public void run() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> Interpreter = loader.loadClass("bsh.Interpreter");
            Object instance = Interpreter.newInstance();
            Class string = class$java$lang$String == null ? (class$java$lang$String = BeanShellServer.class$("java.lang.String")) : class$java$lang$String;
            Class object = class$java$lang$Object == null ? (class$java$lang$Object = BeanShellServer.class$("java.lang.Object")) : class$java$lang$Object;
            Method eval = Interpreter.getMethod("eval", string);
            Method setObj = Interpreter.getMethod("set", string, object);
            Method setInt = Interpreter.getMethod("set", string, Integer.TYPE);
            Method source = Interpreter.getMethod("source", string);
            setObj.invoke(instance, "t", this);
            setInt.invoke(instance, "portnum", new Integer(this.serverport));
            if (this.serverfile.length() > 0) {
                try {
                    source.invoke(instance, this.serverfile);
                }
                catch (InvocationTargetException e1) {
                    log.warn("Could not source " + this.serverfile);
                }
            }
            eval.invoke(instance, "setAccessibility(true);");
            eval.invoke(instance, "server(portnum);");
        }
        catch (ClassNotFoundException e) {
            log.error("Beanshell Interpreter not found");
        }
        catch (Exception e) {
            log.error("Problem starting BeanShell server ", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Test
    extends TestCase {
        public void testServer() throws Exception {
            BeanShellServer bshs = new BeanShellServer(9876, "");
            Test.assertNotNull((Object)bshs);
        }

        public void testProps() throws Exception {
            if (JMeterUtils.getJMeterProperties() != null) {
                Test.assertNotNull((String)"Property user.dir should not be null", (Object)BeanShellServer.getprop("user.dir"));
                BeanShellServer.setprop("beanshelltest", "xyz");
                Test.assertEquals((String)"xyz", (String)BeanShellServer.getprop("beanshelltest"));
            }
        }
    }
}

