/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class NameUpdater {
    private static Properties nameMap;
    private static Logger log;

    public static String getCurrentName(String className) {
        if (nameMap.containsKey(className)) {
            String newName = nameMap.getProperty(className);
            log.info("Upgrading class " + className + " to " + newName);
            return newName;
        }
        return className;
    }

    public static String getCurrentTestName(String testClassName, String guiClassName) {
        String key = testClassName + "|" + guiClassName;
        if (nameMap.containsKey(key)) {
            String newName = nameMap.getProperty(key);
            log.info("Upgrading " + key + " to " + newName);
            return newName;
        }
        return NameUpdater.getCurrentName(testClassName);
    }

    public static String getCurrentName(String propertyName, String className) {
        String key = className + "/" + propertyName;
        if (nameMap.containsKey(key)) {
            String newName = nameMap.getProperty(key);
            log.info("Upgrading property " + propertyName + " to " + newName);
            return newName;
        }
        return propertyName;
    }

    public static String getCurrentName(String value, String propertyName, String className) {
        String key = className + "." + propertyName + "/" + value;
        if (nameMap.containsKey(key)) {
            String newValue = nameMap.getProperty(key);
            log.info("Upgrading value " + value + " to " + newValue);
            return newValue;
        }
        return value;
    }

    private NameUpdater() {
    }

    static {
        log = LoggingManager.getLoggerForClass();
        nameMap = new Properties();
        try {
            nameMap.load(new FileInputStream(JMeterUtils.getJMeterHome() + JMeterUtils.getPropDefault("upgrade_properties", "/bin/upgrade.properties")));
        }
        catch (Exception e) {
            log.error("Bad upgrade file", (Throwable)e);
        }
    }
}

