/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XPathUtil {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static DocumentBuilderFactory documentBuilderFactory;

    private XPathUtil() {
    }

    private static synchronized DocumentBuilderFactory makeDocumentBuilderFactory(boolean validate, boolean whitespace, boolean namespace) {
        if (documentBuilderFactory == null || documentBuilderFactory.isValidating() != validate || documentBuilderFactory.isNamespaceAware() != namespace || documentBuilderFactory.isIgnoringElementContentWhitespace() != whitespace) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(validate);
            documentBuilderFactory.setNamespaceAware(namespace);
            documentBuilderFactory.setIgnoringElementContentWhitespace(whitespace);
        }
        return documentBuilderFactory;
    }

    public static DocumentBuilder makeDocumentBuilder(boolean validate, boolean whitespace, boolean namespace) throws ParserConfigurationException, SAXException {
        DocumentBuilder builder = XPathUtil.makeDocumentBuilderFactory(validate, whitespace, namespace).newDocumentBuilder();
        builder.setErrorHandler(new MyErrorHandler(validate, false));
        return builder;
    }

    public static Document makeDocument(InputStream stream, boolean validate, boolean whitespace, boolean namespace, boolean tolerant) throws ParserConfigurationException, SAXException, IOException {
        Document doc = tolerant ? XPathUtil.tidyDoc(stream) : XPathUtil.makeDocumentBuilder(validate, whitespace, namespace).parse(stream);
        return doc;
    }

    private static Document tidyDoc(InputStream stream) {
        Document doc = null;
        doc = XPathUtil.makeTidyParser().parseDOM(stream, null);
        doc.normalize();
        return doc;
    }

    private static Tidy makeTidyParser() {
        Tidy tidy = new Tidy();
        tidy.setCharEncoding(3);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setMakeClean(true);
        tidy.setXmlTags(false);
        return tidy;
    }

    static class MyErrorHandler
    implements ErrorHandler {
        private final boolean val;
        private final boolean tol;
        private final String type;

        MyErrorHandler(boolean validate, boolean tolerate) {
            this.val = validate;
            this.tol = tolerate;
            this.type = "Val=" + this.val + " Tol=" + this.tol;
        }

        public void warning(SAXParseException ex) throws SAXException {
            log.info("Type=" + this.type + " " + ex);
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }

        public void error(SAXParseException ex) throws SAXException {
            log.warn("Type=" + this.type + " " + ex);
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            log.error("Type=" + this.type + " " + ex);
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }
    }
}

