/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util.keystore;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.jmeter.util.keystore.JmeterKeyStore;

public class DefaultKeyStore
extends JmeterKeyStore {
    private X509Certificate[] certChain;
    private PrivateKey key;
    private String alias;
    private final KeyStore store;

    public DefaultKeyStore(String type) throws Exception {
        this.store = KeyStore.getInstance(type);
    }

    public void load(InputStream is, String pword) throws Exception {
        this.store.load(is, pword.toCharArray());
        PrivateKey key = null;
        X509Certificate[] certChain = null;
        Enumeration<String> aliases = this.store.aliases();
        while (aliases.hasMoreElements()) {
            this.alias = aliases.nextElement();
            if (!this.store.isKeyEntry(this.alias)) continue;
            key = (PrivateKey)this.store.getKey(this.alias, pword.toCharArray());
            Certificate[] chain = this.store.getCertificateChain(this.alias);
            certChain = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                certChain[i] = (X509Certificate)chain[i];
            }
        }
        if (null == key) {
            throw new Exception("No key found");
        }
        if (null == certChain) {
            throw new Exception("No certificate chain found");
        }
        this.key = key;
        this.certChain = certChain;
    }

    public final X509Certificate[] getCertificateChain() {
        return this.certChain;
    }

    public final PrivateKey getPrivateKey() {
        return this.key;
    }

    public final String getAlias() {
        return this.alias;
    }
}

