/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.SavePropertyDialog;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractVisualizer
extends AbstractJMeterGuiComponent
implements Visualizer,
ChangeListener,
UnsharedComponent,
Printable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private FilePanel filePanel;
    private JCheckBox errorLogging;
    private JButton saveConfigButton;
    SampleSaveConfiguration saveConfig;
    protected ResultCollector collector = new ResultCollector();
    protected boolean isStats = false;

    public AbstractVisualizer() {
        this.errorLogging = new JCheckBox(JMeterUtils.getResString("log_errors_only"));
        this.saveConfigButton = new JButton(JMeterUtils.getResString("config_save_settings"));
        this.saveConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SavePropertyDialog d = new SavePropertyDialog((Frame)GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("Sample Result Save Configuration"), true, AbstractVisualizer.this.collector.getSaveConfig());
                d.pack();
                ComponentUtil.centerComponentInComponent((Component)GuiPackage.getInstance().getMainFrame(), (Component)d);
                d.setVisible(true);
            }
        });
        this.filePanel = new FilePanel(JMeterUtils.getResString("file_visualizer_output_file"), ".jtl");
        this.filePanel.addChangeListener(this);
        this.filePanel.add(this.errorLogging);
        this.filePanel.add(this.saveConfigButton);
    }

    public boolean isStats() {
        return this.isStats;
    }

    protected JCheckBox getErrorLoggingCheckbox() {
        return this.errorLogging;
    }

    protected ResultCollector getModel() {
        return this.collector;
    }

    protected Component getFilePanel() {
        return this.filePanel;
    }

    public void setFile(String filename) {
        this.filePanel.setFilename(filename);
    }

    public String getFile() {
        return this.filePanel.getFilename();
    }

    public JPopupMenu createPopupMenu() {
        return MenuFactory.getDefaultVisualizerMenu();
    }

    public void stateChanged(ChangeEvent e) {
        log.info("getting new collector");
        this.collector = (ResultCollector)this.createTestElement();
        try {
            this.collector.loadExistingFile();
        }
        catch (Exception err) {
            log.debug("Error occurred while loading file", (Throwable)err);
        }
    }

    public Collection getMenuCategories() {
        return Arrays.asList("menu_listener");
    }

    public TestElement createTestElement() {
        if (this.collector == null) {
            this.collector = new ResultCollector();
        }
        this.modifyTestElement(this.collector);
        return (TestElement)this.collector.clone();
    }

    public void modifyTestElement(TestElement c) {
        this.configureTestElement((AbstractListenerElement)c);
        if (c instanceof ResultCollector) {
            ResultCollector rc = (ResultCollector)c;
            rc.setErrorLogging(this.errorLogging.isSelected());
            rc.setFilename(this.getFile());
            this.collector = rc;
        }
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.setFile(el.getPropertyAsString("filename"));
        ResultCollector rc = (ResultCollector)el;
        this.errorLogging.setSelected(rc.isErrorLogging());
        if (this.collector == null) {
            this.collector = new ResultCollector();
        }
        this.collector.setSaveConfig((SampleSaveConfiguration)rc.getSaveConfig().clone());
    }

    protected void configureTestElement(AbstractListenerElement mc) {
        super.configureTestElement(mc);
        mc.setListener(this);
    }

    protected Container makeTitlePanel() {
        Container panel = super.makeTitlePanel();
        panel.add(this.getFilePanel());
        return panel;
    }

    protected void setModel(ResultCollector collector) {
        this.collector = collector;
    }

    public JComponent getPrintableComponent() {
        return this;
    }
}

