/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.jmeter.protocol.java.sampler.BeanShellSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class BeanShellSamplerGui
extends AbstractSamplerGui {
    private JTextField filename;
    private JTextField parameters;
    private JTextArea scriptField;

    public BeanShellSamplerGui() {
        this.init();
    }

    public void configure(TestElement element) {
        this.scriptField.setText(element.getPropertyAsString("BeanShellSampler.query"));
        this.filename.setText(element.getPropertyAsString("BeanShellSampler.filename"));
        this.parameters.setText(element.getPropertyAsString("BeanShellSampler.parameters"));
        super.configure(element);
    }

    public TestElement createTestElement() {
        BeanShellSampler sampler = new BeanShellSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        te.clear();
        this.configureTestElement(te);
        te.setProperty("BeanShellSampler.query", this.scriptField.getText());
        te.setProperty("BeanShellSampler.filename", this.filename.getText());
        te.setProperty("BeanShellSampler.parameters", this.parameters.getText());
    }

    public String getLabelResource() {
        return "bsh_sampler_title";
    }

    private JPanel createFilenamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_script_file"));
        this.filename = new JTextField(10);
        this.filename.setName("BeanShellSampler.filename");
        label.setLabelFor(this.filename);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }

    private JPanel createParameterPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_script_parameters"));
        this.parameters = new JTextField(10);
        this.parameters.setName("BeanShellSampler.parameters");
        label.setLabelFor(this.parameters);
        JPanel parameterPanel = new JPanel(new BorderLayout(5, 0));
        parameterPanel.add((Component)label, "West");
        parameterPanel.add((Component)this.parameters, "Center");
        return parameterPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createParameterPanel());
        box.add(this.createFilenamePanel());
        this.add(box, "North");
        JPanel panel = this.createScriptPanel();
        this.add(panel, "Center");
        this.add(Box.createVerticalStrut(panel.getPreferredSize().height), "West");
    }

    private JPanel createScriptPanel() {
        this.scriptField = new JTextArea();
        this.scriptField.setRows(4);
        this.scriptField.setLineWrap(true);
        this.scriptField.setWrapStyleWord(true);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_script"));
        label.setLabelFor(this.scriptField);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)new JScrollPane(this.scriptField), "Center");
        return panel;
    }
}

