/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFManager;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BSFSampler
extends AbstractSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String FILENAME = "BSFSampler.filename";
    public static final String SCRIPT = "BSFSampler.query";
    public static final String LANGUAGE = "BSFSampler.language";
    public static final String PARAMETERS = "BSFSampler.parameters";
    private transient BSFManager mgr;
    private transient BSFEngine bsfEngine;

    public BSFSampler() {
        try {
            this.mgr = new BSFManager();
            BSFManager.registerScriptingEngine((String)"beanshell", (String)"bsh.util.BeanShellBSFEngine", (String[])new String[]{"bsh"});
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public void setFilename(String newFilename) {
        this.setProperty(FILENAME, newFilename);
    }

    public String getScript() {
        return this.getPropertyAsString(SCRIPT);
    }

    public void setScript(String newScript) {
        this.setProperty(SCRIPT, newScript);
    }

    public String getParameters() {
        return this.getPropertyAsString(PARAMETERS);
    }

    public void setParameters(String newScript) {
        this.setProperty(PARAMETERS, newScript);
    }

    public String getScriptLanguage() {
        return this.getPropertyAsString(LANGUAGE);
    }

    public void setScriptLanguage(String lang) {
        this.setProperty(LANGUAGE, lang);
    }

    public String getLabel() {
        return this.getName();
    }

    public SampleResult sample(Entry e) {
        log.info(this.getLabel() + " " + this.getFilename());
        SampleResult res = new SampleResult();
        boolean isSuccessful = false;
        res.setSampleLabel(this.getLabel());
        res.sampleStart();
        try {
            String request = this.getScript();
            res.setSamplerData(request);
            this.mgr.registerBean("Label", (Object)this.getLabel());
            this.mgr.registerBean("Name", (Object)this.getFilename());
            this.bsfEngine = this.mgr.loadScriptingEngine(this.getScriptLanguage());
            Object bsfOut = this.bsfEngine.eval("Sampler", 0, 0, (Object)request);
            res.setResponseData(bsfOut.toString().getBytes());
            res.setDataType("text");
            res.setResponseCode("200");
            res.setResponseMessage("OK");
            isSuccessful = true;
        }
        catch (NoClassDefFoundError ex) {
            log.warn("", (Throwable)ex);
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
        }
        catch (Exception ex) {
            log.warn("", (Throwable)ex);
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
        }
        res.sampleEnd();
        res.setSuccessful(isSuccessful);
        return res;
    }
}

