/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.io.IOException;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class BeanShellSampler
extends AbstractSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String FILENAME = "BeanShellSampler.filename";
    public static final String SCRIPT = "BeanShellSampler.query";
    public static final String PARAMETERS = "BeanShellSampler.parameters";
    public static final String INIT_FILE = "beanshell.sampler.init";
    private transient BeanShellInterpreter bshInterpreter;

    public BeanShellSampler() {
        try {
            this.bshInterpreter = new BeanShellInterpreter();
            String init = JMeterUtils.getProperty((String)INIT_FILE);
            try {
                this.bshInterpreter.init(init, (Object)log);
            }
            catch (IOException e) {
                log.warn("Could not initialise interpreter", (Throwable)e);
            }
            catch (JMeterException e) {
                log.warn("Could not initialise interpreter", (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Could not establish BeanShellInterpreter: " + e);
        }
    }

    public String getLabel() {
        return this.getName();
    }

    public String getScript() {
        return this.getPropertyAsString(SCRIPT);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public String getParameters() {
        return this.getPropertyAsString(PARAMETERS);
    }

    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        boolean isSuccessful = false;
        res.setSampleLabel(this.getLabel());
        res.sampleStart();
        if (this.bshInterpreter == null) {
            res.sampleEnd();
            res.setResponseCode("503");
            res.setResponseMessage("BeanShell Interpreter not found");
            res.setSuccessful(false);
            return res;
        }
        try {
            String request = this.getScript();
            String fileName = this.getFilename();
            if (fileName.length() == 0) {
                res.setSamplerData(request);
            } else {
                res.setSamplerData(fileName);
            }
            this.bshInterpreter.set("Label", (Object)this.getLabel());
            this.bshInterpreter.set("FileName", (Object)this.getFilename());
            this.bshInterpreter.set("SampleResult", (Object)res);
            this.bshInterpreter.set("Parameters", (Object)this.getParameters());
            this.bshInterpreter.set("bsh.args", (Object)JOrphanUtils.split((String)this.getParameters(), (String)" "));
            this.bshInterpreter.set("ResponseCode", (Object)"200");
            this.bshInterpreter.set("ResponseMessage", (Object)"OK");
            this.bshInterpreter.set("IsSuccess", true);
            JMeterContext jmctx = JMeterContextService.getContext();
            JMeterVariables vars = jmctx.getVariables();
            this.bshInterpreter.set("ctx", (Object)jmctx);
            this.bshInterpreter.set("vars", (Object)vars);
            Object bshOut = fileName.length() == 0 ? this.bshInterpreter.eval(request) : this.bshInterpreter.source(fileName);
            String out = bshOut == null ? "" : bshOut.toString();
            res.setResponseData(out.getBytes());
            res.setDataType("text");
            res.setResponseCode(this.bshInterpreter.get("ResponseCode").toString());
            res.setResponseMessage(this.bshInterpreter.get("ResponseMessage").toString());
            isSuccessful = Boolean.valueOf(this.bshInterpreter.get("IsSuccess").toString());
        }
        catch (NoClassDefFoundError ex) {
            log.error("BeanShell Jar missing? " + ex.toString());
            res.setResponseCode("501");
            res.setResponseMessage(ex.toString());
            res.setStopThread(true);
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
        }
        res.sampleEnd();
        res.setSuccessful(isSuccessful);
        return res;
    }
}

