/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.util.JOrphanUtils;

public class ConfigurationTree
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final String VALUE = "!!VALUE_][!!";
    private static final String BLOCK = "[[!";
    private static final String END_BLOCK = "!]]";
    ListedHashTree propTree;

    public ConfigurationTree() {
        this.propTree = new ListedHashTree();
    }

    public ConfigurationTree(Reader r) throws IOException {
        this.propTree = ConfigurationTree.fromXML((Reader)r).propTree;
    }

    public ConfigurationTree(String value) {
        this.propTree = new ListedHashTree();
        this.setValue(value);
    }

    public ConfigurationTree(ListedHashTree data) {
        this.propTree = data;
    }

    public ConfigurationTree(ListedHashTree data, String value) {
        this.propTree = data;
        this.setValue(value);
    }

    public void add(Collection keys) {
        this.propTree.add(keys);
    }

    public void add(Collection treePath, Collection values) {
        this.propTree.add(treePath, values);
    }

    public ConfigurationTree add(Collection treePath, String value) {
        return this.makeSubtree((ListedHashTree)this.propTree.add(treePath, (Object)value));
    }

    public void add(Collection treePath, String[] values) {
        this.propTree.add(treePath, (Object[])values);
    }

    public void add(ConfigurationTree newTree) {
        this.propTree.add(newTree.propTree);
    }

    public ConfigurationTree add(String key) {
        String[] keys = this.getPath(key);
        ListedHashTree tree = this.propTree;
        for (int i = 0; i < keys.length; ++i) {
            tree = (ListedHashTree)tree.add(keys[i]);
        }
        return this.makeSubtree(tree);
    }

    public ConfigurationTree addRaw(String key, String value) {
        ListedHashTree tree = (ListedHashTree)this.propTree.add((Object)key, (Object)value);
        return this.makeSubtree(tree);
    }

    public ConfigurationTree addRaw(String key) {
        ListedHashTree tree = (ListedHashTree)this.propTree.add(key);
        return this.makeSubtree(tree);
    }

    public void add(String key, Collection values) {
        this.propTree.add((Object[])this.getPath(key), values);
    }

    public void add(String key, ConfigurationTree subTree) {
        this.propTree.getTree(this.getPath(key)).add(subTree.propTree);
    }

    public ConfigurationTree add(String key, String value) {
        return this.makeSubtree((ListedHashTree)this.propTree.add((Object[])this.getPath(key), (Object)value));
    }

    public Properties getAsProperties(String key) {
        return this.getAsProperties(this.getTree(key));
    }

    public Properties getAsProperties() {
        return this.getAsProperties(this);
    }

    protected Properties getAsProperties(ConfigurationTree tree) {
        Properties props = new Properties();
        if (tree == null) {
            return props;
        }
        String[] propNames = tree.getPropertyNames();
        if (propNames == null) {
            return props;
        }
        for (int i = 0; i < propNames.length; ++i) {
            if (tree.getProperty(propNames[i]) == null) continue;
            props.setProperty(propNames[i], tree.getProperty(propNames[i]));
        }
        return props;
    }

    public void add(String key, String[] values) {
        this.propTree.add((Object[])this.getPath(key), (Object[])values);
    }

    public void add(String[] keys) {
        this.propTree.add(keys);
    }

    public void add(String[] treePath, Collection values) {
        this.propTree.add((Object[])treePath, values);
    }

    public ConfigurationTree add(String[] treePath, String value) {
        return this.makeSubtree((ListedHashTree)this.propTree.add((Object[])treePath, (Object)value));
    }

    public void add(String[] treePath, String[] values) {
        this.propTree.add((Object[])treePath, (Object[])values);
    }

    public void add(Properties props) {
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.add(key, props.getProperty(key));
        }
    }

    protected ConfigurationTree addTreePath(Collection treePath) {
        return this.makeSubtree((ListedHashTree)this.propTree.addTreePath(treePath));
    }

    public void clear() {
        this.propTree.clear();
    }

    public boolean containsKey(String o) {
        return this.propTree.getTree(this.getPath(o)) != null;
    }

    public boolean containsValue(String value) {
        return this.propTree.getTree(this.getPath(value)) != null;
    }

    protected String[] getPath(String key) {
        if (key != null) {
            String[] keys = JOrphanUtils.split(key, "/");
            return keys;
        }
        return new String[0];
    }

    public String getProperty(String key, String def) {
        return this.getProperty(this.getPath(key), def);
    }

    public String getProperty(String key) {
        return this.getProperty(this.getPath(key), null);
    }

    public String getProperty(String[] keys, String def) {
        HashTree subTree = this.propTree.getTree(keys);
        if (subTree != null) {
            if (subTree.list() == null || subTree.list().size() == 0) {
                return def;
            }
            if (subTree.list().size() == 1) {
                return (String)subTree.getArray()[0];
            }
            return def;
        }
        return def;
    }

    public String getProperty(String[] keys) {
        return this.getProperty(keys, null);
    }

    public String[] getPropertyNames() {
        return this.convertArray(this.propTree.getArray());
    }

    private String[] convertArray(Object[] vals) {
        if (vals != null) {
            String[] props = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                props[i] = (String)vals[i];
            }
            return props;
        }
        return null;
    }

    public String[] getPropertyNames(Collection treePath) {
        return this.convertArray(this.propTree.getArray(treePath));
    }

    public String[] getPropertyNames(String key) {
        return this.convertArray(this.propTree.getArray(this.getPath(key)));
    }

    public String[] getPropertyNames(String[] treePath) {
        return this.convertArray(this.propTree.getArray(treePath));
    }

    public ConfigurationTree getTree(Collection treePath) {
        ListedHashTree subTree = (ListedHashTree)this.propTree.getTree(treePath);
        return this.makeSubtree(subTree);
    }

    public ConfigurationTree getTree(String key) {
        ListedHashTree subTree = (ListedHashTree)this.propTree.getTree(this.getPath(key));
        return this.makeSubtree(subTree);
    }

    public ConfigurationTree getTree(String[] treePath) {
        ListedHashTree subTree = (ListedHashTree)this.propTree.getTree(treePath);
        return this.makeSubtree(subTree);
    }

    private ConfigurationTree makeSubtree(ListedHashTree subTree) {
        if (subTree != null) {
            return new ConfigurationTree(subTree);
        }
        return null;
    }

    protected ConfigurationTree getTreePath(Collection treePath) {
        ListedHashTree subTree = (ListedHashTree)this.propTree.getTree(treePath);
        return this.makeSubtree(subTree);
    }

    public boolean isEmpty() {
        return this.propTree.isEmpty();
    }

    public Collection listPropertyNames() {
        return this.propTree.list();
    }

    public Collection listPropertyNames(Collection treePath) {
        return this.propTree.list(treePath);
    }

    public Collection listPropertyNames(String key) {
        return this.propTree.list(this.getPath(key));
    }

    public Collection listPropertyNames(String[] treePath) {
        return this.propTree.list(treePath);
    }

    public String put(String key, String value) {
        this.propTree.add((Object[])this.getPath(key), (Object)value);
        return value;
    }

    public void putAll(Map map) {
        this.propTree.putAll(map);
    }

    public String remove(String key) {
        String[] keys = JOrphanUtils.split(key, "/");
        String prop = null;
        HashTree tree = this.propTree;
        for (int i = 0; i < keys.length && tree != null; ++i) {
            if (i + 1 == keys.length) {
                if ((tree = (HashTree)tree.remove(keys[i])).list() == null || tree.list().size() != 1) continue;
                prop = (String)tree.getArray()[0];
                continue;
            }
            tree = tree.getTree(keys[i]);
        }
        return prop;
    }

    public void replace(String currentKey, String newKey) {
        String[] currentKeys = this.getPath(currentKey);
        String[] newKeys = this.getPath(newKey);
        ListedHashTree tree = this.propTree;
        if (currentKeys.length == newKeys.length) {
            for (int i = 0; i < currentKeys.length; ++i) {
                tree.replace(currentKeys[i], newKeys[i]);
                tree = (ListedHashTree)tree.getTree(newKeys[i]);
            }
        }
    }

    public ConfigurationTree search(String key) {
        return this.makeSubtree((ListedHashTree)this.propTree.search(key));
    }

    public void setProperty(Collection values) {
        this.propTree.set(values);
    }

    public void setProperty(Collection treePath, Collection values) {
        this.propTree.set(treePath, values);
    }

    public void setProperty(Collection treePath, String[] values) {
        this.propTree.set(treePath, (Object[])values);
    }

    public void setProperty(String key, Collection values) {
        this.propTree.set((Object[])this.getPath(key), values);
    }

    public void setProperty(String key, ConfigurationTree t) {
        Object[] keys = this.getPath(key);
        ListedHashTree tree = (ListedHashTree)this.propTree.getTree(keys);
        if (tree != null) {
            tree.clear();
            tree.add(t.propTree);
        } else {
            this.propTree.add(keys);
            this.propTree.getTree(keys).add(t.propTree);
        }
    }

    public void setProperty(String key, String value) {
        ListedHashTree tree = (ListedHashTree)this.propTree.getTree(this.getPath(key));
        if (tree != null) {
            tree.clear();
            tree.add(value);
        } else {
            this.propTree.add((Object[])this.getPath(key), (Object)value);
        }
    }

    public void setProperty(String key, String[] values) {
        this.propTree.set((Object[])this.getPath(key), (Object[])values);
    }

    public void setProperty(String[] treePath, Collection values) {
        this.propTree.set((Object[])treePath, values);
    }

    public void setProperty(String[] treePath, String[] values) {
        this.propTree.set((Object[])treePath, (Object[])values);
    }

    public int size() {
        return this.propTree.size();
    }

    public void traverse(HashTreeTraverser visitor) {
        this.propTree.traverse(visitor);
    }

    protected Object clone() throws CloneNotSupportedException {
        ConfigurationTree config = new ConfigurationTree();
        config.propTree = (ListedHashTree)this.propTree.clone();
        return config;
    }

    protected void getSpaces(int level, Writer buf) throws IOException {
        for (int i = 0; i < level; ++i) {
            buf.write("    ");
        }
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        try {
            this.toXML(buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static ConfigurationTree fromXML(Reader buf) throws IOException {
        String[] line = ConfigurationTree.readLine(buf, null);
        ConfigurationTree tree = null;
        int nameIndex = line[0].indexOf("{");
        tree = nameIndex > 0 ? new ConfigurationTree(line[0].substring(0, nameIndex).trim()) : new ConfigurationTree();
        ConfigurationTree.fromXML(buf, tree, line);
        return tree;
    }

    protected static boolean fromXML(Reader buf, ConfigurationTree tree, String[] line) throws IOException {
        boolean done = false;
        try {
            while (!done && !(line = ConfigurationTree.readLine(buf, line)).equals("}")) {
                int equals = line[0].indexOf("=");
                if (line[0].endsWith("{")) {
                    line[0] = line[0].substring(0, line[0].length() - 1).trim();
                    equals = line[0].indexOf("=");
                    if (equals > -1) {
                        ConfigurationTree newTree = tree.add(line[0].substring(0, equals));
                        newTree.setValue(line[0].substring(equals + 1));
                        done = ConfigurationTree.fromXML(buf, newTree, line);
                        continue;
                    }
                    done = ConfigurationTree.fromXML(buf, tree.add(line[0]), line);
                    continue;
                }
                if (equals > -1) {
                    String key = line[0].substring(0, equals);
                    if (equals + 1 < line[0].length()) {
                        tree.addRaw(key, line[0].substring(equals + 1));
                        continue;
                    }
                    tree.addRaw(key);
                    continue;
                }
                if (line[0].equals("}")) {
                    return false;
                }
                if (line[0].length() <= 0) continue;
                tree.addRaw(line[0]);
            }
        }
        catch (IOException e) {
            if (e.getMessage().equals("End of File")) {
                return true;
            }
            throw e;
        }
        return false;
    }

    protected static String[] readLine(Reader buf, String[] extra) throws IOException {
        if (extra == null) {
            extra = new String[2];
        }
        if (extra[1] != null && extra[1].length() > 0) {
            extra[0] = extra[1];
            extra[1] = null;
            return extra;
        }
        StringBuffer line = new StringBuffer();
        int c = buf.read();
        while (c != -1 && (char)c != '\n' && (char)c != '\r' && (char)c != '}' && (char)c != '{') {
            line.append((char)c);
            c = buf.read();
        }
        if (c == -1) {
            throw new IOException("End of File");
        }
        if ((char)c == '}') {
            extra[1] = String.valueOf((char)c);
        } else if ((char)c == '{') {
            line.append('{');
        }
        extra[0] = line.toString().trim();
        if (extra[0].endsWith(BLOCK)) {
            extra[0] = extra[0].substring(0, extra[0].length() - BLOCK.length()) + ConfigurationTree.readBlock(buf);
        }
        return extra;
    }

    protected static String readBlock(Reader buf) throws IOException {
        StringBuffer line = new StringBuffer();
        int c = buf.read();
        line.append((char)c);
        while (!line.toString().endsWith(END_BLOCK)) {
            c = buf.read();
            line.append((char)c);
        }
        return line.toString().substring(0, line.length() - END_BLOCK.length()).trim();
    }

    public void toXML(Writer buf) throws IOException {
        if (this.getValue() != null) {
            buf.write(this.getValue());
            buf.write(" {\n");
        } else {
            buf.write("{\n");
        }
        int level = 1;
        this.toXML(this, level, buf);
        buf.write("}");
    }

    protected boolean isLeaf(String key) {
        ConfigurationTree tree = this.getTree(key);
        String[] vals = tree.getPropertyNames();
        return vals == null || vals.length == 0 || vals.length == 1 && (tree.listPropertyNames(vals[0]) == null || tree.listPropertyNames(vals[0]).size() == 0);
    }

    protected void toXML(ConfigurationTree tree, int level, Writer buf) throws IOException {
        String[] entries = tree.getPropertyNames();
        for (int i = 0; i < entries.length; ++i) {
            if (VALUE.equals(entries[i])) continue;
            if (tree.listPropertyNames(entries[i]) == null || tree.listPropertyNames(entries[i]).size() == 0) {
                this.getSpaces(level, buf);
                this.writeLeafValue(buf, entries[i], level);
                buf.write("\n");
                continue;
            }
            if (tree.isLeaf(entries[i])) {
                this.getSpaces(level, buf);
                buf.write(entries[i]);
                buf.write("=");
                this.writeLeafValue(buf, tree.getPropertyNames(entries[i])[0], level);
                buf.write("\n");
                continue;
            }
            this.getSpaces(level, buf);
            buf.write(entries[i]);
            if (tree.getTree(entries[i]).getValue() != null) {
                buf.write("=");
                buf.write(tree.getTree(entries[i]).getValue());
            }
            buf.write(" {\n");
            this.toXML(tree.getTree(entries[i]), level + 1, buf);
            this.getSpaces(level, buf);
            buf.write("}\n");
        }
    }

    protected void writeLeafValue(Writer buf, String entry, int level) throws IOException {
        if (entry.indexOf(10) > -1 || entry.indexOf(13) > -1) {
            buf.write(BLOCK);
            buf.write("\n");
            buf.write(entry.trim());
            buf.write("\n");
            this.getSpaces(level, buf);
            buf.write(END_BLOCK);
        } else {
            buf.write(entry);
        }
    }

    public String getValue() {
        return this.getProperty(VALUE);
    }

    public String getValueOr(String def) {
        String v = this.getValue();
        if (v == null) {
            return def;
        }
        return v;
    }

    public String getValue(String name) {
        ConfigurationTree tree = this.getTree(this.getPath(name));
        if (tree != null) {
            return tree.getValue();
        }
        return null;
    }

    public String getValue(String key, String def) {
        String v = this.getValue(key);
        if (v == null) {
            return def;
        }
        return v;
    }

    public void setValue(String value) {
        this.setProperty(VALUE, value);
    }

    public void setValue(String name, String value) {
        ConfigurationTree tree = this.getTree(this.getPath(name));
        if (tree != null) {
            tree.setValue(value);
        } else {
            this.add(name).setValue(value);
        }
    }
}

