/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledTextArea
extends JPanel
implements JLabeledField,
FocusListener {
    private JLabel mLabel;
    private JTextArea mTextArea;
    private ArrayList mChangeListeners = new ArrayList(3);
    private String oldValue = "";

    public JLabeledTextArea() {
        this("", null);
    }

    public JLabeledTextArea(String pLabel, Document docModel) {
        this.mLabel = new JLabel(pLabel);
        if (docModel != null) {
            this.setDocumentModel(docModel);
        }
        this.init();
    }

    public List getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        comps.add(this.mTextArea);
        return comps;
    }

    public void setDocumentModel(Document docModel) {
        this.mTextArea.setDocument(docModel);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.mTextArea = new JTextArea();
        this.mTextArea.setRows(4);
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setWrapStyleWord(true);
        this.mTextArea.addFocusListener(this);
        this.add((Component)this.mLabel, "North");
        this.add((Component)new JScrollPane(this.mTextArea), "Center");
    }

    public void focusLost(FocusEvent pFocusEvent) {
        if (!this.oldValue.equals(this.mTextArea.getText())) {
            this.notifyChangeListeners();
        }
    }

    public void focusGained(FocusEvent pFocusEvent) {
        this.oldValue = this.mTextArea.getText();
    }

    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    public void setText(String pText) {
        this.mTextArea.setText(pText);
    }

    public String getText() {
        return this.mTextArea.getText();
    }

    public String getLabel() {
        return this.mLabel.getText();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.mTextArea.setEnabled(enable);
    }

    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    public void removeChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.remove(pChangeListener);
    }

    private void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int index = 0; index < this.mChangeListeners.size(); ++index) {
            ((ChangeListener)this.mChangeListeners.get(index)).stateChanged(ce);
        }
    }
}

