/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TextFile
extends File {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private String encoding = null;

    public TextFile(File filename, String encoding) {
        super(filename.toString());
        this.setEncoding(encoding);
    }

    public TextFile(File filename) {
        super(filename.toString());
    }

    public TextFile(String filename) {
        super(filename);
    }

    public TextFile(String filename, String encoding) {
        super(filename);
    }

    public void setText(String body) {
        Writer writer = null;
        try {
            writer = this.encoding == null ? new FileWriter(this) : new OutputStreamWriter((OutputStream)new FileOutputStream(this), this.encoding);
            writer.write(body);
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            log.error("", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getText() {
        String lineEnd = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        InputStreamReader reader = null;
        reader = this.encoding == null ? new FileReader(this) : new InputStreamReader((InputStream)new FileInputStream(this), this.encoding);
        BufferedReader br = new BufferedReader(reader);
        String line = "NOTNULL";
        while (line != null) {
            line = br.readLine();
            if (line == null) continue;
            sb.append(line + lineEnd);
        }
        Object var7_7 = null;
        if (reader == null) return sb.toString();
        try {
            ((Reader)reader).close();
            return sb.toString();
        }
        catch (IOException e) {}
        return sb.toString();
        {
            catch (IOException ioe) {
                log.error("", (Throwable)ioe);
                Object var7_8 = null;
                if (reader == null) return sb.toString();
                try {
                    ((Reader)reader).close();
                    return sb.toString();
                }
                catch (IOException e) {}
                return sb.toString();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (reader == null) throw throwable;
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

