/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class Functor {
    private static Logger log = LoggingManager.getLoggerForClass();
    Object invokee;
    String methodName;
    Object[] args;
    Class[] types;
    Method methodToInvoke;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    public Functor(Object invokee, String methodName) {
        this(methodName);
        this.invokee = invokee;
    }

    public Functor(Object invokee, String methodName, Class[] types) {
        this(invokee, methodName);
        this.types = types;
    }

    public Functor(String methodName) {
        this.methodName = methodName;
    }

    public Functor(String methodName, Class[] types) {
        this(methodName);
        this.types = types;
    }

    public Functor(Object invokee, String methodName, Object[] args) {
        this(invokee, methodName);
        this.args = args;
    }

    public Functor(String methodName, Object[] args) {
        this(methodName);
        this.args = args;
    }

    public Functor(Object invokee, String methodName, Object[] args, Class[] types) {
        this(invokee, methodName, args);
        this.types = types;
    }

    public Object invoke() {
        try {
            return this.createMethod(this.getTypes()).invoke(this.invokee, this.getArgs());
        }
        catch (Exception e) {
            log.warn("Trouble functing method: ", (Throwable)e);
            throw new JMeterError(e);
        }
    }

    public Object invoke(Object p_invokee) {
        this.invokee = p_invokee;
        return this.invoke();
    }

    public Object invoke(Object[] p_args) {
        this.args = p_args;
        return this.invoke();
    }

    public Object invoke(Object p_invokee, Object[] p_args) {
        this.args = p_args;
        this.invokee = p_invokee;
        return this.invoke();
    }

    private Method createMethod(Class[] p_types) {
        log.debug("Trying to functorize invokee: " + this.invokee.getClass().getName() + " method: " + this.methodName + " types: " + Arrays.asList(p_types));
        if (this.methodToInvoke == null) {
            try {
                this.methodToInvoke = this.invokee.getClass().getMethod(this.methodName, p_types);
            }
            catch (Exception e) {
                for (int i = 0; i < p_types.length; ++i) {
                    Class primitive = this.getPrimitive(p_types[i]);
                    if (primitive != null) {
                        this.methodToInvoke = this.createMethod(this.getNewArray(i, primitive, p_types));
                        if (this.methodToInvoke != null) {
                            return this.methodToInvoke;
                        }
                    }
                    Class<?>[] interfaces = p_types[i].getInterfaces();
                    for (int j = 0; j < interfaces.length; ++j) {
                        this.methodToInvoke = this.createMethod(this.getNewArray(i, interfaces[j], p_types));
                        if (this.methodToInvoke == null) continue;
                        return this.methodToInvoke;
                    }
                    Class parent = p_types[i].getSuperclass();
                    this.methodToInvoke = this.createMethod(this.getNewArray(i, parent, p_types));
                    if (this.methodToInvoke == null) continue;
                    return this.methodToInvoke;
                }
            }
        }
        return this.methodToInvoke;
    }

    protected Class getPrimitive(Class t) {
        if (t.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = Functor.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (t.equals(class$java$lang$Long == null ? (class$java$lang$Long = Functor.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (t.equals(class$java$lang$Double == null ? (class$java$lang$Double = Functor.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (t.equals(class$java$lang$Float == null ? (class$java$lang$Float = Functor.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (t.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = Functor.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (t.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Functor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (t.equals(class$java$lang$Short == null ? (class$java$lang$Short = Functor.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        if (t.equals(class$java$lang$Character == null ? (class$java$lang$Character = Functor.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        return null;
    }

    protected Class[] getNewArray(int i, Class replacement, Class[] orig) {
        Class[] newArray = new Class[orig.length];
        for (int j = 0; j < newArray.length; ++j) {
            newArray[j] = orig[j];
            if (j != i) continue;
            newArray[j] = replacement;
        }
        return newArray;
    }

    private Class[] getTypes() {
        if (this.types == null) {
            if (this.args != null) {
                this.types = new Class[this.args.length];
                for (int i = 0; i < this.args.length; ++i) {
                    this.types[i] = this.args[i].getClass();
                }
            } else {
                this.types = new Class[0];
            }
        }
        return this.types;
    }

    private Object[] getArgs() {
        if (this.args == null) {
            this.args = new Object[0];
        }
        return this.args;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

