/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Vector;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class JOrphanUtils {
    private static Logger log = LoggingManager.getLoggerForClass();
    private static final String SPACES = "                                 ";
    private static final int SPACES_LEN = "                                 ".length();
    private static Method decodeMethod = null;
    private static Method encodeMethod = null;
    static /* synthetic */ Class class$java$net$URLEncoder;
    static /* synthetic */ Class class$java$net$URLDecoder;
    static /* synthetic */ Class class$java$lang$String;

    private JOrphanUtils() {
    }

    public static String[] split(String splittee, String splitChar, boolean truncate) {
        int spot;
        if (splittee == null || splitChar == null) {
            return new String[0];
        }
        if (truncate) {
            while ((spot = splittee.indexOf(splitChar + splitChar)) != -1) {
                splittee = splittee.substring(0, spot + splitChar.length()) + splittee.substring(spot + 2 * splitChar.length(), splittee.length());
            }
            if (splittee.startsWith(splitChar)) {
                splittee = splittee.substring(splitChar.length());
            }
        }
        Vector<String> returns = new Vector<String>();
        int start = 0;
        int length = splittee.length();
        spot = 0;
        while (start < length && (spot = splittee.indexOf(splitChar, start)) > -1) {
            if (spot > 0) {
                returns.addElement(splittee.substring(start, spot));
            } else {
                returns.addElement("");
            }
            start = spot + splitChar.length();
        }
        if (start < length) {
            returns.add(splittee.substring(start));
        }
        Object[] values = new String[returns.size()];
        returns.copyInto(values);
        return values;
    }

    public static String[] split(String splittee, String splitChar) {
        return JOrphanUtils.split(splittee, splitChar, true);
    }

    public static StringBuffer rightAlign(StringBuffer in, int len) {
        int pfx = len - in.length();
        if (pfx <= 0) {
            return in;
        }
        if (pfx > SPACES_LEN) {
            pfx = SPACES_LEN;
        }
        in.insert(0, SPACES.substring(0, pfx));
        return in;
    }

    public static StringBuffer leftAlign(StringBuffer in, int len) {
        int sfx = len - in.length();
        if (sfx <= 0) {
            return in;
        }
        if (sfx > SPACES_LEN) {
            sfx = SPACES_LEN;
        }
        in.append(SPACES.substring(0, sfx));
        return in;
    }

    public static String booleanToString(boolean value) {
        return value ? "true" : "false";
    }

    public static String booleanToSTRING(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public static Boolean valueOf(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String encode(String string, String encoding) throws UnsupportedEncodingException {
        if (encodeMethod != null) {
            Object[] args = new Object[]{string, encoding};
            try {
                return (String)encodeMethod.invoke(null, args);
            }
            catch (Exception e) {
                log.warn("Error trying to encode", (Throwable)e);
                return string;
            }
        }
        return URLEncoder.encode(string);
    }

    public static String decode(String string, String encoding) throws UnsupportedEncodingException {
        if (decodeMethod != null) {
            Object[] args = new Object[]{string, encoding};
            try {
                return (String)decodeMethod.invoke(null, args);
            }
            catch (Exception e) {
                log.warn("Error trying to decode", (Throwable)e);
                return string;
            }
        }
        return URLDecoder.decode(string);
    }

    public static String replaceFirst(String source, String search, String replace) {
        int start = source.indexOf(search);
        int len = search.length();
        if (start == -1) {
            return source;
        }
        if (start == 0) {
            return replace + source.substring(len);
        }
        return source.substring(0, start) + replace + source.substring(start + len);
    }

    public static byte[] getByteArraySlice(byte[] array, int begin, int end) {
        byte[] slice = new byte[end - begin + 1];
        int count = 0;
        for (int i = begin; i <= end; ++i) {
            slice[count] = array[i];
            ++count;
        }
        return slice;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class URLEncoder2 = class$java$net$URLEncoder == null ? (class$java$net$URLEncoder = JOrphanUtils.class$("java.net.URLEncoder")) : class$java$net$URLEncoder;
        Class URLDecoder2 = class$java$net$URLDecoder == null ? (class$java$net$URLDecoder = JOrphanUtils.class$("java.net.URLDecoder")) : class$java$net$URLDecoder;
        Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JOrphanUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JOrphanUtils.class$("java.lang.String")) : class$java$lang$String};
        try {
            decodeMethod = URLDecoder2.getMethod("decode", argTypes);
            encodeMethod = URLEncoder2.getMethod("encode", argTypes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

