/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class InstancePool {
    private final int INITIAL_CAPACITY = 100;
    private NewInstance instantiator;
    private List instances = new ArrayList(100);
    private BitSet checkedOut = new BitSet(100);

    public synchronized void setInstantiator(NewInstance instantiator) {
        if (null == this.instantiator) {
            this.instantiator = instantiator;
        }
    }

    public synchronized void releasePooledInstances() {
        this.instances.clear();
        this.checkedOut.clear();
    }

    public synchronized boolean isInitialized() {
        boolean result = false;
        result = null != this.instantiator;
        return result;
    }

    public synchronized Object checkout() {
        if (null == this.instantiator) {
            throw new IllegalStateException("InstancePool is uninitialized");
        }
        Object result = null;
        int nextClearBit = 0;
        nextClearBit = this.checkedOut.nextClearBit(0);
        if (this.instances.isEmpty() || this.instances.size() <= nextClearBit) {
            result = this.instantiator.newInstance();
            this.instances.add(result);
        } else {
            result = this.instances.get(nextClearBit);
        }
        this.checkedOut.set(nextClearBit);
        return result;
    }

    public synchronized void checkin(Object toCheckin) {
        if (null == this.instantiator) {
            throw new IllegalStateException("InstancePool is uninitialized");
        }
        int i = 0;
        i = this.instances.indexOf(toCheckin);
        if (-1 == i) {
            throw new IllegalStateException("Trying to checkin an instance that is not in the pool: " + toCheckin);
        }
        Util.doAssert(this.checkedOut.get(i));
        this.checkedOut.clear(i);
    }

    public static class NewInstance {
        public Object newInstance() {
            return null;
        }
    }
}

