/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.rules;

import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.rules.FeatureRule;
import com.sun.faces.config.rules.ListEntriesRule;
import com.sun.faces.config.rules.ManagedPropertyRule;
import com.sun.faces.config.rules.MapEntriesRule;
import com.sun.faces.util.ToolsUtil;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class ManagedBeanRule
extends FeatureRule {
    private static final String CLASS_NAME = "com.sun.faces.config.beans.ManagedBeanBean";
    private static final String[] SCOPES = new String[]{"none", "application", "session", "request"};

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        try {
            FacesConfigBean fcb = (FacesConfigBean)this.digester.peek();
        }
        catch (Exception e) {
            throw new IllegalStateException("No parent FacesConfigBean on object stack");
        }
        if (this.digester.getLogger().isDebugEnabled()) {
            this.digester.getLogger().debug((Object)("[ManagedBeanRule]{" + this.digester.getMatch() + "} Push " + CLASS_NAME));
        }
        Class<?> clazz = this.digester.getClassLoader().loadClass(CLASS_NAME);
        ManagedBeanBean mbb = (ManagedBeanBean)clazz.newInstance();
        this.digester.push((Object)mbb);
    }

    public void body(String namespace, String name, String text) throws Exception {
    }

    public void end(String namespace, String name) throws Exception {
        ManagedBeanBean top;
        try {
            top = (ManagedBeanBean)this.digester.pop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Popped object is not a com.sun.faces.config.beans.ManagedBeanBean instance");
        }
        this.validate(top);
        FacesConfigBean fcb = (FacesConfigBean)this.digester.peek();
        ManagedBeanBean old = fcb.getManagedBean(top.getManagedBeanName());
        if (old == null) {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug((Object)("[ManagedBeanRule]{" + this.digester.getMatch() + "} New(" + top.getManagedBeanName() + ")"));
            }
            fcb.addManagedBean(top);
        } else {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug((Object)("[ManagedBeanRule]{" + this.digester.getMatch() + "} Merge(" + top.getManagedBeanName() + ")"));
            }
            ManagedBeanRule.mergeManagedBean(top, old);
        }
    }

    public void finish() throws Exception {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ManagedBeanRule[className=");
        sb.append(CLASS_NAME);
        sb.append("]");
        return sb.toString();
    }

    static void mergeManagedBean(ManagedBeanBean top, ManagedBeanBean old) {
        if (top.getManagedBeanClass() != null) {
            old.setManagedBeanClass(top.getManagedBeanClass());
        }
        if (top.getManagedBeanScope() != null) {
            old.setManagedBeanScope(top.getManagedBeanScope());
        }
        ManagedBeanRule.mergeFeatures(top, old);
        ListEntriesRule.mergeListEntries(top, old);
        ManagedPropertyRule.mergeManagedProperties(top, old);
        MapEntriesRule.mergeMapEntries(top, old);
    }

    private void validate(ManagedBeanBean bean) {
        String val = bean.getManagedBeanName();
        if (val == null || val.length() == 0) {
            Locator locator = this.digester.getDocumentLocator();
            String documentName = "UNKNOWN";
            String lineNumber = "UNKNWOWN";
            if (locator != null) {
                documentName = locator.getSystemId();
                lineNumber = Integer.toString(locator.getLineNumber());
            }
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_NO_MANAGED_BEAN_NAME", new Object[]{documentName, lineNumber}));
        }
        val = bean.getManagedBeanClass();
        if (val == null || val.length() == 0) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_NO_MANAGED_BEAN_CLASS", new Object[]{bean.getManagedBeanName()}));
        }
        val = bean.getManagedBeanScope();
        if (val == null || val.length() == 0) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_NO_MANAGED_BEAN_SCOPE", new Object[]{bean.getManagedBeanName()}));
        }
        if (Arrays.binarySearch(SCOPES, val) < 0) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_INVALID_SCOPE", new Object[]{val, bean.getManagedBeanName()}));
        }
        if (bean.getListEntries() != null) {
            if (bean.getMapEntries() != null || bean.getManagedProperties().length != 0) {
                throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_AS_LIST_CONFIG_ERROR", new Object[]{bean.getManagedBeanName()}));
            }
        } else if (bean.getMapEntries() != null && bean.getManagedProperties().length != 0) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_AS_MAP_CONFIG_ERROR", new Object[]{bean.getManagedBeanName()}));
        }
    }

    static {
        Arrays.sort(SCOPES);
    }
}

