/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class ButtonRenderer
extends HtmlBasicRenderer {
    private static final String FORM_HAS_COMMAND_LINK_ATTR = "com.sun.faces.FORM_HAS_COMMAND_LINK_ATTR";
    private static final String NO_COMMAND_LINK_FOUND_VALUE = "com.sun.faces.NO_COMMAND_LINK_FOUND";

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin decoding component " + component.getId());
        }
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameterMap.get(clientId);
        if (value == null && requestParameterMap.get(clientId + ".x") == null && requestParameterMap.get(clientId + ".y") == null) {
            return;
        }
        String type = (String)component.getAttributes().get("type");
        if (type != null && type.toLowerCase().equals("reset")) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(component);
        component.queueEvent((FacesEvent)actionEvent);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  ActionEvent queued " + actionEvent);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End decoding component " + component.getId());
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String onclickAttr;
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since rendered attribute is set to false ");
            }
            return;
        }
        String type = (String)component.getAttributes().get("type");
        String styleClass = null;
        if (type == null) {
            type = "submit";
            component.getAttributes().put("type", type);
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String label = "";
        Object value = ((UICommand)component).getValue();
        if (value != null) {
            label = value.toString();
        }
        String imageSrc = (String)component.getAttributes().get("image");
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String clientId = component.getClientId(context);
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            writer.writeURIAttribute("src", (Object)this.src(context, imageSrc), "image");
            writer.writeAttribute("name", (Object)clientId, "clientId");
        } else {
            writer.writeAttribute("type", (Object)type.toLowerCase(), "type");
            writer.writeAttribute("name", (Object)clientId, "clientId");
            writer.writeAttribute("value", (Object)label, "value");
        }
        StringBuffer sb = new StringBuffer();
        String clearScript = this.getClearHiddenFieldScript(context, component);
        if (clearScript != null && clearScript.length() != 0) {
            sb.append(clearScript);
        }
        if ((onclickAttr = (String)component.getAttributes().get("onclick")) != null && onclickAttr.length() != 0) {
            sb.append(onclickAttr);
        }
        if ((clearScript = sb.toString()) != null && clearScript.length() != 0) {
            writer.writeAttribute("onclick", (Object)clearScript, null);
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.endElement("input");
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
    }

    private String getClearHiddenFieldScript(FacesContext context, UIComponent component) {
        UIComponent myForm;
        Map requestMap = context.getExternalContext().getRequestMap();
        UIViewRoot root = context.getViewRoot();
        String formClientId = null;
        String commandLinkAttrValue = null;
        String result = null;
        boolean formHasCommandLink = false;
        for (myForm = component; !(myForm instanceof UIForm) && root != myForm; myForm = myForm.getParent()) {
        }
        if (root == myForm) {
            return null;
        }
        formClientId = myForm.getClientId(context);
        assert (null != formClientId);
        commandLinkAttrValue = (String)requestMap.get(FORM_HAS_COMMAND_LINK_ATTR);
        if (null == commandLinkAttrValue) {
            Util.TreeTraversalCallback callback = new Util.TreeTraversalCallback(){

                public boolean takeActionOnNode(FacesContext context, UIComponent curNode) throws FacesException {
                    boolean keepGoing = true;
                    String rendererType = curNode.getRendererType();
                    String family = curNode.getFamily();
                    if ("javax.faces.Link".equals(rendererType) && "javax.faces.Command".equals(family)) {
                        keepGoing = false;
                    }
                    return keepGoing;
                }
            };
            formHasCommandLink = !Util.prefixViewTraversal(context, myForm, callback);
            if (formHasCommandLink) {
                requestMap.put(FORM_HAS_COMMAND_LINK_ATTR, formClientId);
            } else {
                requestMap.put(FORM_HAS_COMMAND_LINK_ATTR, NO_COMMAND_LINK_FOUND_VALUE);
            }
        } else {
            formHasCommandLink = commandLinkAttrValue.equals(formClientId);
            if (!formHasCommandLink) {
                boolean bl = formHasCommandLink = !commandLinkAttrValue.equals(NO_COMMAND_LINK_FOUND_VALUE);
            }
        }
        if (!formHasCommandLink) {
            return null;
        }
        result = "clearFormHiddenParams_" + formClientId.replace(':', '_') + "(this.form.id);";
        return result;
    }

    private String src(FacesContext context, String value) {
        if (value == null) {
            return "";
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

