/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

public class Status {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int NUM_STATES = 4;
    private int type;
    private String reason;
    public static final String EXIT_PREFIX = "STATUS:";
    private static String[] texts = new String[]{"Passed.", "Failed.", "Error.", "Not run."};
    public static final int[] exitCodes = new int[]{95, 97, 98, 99};

    public static Status passed(String string) {
        return new Status(0, string);
    }

    public static Status failed(String string) {
        return new Status(1, string);
    }

    public static Status error(String string) {
        return new Status(2, string);
    }

    public static Status notApplicable(String string) {
        return new Status(1, "Not Applicable: " + string);
    }

    static Status notRun(String string) {
        return new Status(3, string);
    }

    public boolean isPassed() {
        return this.type == 0;
    }

    public boolean isFailed() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public Status augment(String string) {
        if (string == null || string.length() == 0) {
            return this;
        }
        return new Status(this.type, this.reason + " [" + string + "]");
    }

    public Status augment(Status status) {
        return status == null ? this : this.augment(status.reason);
    }

    public static Status parse(String string) {
        try {
            return new Status(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private Status(String string) {
        int n = 0;
        while (n < texts.length) {
            if (string.startsWith(texts[n])) {
                int n2 = texts[n].length();
                String string2 = n2 < string.length() ? (string.charAt(n2) == ' ' ? string.substring(n2 + 1) : string.substring(n2)) : "";
                this.type = n;
                this.reason = string2;
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        if (this.reason == null || this.reason.length() == 0) {
            return texts[this.type];
        }
        return texts[this.type] + " " + this.reason;
    }

    public static String typeToString(int n) {
        if (n < 4) {
            return texts[n];
        }
        return null;
    }

    public void exit() {
        if (System.err != null) {
            System.err.print(EXIT_PREFIX);
            System.err.print(texts[this.type]);
            System.err.println(this.reason);
            System.err.flush();
        }
        System.exit(exitCodes[this.type]);
    }

    public Status(int n, String string) {
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Status.isPrintable(string.charAt(n2))) {
                StringBuffer stringBuffer = new StringBuffer(string.length());
                int n3 = 0;
                while (n3 < string.length()) {
                    char c = string.charAt(n3);
                    stringBuffer.append(Status.isPrintable(c) ? c : (char)' ');
                    ++n3;
                }
                string = stringBuffer.toString();
                break;
            }
            ++n2;
        }
        this.type = n;
        this.reason = string.trim();
    }

    private static final boolean isPrintable(char c) {
        return ' ' <= c && c < '\u007f';
    }
}

