/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.FullItemDescription;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class DescriptionFormat {
    protected boolean isQualifiedName;
    protected boolean isThrowsTracked;
    private boolean isNestedStatic = true;
    private boolean isNestedProtected = true;

    public DescriptionFormat(boolean bl, boolean bl2, Properties properties) {
        this.isQualifiedName = bl;
        this.isThrowsTracked = bl2;
        this.isNestedStatic = properties.getProperty("NestedStatic") == null;
        this.isNestedProtected = properties.getProperty("NestedProtected") == null;
    }

    public DescriptionFormat() {
        this.isQualifiedName = true;
        this.isThrowsTracked = true;
    }

    public String convertShortDescription(FullItemDescription fullItemDescription) {
        String string = this.convertDescription(fullItemDescription, true);
        if (string.startsWith("CLSS ")) {
            return "innr " + string.substring("CLSS ".length());
        }
        return string;
    }

    public String convertDescription(FullItemDescription fullItemDescription) {
        String string = this.convertDescription(fullItemDescription, false);
        if (string.startsWith("CLSS ")) {
            return "innr " + string.substring("CLSS ".length());
        }
        return string;
    }

    public String convertClassDescription(FullItemDescription fullItemDescription) {
        String string = this.convertDescription(fullItemDescription, false);
        if (fullItemDescription.isClass()) {
            return string;
        }
        throw new IllegalArgumentException("It's not class");
    }

    public String convertShortClassDescription(FullItemDescription fullItemDescription) {
        String string = this.convertDescription(fullItemDescription, true);
        if (fullItemDescription.isClass()) {
            return string;
        }
        throw new IllegalArgumentException("It's not class");
    }

    private String convertDescription(FullItemDescription fullItemDescription, boolean bl) {
        String string;
        String string2;
        String string3 = fullItemDescription.memberType;
        Vector vector = fullItemDescription.getModifiers();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.isModifierTracked(string2, fullItemDescription)) continue;
            string3 = string3 + string2 + " ";
        }
        string2 = fullItemDescription.getType();
        string3 = string3 + (string2 == null || string2.equals("") ? "" : string2 + " ") + "";
        if ((fullItemDescription.isClass() && !bl || this.isQualifiedName) && (string = fullItemDescription.getDeclaringClass()) != null && !string.equals("")) {
            string3 = string3 + string + (fullItemDescription.isClass() ? "$" : ".");
        }
        string3 = string3 + fullItemDescription.getSignature();
        string = fullItemDescription.getThrowables();
        if (this.isThrowsTracked && string != null && !string.equals("")) {
            string3 = string3 + " " + string;
        }
        return string3;
    }

    private String convertModifiers(FullItemDescription fullItemDescription) {
        String string = "";
        Vector vector = fullItemDescription.getModifiers();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.isModifierTracked(string2, fullItemDescription)) continue;
            string = string + " " + string2;
        }
        return string;
    }

    protected boolean isModifierTracked(String string, FullItemDescription fullItemDescription) {
        return string.equals("public") || string.equals("final") || string.equals("protected") && (this.isNestedProtected || !fullItemDescription.isClass()) || string.equals("static") && (this.isNestedStatic || !fullItemDescription.isClass()) || string.equals("abstract") || string.equals("interface") || string.equals("volatile");
    }
}

