/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.ClassDescription;
import com.sun.tdk.signaturetest.Collections;
import com.sun.tdk.signaturetest.Comparator;
import com.sun.tdk.signaturetest.ErrorFormatter;
import com.sun.tdk.signaturetest.FullItemDescription;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class SortedErrorFormatter
extends ErrorFormatter {
    protected String[] headers = new String[]{"Missing Classes", "Missing Class Definitions", "Missing Superclasses or Superinterfaces", "Missing Fields", "Missing Constructors", "Missing Methods", "Added Classes", "Added Class Definitions", "Added Superclasses or Superinterfaces", "Added Fields", "Added Constructors", "Added Methods", "Changed Classes", "Changed Class Definitions", "Changed Superclasses or Superinterfaces", "Changed Fields", "Changed Constructors", "Changed Methods", "LinkageError"};
    private Hashtable testedsuper = new Hashtable();
    private boolean isVerbose = false;
    protected Vector failedMessages;
    protected int tabSize = 20;

    public SortedErrorFormatter(PrintWriter printWriter, String[] stringArray, boolean bl) {
        super(printWriter);
        this.headers = stringArray;
        this.isVerbose = bl;
    }

    public SortedErrorFormatter(PrintWriter printWriter, boolean bl) {
        super(printWriter);
        this.failedMessages = new Vector();
        this.isVerbose = bl;
    }

    public void Tested(ClassDescription classDescription) {
        if (!this.testedsuper.containsKey(classDescription.getName())) {
            FullItemDescription[] fullItemDescriptionArray;
            if (classDescription.getSuperclass() != null) {
                this.testedsuper.put(classDescription.getName(), classDescription.getSuperclass().getName());
            }
            if ((fullItemDescriptionArray = classDescription.getInterfaces()) != null) {
                int n = 0;
                while (n < fullItemDescriptionArray.length) {
                    this.testedsuper.put(classDescription.getName(), fullItemDescriptionArray[n].getName());
                    ++n;
                }
            }
        }
    }

    public void addError(String string, String string2, String string3, String string4) {
        ErrorFormatter.Message message = this.createError(string, string2, string3, string4);
        this.failedMessages.addElement(message);
        if (!"Deprecated".equals(string)) {
            ++this.size;
        }
    }

    public void printErrors() {
        this.MsgExclude(this.testedsuper);
        Collections.sort(this.failedMessages, (Comparator)new Comp());
        boolean bl = false;
        int n = this.failedMessages.size();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            ErrorFormatter.Message message = (ErrorFormatter.Message)this.failedMessages.elementAt(n3);
            if (message.errorType != n2) {
                if (this.headers != null && message.errorType < this.headers.length) {
                    bl = true;
                    this.out.println("\n" + this.headers[message.errorType] + "\n" + SortedErrorFormatter.space('-', this.headers[message.errorType].length()) + "\n");
                } else {
                    bl = false;
                }
                n2 = message.errorType;
            }
            if (bl) {
                if (message.definition.equals("")) {
                    this.out.println(message.className);
                } else {
                    int n4 = (message.className.length() + 1) / this.tabSize;
                    if ((message.className.length() + 1) % this.tabSize != 0) {
                        ++n4;
                    }
                    this.out.println(message.className + ":" + SortedErrorFormatter.space(' ', (n4 *= this.tabSize) - message.className.length() - 1) + ErrorFormatter.toString(message.definition));
                    if (this.isVerbose && message.tail.length() != 0) {
                        this.out.println("--- affected " + message.tail);
                    }
                }
            } else {
                this.out.println(message);
            }
            ++n3;
        }
        if (this.failedMessages.size() > 0) {
            this.out.println("");
        }
    }

    protected static String space(char c, int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray);
    }

    public void MsgExclude(Hashtable hashtable) {
        int n;
        int n2;
        Vector<Object> vector;
        Object object;
        Vector<Vector<Object>> vector2 = new Vector<Vector<Object>>();
        int n3 = 0;
        while (n3 < this.failedMessages.size()) {
            Object object2;
            object = (ErrorFormatter.Message)this.failedMessages.elementAt(n3);
            vector = null;
            n2 = 0;
            while (n2 < vector2.size()) {
                object2 = (Vector)vector2.elementAt(n2);
                if (this.MsgCompare((ErrorFormatter.Message)((Vector)object2).firstElement(), (ErrorFormatter.Message)object)) {
                    vector = (Vector)vector2.elementAt(n2);
                    break;
                }
                ++n2;
            }
            if (vector == null) {
                n = n3 + 1;
                while (n < this.failedMessages.size()) {
                    object2 = (ErrorFormatter.Message)this.failedMessages.elementAt(n);
                    if (this.MsgCompare((ErrorFormatter.Message)object2, (ErrorFormatter.Message)object)) {
                        if (vector == null) {
                            vector = new Vector<Object>();
                            vector2.addElement(vector);
                            vector.addElement(object);
                        }
                        vector.addElement(object2);
                    }
                    ++n;
                }
            }
            ++n3;
        }
        object = new Vector();
        n2 = 0;
        while (n2 < vector2.size()) {
            Object object3;
            Object object4;
            vector = (Vector)vector2.elementAt(n2);
            n = 0;
            while (n < vector.size()) {
                boolean bl = true;
                block5: while (bl) {
                    bl = false;
                    object4 = (ErrorFormatter.Message)vector.elementAt(n);
                    object3 = (String)hashtable.get(((ErrorFormatter.Message)object4).className);
                    if (object3 == null) continue;
                    n3 = n + 1;
                    while (n3 < vector.size()) {
                        ErrorFormatter.Message message = (ErrorFormatter.Message)vector.elementAt(n3);
                        if (message.className.equals(object3)) {
                            vector.setElementAt(message, n);
                            vector.setElementAt(object4, n3);
                            bl = true;
                            continue block5;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            n = vector.size();
            block7: while (--n >= 0) {
                ErrorFormatter.Message message = (ErrorFormatter.Message)vector.elementAt(n);
                object4 = (String)hashtable.get(message.className);
                if (object4 == null) continue;
                n3 = n;
                while (--n3 >= 0) {
                    object3 = (ErrorFormatter.Message)vector.elementAt(n3);
                    if (!((ErrorFormatter.Message)object3).className.equals(object4)) continue;
                    if (((ErrorFormatter.Message)object3).tail.length() != 0) {
                        ((ErrorFormatter.Message)object3).tail = ((ErrorFormatter.Message)object3).tail + ",";
                    }
                    ((ErrorFormatter.Message)object3).tail = ((ErrorFormatter.Message)object3).tail + message.className;
                    if (message.tail.length() != 0) {
                        ((ErrorFormatter.Message)object3).tail = ((ErrorFormatter.Message)object3).tail + "," + message.tail;
                    }
                    ((Vector)object).addElement(vector.elementAt(n));
                    --this.size;
                    continue block7;
                }
            }
            ++n2;
        }
        n3 = this.failedMessages.size();
        block9: while (--n3 >= 0) {
            vector = (ErrorFormatter.Message)this.failedMessages.elementAt(n3);
            n = 0;
            while (n < ((Vector)object).size()) {
                ErrorFormatter.Message message = (ErrorFormatter.Message)((Vector)object).elementAt(n);
                if (vector == message) {
                    this.failedMessages.removeElementAt(n3);
                    continue block9;
                }
                ++n;
            }
        }
    }

    protected boolean MsgCompare(ErrorFormatter.Message message, ErrorFormatter.Message message2) {
        return message.errorType == message2.errorType && message.definition.equals(message2.definition) && message.messages == message2.messages;
    }

    public class Comp
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((ErrorFormatter.Message)object).compareTo((ErrorFormatter.Message)object2);
        }
    }
}

