/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.Connection;
import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAuthHandler;
import com.novell.ldap.LDAPAuthProvider;
import com.novell.ldap.LDAPBindHandler;
import com.novell.ldap.LDAPBindRequest;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPReferralHandler;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPUnsolicitedNotificationListener;
import com.novell.ldap.LDAPUrl;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.rfc2251.RfcBindRequest;
import com.novell.ldap.rfc2251.RfcBindResponse;
import com.novell.security.sasl.Sasl;
import com.novell.security.sasl.SaslClient;
import com.novell.security.sasl.SaslException;
import java.io.Externalizable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.callback.CallbackHandler;

public class LDAPConnection
implements Cloneable {
    private LDAPSearchConstraints defSearchCons = new LDAPSearchConstraints();
    private LDAPControl[] responseCtls = null;
    private Object responseCtlSemaphore = new Object();
    private Connection conn = null;
    private static Object nameLock = new Object();
    private static int lConnNum = 0;
    private String name;
    public static final int SCOPE_BASE = 0;
    public static final int SCOPE_ONE = 1;
    public static final int SCOPE_SUB = 2;
    public static final int SCOPE_SUBORDINATESUBTREE = 4;
    public static final String NO_ATTRS = "1.1";
    public static final String ALL_USER_ATTRS = "*";
    public static final int LDAP_V3 = 3;
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    public static final String SERVER_SHUTDOWN_OID = "1.3.6.1.4.1.1466.20036";
    private static final String START_TLS_OID = "1.3.6.1.4.1.1466.20037";

    public LDAPConnection() {
        this(null);
    }

    public LDAPConnection(LDAPSocketFactory lDAPSocketFactory) {
        this.conn = new Connection(lDAPSocketFactory);
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
            LDAPConnection lDAPConnection = (LDAPConnection)object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
        lDAPConnection.conn = this.conn;
        lDAPConnection.defSearchCons = this.defSearchCons != null ? (LDAPSearchConstraints)this.defSearchCons.clone() : null;
        if (this.responseCtls != null) {
            lDAPConnection.responseCtls = new LDAPControl[this.responseCtls.length];
            for (int i = 0; i < this.responseCtls.length; ++i) {
                lDAPConnection.responseCtls[i] = (LDAPControl)this.responseCtls[i].clone();
            }
        } else {
            lDAPConnection.responseCtls = null;
        }
        this.conn.incrCloneCount();
        return object;
    }

    protected void finalize() throws LDAPException {
        this.disconnect(this.defSearchCons, false);
    }

    public int getProtocolVersion() {
        BindProperties bindProperties = this.conn.getBindProperties();
        if (bindProperties == null) {
            return 3;
        }
        return bindProperties.getProtocolVersion();
    }

    public String getAuthenticationDN() {
        BindProperties bindProperties = this.conn.getBindProperties();
        if (bindProperties == null) {
            return null;
        }
        if (bindProperties.isAnonymous()) {
            return null;
        }
        return bindProperties.getAuthenticationDN();
    }

    public String getAuthenticationMethod() {
        BindProperties bindProperties = this.conn.getBindProperties();
        if (bindProperties == null) {
            return "simple";
        }
        return this.conn.getBindProperties().getAuthenticationMethod();
    }

    public Map getSaslBindProperties() {
        BindProperties bindProperties = this.conn.getBindProperties();
        if (bindProperties == null) {
            return null;
        }
        return this.conn.getBindProperties().getSaslBindProperties();
    }

    public Object getSaslBindCallbackHandler() {
        BindProperties bindProperties = this.conn.getBindProperties();
        if (bindProperties == null) {
            return null;
        }
        return this.conn.getBindProperties().getSaslCallbackHandler();
    }

    public LDAPConstraints getConstraints() {
        return (LDAPConstraints)this.defSearchCons.clone();
    }

    public String getHost() {
        return this.conn.getHost();
    }

    public int getPort() {
        return this.conn.getPort();
    }

    public Object getProperty(String string) {
        if (string.equalsIgnoreCase(LDAP_PROPERTY_SDK)) {
            return Connection.sdk;
        }
        if (string.equalsIgnoreCase(LDAP_PROPERTY_PROTOCOL)) {
            return Connection.protocol;
        }
        if (string.equalsIgnoreCase(LDAP_PROPERTY_SECURITY)) {
            return Connection.security;
        }
        return null;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return (LDAPSearchConstraints)this.defSearchCons.clone();
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.conn.getSocketFactory();
    }

    public boolean isBound() {
        return this.conn.isBound();
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public boolean isConnectionAlive() {
        return this.conn.isConnectionAlive();
    }

    public boolean isTLS() {
        return this.conn.isTLS();
    }

    public void setConstraints(LDAPConstraints lDAPConstraints) {
        Hashtable hashtable;
        if (lDAPConstraints instanceof LDAPSearchConstraints) {
            this.defSearchCons = (LDAPSearchConstraints)lDAPConstraints.clone();
            return;
        }
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)this.defSearchCons.clone();
        lDAPSearchConstraints.setHopLimit(lDAPConstraints.getHopLimit());
        lDAPSearchConstraints.setTimeLimit(lDAPConstraints.getTimeLimit());
        lDAPSearchConstraints.setReferralHandler(lDAPConstraints.getReferralHandler());
        lDAPSearchConstraints.setReferralFollowing(lDAPConstraints.getReferralFollowing());
        LDAPControl[] lDAPControlArray = lDAPConstraints.getControls();
        if (lDAPControlArray != null) {
            lDAPSearchConstraints.setControls(lDAPControlArray);
        }
        if ((hashtable = lDAPSearchConstraints.getProperties()) != null) {
            lDAPSearchConstraints.setProperties(hashtable);
        }
        this.defSearchCons = lDAPSearchConstraints;
    }

    public static void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        Connection.setSocketFactory(lDAPSocketFactory);
    }

    public void addUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        if (lDAPUnsolicitedNotificationListener != null) {
            this.conn.addUnsolicitedNotificationListener(lDAPUnsolicitedNotificationListener);
        }
    }

    public void removeUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        if (lDAPUnsolicitedNotificationListener != null) {
            this.conn.removeUnsolicitedNotificationListener(lDAPUnsolicitedNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTLS() throws LDAPException {
        LDAPMessage lDAPMessage = this.makeExtendedOperation(new LDAPExtendedOperation(START_TLS_OID, null), null);
        int n = lDAPMessage.getMessageID();
        this.conn.acquireWriteSemaphore(n);
        try {
            if (!this.conn.areMessagesComplete()) {
                throw new LDAPLocalException("OUTSTANDING_OPERATIONS", 1);
            }
            this.conn.stopReaderOnReply(n);
            LDAPResponseQueue lDAPResponseQueue = this.sendRequestToServer(lDAPMessage, this.defSearchCons.getTimeLimit(), null, null);
            LDAPExtendedResponse lDAPExtendedResponse = (LDAPExtendedResponse)lDAPResponseQueue.getResponse();
            lDAPExtendedResponse.chkResultCode();
            this.conn.startTLS();
        }
        finally {
            this.conn.startReader();
            this.conn.freeWriteSemaphore(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTLS() throws LDAPException {
        if (!this.isTLS()) {
            throw new LDAPLocalException("NO_STARTTLS", 1);
        }
        int n = this.conn.acquireWriteSemaphore();
        try {
            if (!this.conn.areMessagesComplete()) {
                throw new LDAPLocalException("OUTSTANDING_OPERATIONS", 1);
            }
            this.conn.stopTLS();
        }
        finally {
            this.conn.freeWriteSemaphore(n);
        }
    }

    public void abandon(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        this.abandon(lDAPSearchResults, (LDAPConstraints)this.defSearchCons);
    }

    public void abandon(LDAPSearchResults lDAPSearchResults, LDAPConstraints lDAPConstraints) throws LDAPException {
        lDAPSearchResults.abandon();
    }

    public void abandon(int n) throws LDAPException {
        this.abandon(n, (LDAPConstraints)this.defSearchCons);
    }

    public void abandon(int n, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            MessageAgent messageAgent = this.conn.getMessageAgent(n);
            messageAgent.abandon(n, lDAPConstraints);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    public void abandon(LDAPMessageQueue lDAPMessageQueue) throws LDAPException {
        this.abandon(lDAPMessageQueue, (LDAPConstraints)this.defSearchCons);
    }

    public void abandon(LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPMessageQueue != null) {
            MessageAgent messageAgent = lDAPMessageQueue instanceof LDAPSearchQueue ? lDAPMessageQueue.getMessageAgent() : lDAPMessageQueue.getMessageAgent();
            int[] nArray = messageAgent.getMessageIDs();
            for (int i = 0; i < nArray.length; ++i) {
                messageAgent.abandon(nArray[i], lDAPConstraints);
            }
        }
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        this.add(lDAPEntry, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LDAPEntry lDAPEntry, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPResponseQueue lDAPResponseQueue = this.add(lDAPEntry, null, lDAPConstraints);
        LDAPResponse lDAPResponse = (LDAPResponse)lDAPResponseQueue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = lDAPResponse.getControls();
        }
        this.chkResultCode(lDAPResponseQueue, lDAPConstraints, lDAPResponse);
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.add(lDAPEntry, lDAPResponseQueue, this.defSearchCons);
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        if (lDAPEntry == null) {
            throw new IllegalArgumentException("The LDAPEntry parameter cannot be null");
        }
        if (lDAPEntry.getDN() == null) {
            throw new IllegalArgumentException("The DN value must be present in the LDAPEntry object");
        }
        LDAPAddRequest lDAPAddRequest = new LDAPAddRequest(lDAPEntry, lDAPConstraints.getControls());
        return this.sendRequestToServer(lDAPAddRequest, lDAPConstraints.getTimeLimit(), lDAPResponseQueue, null);
    }

    public void bind(String string, String string2) throws LDAPException {
        this.bind(3, string, string2, (LDAPConstraints)this.defSearchCons);
    }

    public void bind(int n, String string, String string2) throws LDAPException {
        this.bind(n, string, string2, (LDAPConstraints)this.defSearchCons);
    }

    public void bind(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(3, string, string2, lDAPConstraints);
    }

    public void bind(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        byte[] byArray = null;
        if (string2 != null) {
            try {
                byArray = string2.getBytes("UTF8");
                string2 = null;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = null;
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
        }
        this.bind(n, string, byArray, lDAPConstraints);
    }

    public void bind(int n, String string, byte[] byArray) throws LDAPException {
        this.bind(n, string, byArray, (LDAPConstraints)this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(int n, String string, byte[] byArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPResponseQueue lDAPResponseQueue = this.bind(n, string, byArray, null, lDAPConstraints);
        LDAPResponse lDAPResponse = (LDAPResponse)lDAPResponseQueue.getResponse();
        if (lDAPResponse != null) {
            Object object = this.responseCtlSemaphore;
            synchronized (object) {
                this.responseCtls = lDAPResponse.getControls();
            }
            this.chkResultCode(lDAPResponseQueue, lDAPConstraints, lDAPResponse);
        }
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.bind(n, string, byArray, lDAPResponseQueue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        string = string == null ? "" : string.trim();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        boolean bl = false;
        if (byArray.length == 0) {
            bl = true;
            string = "";
        }
        LDAPBindRequest lDAPBindRequest = new LDAPBindRequest(n, string, byArray, lDAPConstraints.getControls());
        int n2 = lDAPBindRequest.getMessageID();
        BindProperties bindProperties = new BindProperties(n, string, "simple", bl, null, null);
        if (!this.conn.isConnected()) {
            if (this.conn.getHost() != null) {
                this.conn.connect(this.conn.getHost(), this.conn.getPort());
            } else {
                throw new LDAPException("CONNECTION_IMPOSSIBLE", 91, null);
            }
        }
        this.conn.acquireWriteSemaphore(n2);
        return this.sendRequestToServer(lDAPBindRequest, lDAPConstraints.getTimeLimit(), lDAPResponseQueue, bindProperties);
    }

    public void bind(String string, String string2, Map map, Object object) throws LDAPException {
        this.bind(string, string2, map, object, (LDAPConstraints)this.defSearchCons);
    }

    public void bind(String string, String string2, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        throw new LDAPLocalException("NOT_IMPLEMENTED", new Object[]{"LDAPConnection.bind(with mechanisms)"}, 92);
    }

    public void bind(String string, String string2, String[] stringArray, Map map, Object object) throws LDAPException {
        this.bind(string, string2, stringArray, map, object, this.defSearchCons);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind(String string, String string2, String[] stringArray, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        try {
            SaslClient saslClient = Sasl.createSaslClient(stringArray, string2, "ldap", this.getHost(), map, (CallbackHandler)object);
            if (saslClient == null) {
                throw new LDAPException("Unsupported SASL mechanism(s) and/or properties", 7, null);
            }
            byte[] byArray = null;
            boolean bl = false;
            BindProperties bindProperties = new BindProperties(3, null, "sasl", bl, null, null);
            int n = this.conn.acquireWriteSemaphore();
            this.conn.setBindSemId(n);
            if (saslClient.hasInitialResponse()) {
                byArray = saslClient.evaluateChallenge(new byte[0]);
            }
            while (!saslClient.isComplete()) {
                try {
                    byte[] byArray2 = this.LDAPTransport(byArray, saslClient.getMechanismName(), bindProperties);
                    if (byArray2 != null) {
                        byArray = saslClient.evaluateChallenge(byArray2);
                        continue;
                    }
                    byArray = saslClient.evaluateChallenge(new byte[0]);
                }
                catch (SaslException saslException) {
                    saslClient.dispose();
                    throw new LDAPException("Unexpected SASL error.", 80, null, saslException);
                }
                catch (LDAPException lDAPException) {
                    saslClient.dispose();
                    throw lDAPException;
                    return;
                }
            }
        }
        catch (SaslException saslException) {
            throw new LDAPException("SASL Bind Error.", 80, null, saslException.getCause());
        }
    }

    private byte[] LDAPTransport(byte[] byArray, String string, BindProperties bindProperties) throws LDAPException {
        LDAPSearchConstraints lDAPSearchConstraints = this.defSearchCons;
        LDAPMessage lDAPMessage = new LDAPMessage(0, new RfcBindRequest(3, "", string, byArray), lDAPSearchConstraints.getControls());
        LDAPResponseQueue lDAPResponseQueue = this.sendRequestToServer(lDAPMessage, lDAPSearchConstraints.getTimeLimit(), null, bindProperties);
        LDAPResponse lDAPResponse = (LDAPResponse)lDAPResponseQueue.getResponse();
        RfcBindResponse rfcBindResponse = (RfcBindResponse)lDAPResponse.getASN1Object().get(1);
        ASN1OctetString aSN1OctetString = rfcBindResponse.getServerSaslCreds();
        int n = lDAPResponse.getResultCode();
        byte[] byArray2 = null;
        if (n == 14 || n == 0) {
            if (aSN1OctetString != null) {
                byArray2 = aSN1OctetString.byteValue();
            }
        } else {
            lDAPResponse.chkResultCode();
            throw new LDAPException("SASL Bind Error.", n, null);
        }
        return byArray2;
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute) throws LDAPException {
        return this.compare(string, lDAPAttribute, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPConstraints lDAPConstraints) throws LDAPException {
        boolean bl = false;
        LDAPResponseQueue lDAPResponseQueue = this.compare(string, lDAPAttribute, null, lDAPConstraints);
        LDAPResponse lDAPResponse = (LDAPResponse)lDAPResponseQueue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = lDAPResponse.getControls();
        }
        if (lDAPResponse.getResultCode() == 6) {
            bl = true;
        } else if (lDAPResponse.getResultCode() == 5) {
            bl = false;
        } else {
            this.chkResultCode(lDAPResponseQueue, lDAPConstraints, lDAPResponse);
        }
        return bl;
    }

    public LDAPResponseQueue compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.compare(string, lDAPAttribute, lDAPResponseQueue, this.defSearchCons);
    }

    public LDAPResponseQueue compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPAttribute.size() != 1) {
            throw new IllegalArgumentException("compare: Exactly one value must be present in the LDAPAttribute");
        }
        if (string == null) {
            throw new IllegalArgumentException("compare: DN cannot be null");
        }
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        LDAPCompareRequest lDAPCompareRequest = new LDAPCompareRequest(string, lDAPAttribute.getName(), lDAPAttribute.getByteValue(), lDAPConstraints.getControls());
        return this.sendRequestToServer(lDAPCompareRequest, lDAPConstraints.getTimeLimit(), lDAPResponseQueue, null);
    }

    public void connect(String string, int n) throws LDAPException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n2 = n;
                string2 = stringTokenizer.nextToken();
                int n3 = string2.indexOf(58);
                if (n3 != -1 && n3 + 1 != string2.length()) {
                    try {
                        n2 = Integer.parseInt(string2.substring(n3 + 1));
                        string2 = string2.substring(0, n3);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("INVALID_ADDRESS");
                    }
                }
                this.conn = this.conn.destroyClone(true);
                this.conn.connect(string2, n2);
                break;
            }
            catch (LDAPException lDAPException) {
                if (stringTokenizer.hasMoreTokens()) continue;
                throw lDAPException;
            }
        }
    }

    public void delete(String string) throws LDAPException {
        this.delete(string, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPResponseQueue lDAPResponseQueue = this.delete(string, null, lDAPConstraints);
        LDAPResponse lDAPResponse = (LDAPResponse)lDAPResponseQueue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = lDAPResponse.getControls();
        }
        this.chkResultCode(lDAPResponseQueue, lDAPConstraints, lDAPResponse);
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.delete(string, lDAPResponseQueue, this.defSearchCons);
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (string == null) {
            throw new IllegalArgumentException("DN_PARAM_ERROR");
        }
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        LDAPDeleteRequest lDAPDeleteRequest = new LDAPDeleteRequest(string, lDAPConstraints.getControls());
        return this.sendRequestToServer(lDAPDeleteRequest, lDAPConstraints.getTimeLimit(), lDAPResponseQueue, null);
    }

    public void disconnect() throws LDAPException {
        this.disconnect(this.defSearchCons, true);
    }

    public void disconnect(LDAPConstraints lDAPConstraints) throws LDAPException {
        this.disconnect(lDAPConstraints, true);
    }

    private void disconnect(LDAPConstraints lDAPConstraints, boolean bl) throws LDAPException {
        this.conn = this.conn.destroyClone(bl);
    }

    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        return this.extendedOperation(lDAPExtendedOperation, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPResponseQueue lDAPResponseQueue = this.extendedOperation(lDAPExtendedOperation, lDAPConstraints, null);
        LDAPExtendedResponse lDAPExtendedResponse = (LDAPExtendedResponse)lDAPResponseQueue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = lDAPExtendedResponse.getControls();
        }
        this.chkResultCode(lDAPResponseQueue, lDAPConstraints, lDAPExtendedResponse);
        return lDAPExtendedResponse;
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.extendedOperation(lDAPExtendedOperation, this.defSearchCons, lDAPResponseQueue);
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPConstraints lDAPConstraints, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        LDAPMessage lDAPMessage = this.makeExtendedOperation(lDAPExtendedOperation, lDAPConstraints);
        return this.sendRequestToServer(lDAPMessage, lDAPConstraints.getTimeLimit(), lDAPResponseQueue, null);
    }

    protected LDAPMessage makeExtendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        if (lDAPExtendedOperation.getID() == null) {
            throw new IllegalArgumentException("OP_PARAM_ERROR");
        }
        return new LDAPExtendedRequest(lDAPExtendedOperation, lDAPConstraints.getControls());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPControl[] getResponseControls() {
        if (this.responseCtls == null) {
            return null;
        }
        LDAPControl[] lDAPControlArray = new LDAPControl[this.responseCtls.length];
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            for (int i = 0; i < this.responseCtls.length; ++i) {
                lDAPControlArray[i] = (LDAPControl)this.responseCtls[i].clone();
            }
        }
        return lDAPControlArray;
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, lDAPModification, (LDAPConstraints)this.defSearchCons);
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        this.modify(string, lDAPModificationArray, lDAPConstraints);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        this.modify(string, lDAPModificationArray, (LDAPConstraints)this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPResponseQueue lDAPResponseQueue = this.modify(string, lDAPModificationArray, null, lDAPConstraints);
        LDAPResponse lDAPResponse = (LDAPResponse)lDAPResponseQueue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = lDAPResponse.getControls();
        }
        this.chkResultCode(lDAPResponseQueue, lDAPConstraints, lDAPResponse);
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.modify(string, lDAPModification, lDAPResponseQueue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        return this.modify(string, lDAPModificationArray, lDAPResponseQueue, lDAPConstraints);
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.modify(string, lDAPModificationArray, lDAPResponseQueue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (string == null) {
            throw new IllegalArgumentException("DN_PARAM_ERROR");
        }
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        LDAPModifyRequest lDAPModifyRequest = new LDAPModifyRequest(string, lDAPModificationArray, lDAPConstraints.getControls());
        return this.sendRequestToServer(lDAPModifyRequest, lDAPConstraints.getTimeLimit(), lDAPResponseQueue, null);
    }

    public LDAPEntry read(String string) throws LDAPException {
        return this.read(string, this.defSearchCons);
    }

    public LDAPEntry read(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.read(string, null, lDAPSearchConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray) throws LDAPException {
        return this.read(string, stringArray, this.defSearchCons);
    }

    public LDAPEntry read(String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = this.search(string, 0, null, stringArray, false, lDAPSearchConstraints);
        LDAPEntry lDAPEntry = null;
        if (lDAPSearchResults.hasMore()) {
            lDAPEntry = lDAPSearchResults.next();
            if (lDAPSearchResults.hasMore()) {
                throw new LDAPLocalException("READ_MULTIPLE", 101);
            }
        }
        return lDAPEntry;
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
        LDAPEntry lDAPEntry = lDAPConnection.read(lDAPUrl.getDN(), lDAPUrl.getAttributeArray());
        lDAPConnection.disconnect();
        return lDAPEntry;
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
        LDAPEntry lDAPEntry = lDAPConnection.read(lDAPUrl.getDN(), lDAPUrl.getAttributeArray(), lDAPSearchConstraints);
        lDAPConnection.disconnect();
        return lDAPEntry;
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        this.rename(string, string2, bl, this.defSearchCons);
    }

    public void rename(String string, String string2, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.rename(string, string2, null, bl, lDAPConstraints);
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        this.rename(string, string2, string3, bl, (LDAPConstraints)this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2, String string3, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPResponseQueue lDAPResponseQueue = this.rename(string, string2, string3, bl, null, lDAPConstraints);
        LDAPResponse lDAPResponse = (LDAPResponse)lDAPResponseQueue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = lDAPResponse.getControls();
        }
        this.chkResultCode(lDAPResponseQueue, lDAPConstraints, lDAPResponse);
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.rename(string, string2, bl, lDAPResponseQueue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return this.rename(string, string2, null, bl, lDAPResponseQueue, lDAPConstraints);
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return this.rename(string, string2, string3, bl, lDAPResponseQueue, this.defSearchCons);
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("RDN_PARAM_ERROR");
        }
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        LDAPModifyDNRequest lDAPModifyDNRequest = new LDAPModifyDNRequest(string, string2, string3, bl, lDAPConstraints.getControls());
        return this.sendRequestToServer(lDAPModifyDNRequest, lDAPConstraints.getTimeLimit(), lDAPResponseQueue, null);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, this.defSearchCons);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchQueue lDAPSearchQueue = this.search(string, n, string2, stringArray, bl, null, lDAPSearchConstraints);
        if (lDAPSearchConstraints == null) {
            lDAPSearchConstraints = this.defSearchCons;
        }
        return new LDAPSearchResults(this, lDAPSearchQueue, lDAPSearchConstraints);
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, lDAPSearchQueue, this.defSearchCons);
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        MessageAgent messageAgent;
        if (string2 == null) {
            string2 = "objectclass=*";
        }
        if (lDAPSearchConstraints == null) {
            lDAPSearchConstraints = this.defSearchCons;
        }
        LDAPSearchRequest lDAPSearchRequest = new LDAPSearchRequest(string, n, string2, stringArray, lDAPSearchConstraints.getDereference(), lDAPSearchConstraints.getMaxResults(), lDAPSearchConstraints.getServerTimeLimit(), bl, lDAPSearchConstraints.getControls());
        LDAPSearchQueue lDAPSearchQueue2 = lDAPSearchQueue;
        if (lDAPSearchQueue2 == null) {
            messageAgent = new MessageAgent();
            lDAPSearchQueue2 = new LDAPSearchQueue(messageAgent);
        } else {
            messageAgent = lDAPSearchQueue.getMessageAgent();
        }
        messageAgent.sendMessage(this.conn, lDAPSearchRequest, lDAPSearchConstraints.getTimeLimit(), lDAPSearchQueue2, null);
        return lDAPSearchQueue2;
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl) throws LDAPException {
        return LDAPConnection.search(lDAPUrl, null);
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
        lDAPSearchConstraints = lDAPSearchConstraints == null ? lDAPConnection.getSearchConstraints() : (LDAPSearchConstraints)lDAPSearchConstraints.clone();
        lDAPSearchConstraints.setBatchSize(0);
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN(), lDAPUrl.getScope(), lDAPUrl.getFilter(), lDAPUrl.getAttributeArray(), false, lDAPSearchConstraints);
        lDAPConnection.disconnect();
        return lDAPSearchResults;
    }

    public LDAPMessageQueue sendRequest(LDAPMessage lDAPMessage, LDAPMessageQueue lDAPMessageQueue) throws LDAPException {
        return this.sendRequest(lDAPMessage, lDAPMessageQueue, null);
    }

    public LDAPMessageQueue sendRequest(LDAPMessage lDAPMessage, LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        MessageAgent messageAgent;
        LDAPMessageQueue lDAPMessageQueue2;
        if (!lDAPMessage.isRequest()) {
            throw new RuntimeException("Object is not a request message");
        }
        if (lDAPConstraints == null) {
            lDAPConstraints = this.defSearchCons;
        }
        if ((lDAPMessageQueue2 = lDAPMessageQueue) == null) {
            messageAgent = new MessageAgent();
            lDAPMessageQueue2 = lDAPMessage.getType() == 3 ? new LDAPSearchQueue(messageAgent) : new LDAPResponseQueue(messageAgent);
        } else {
            messageAgent = lDAPMessage.getType() == 3 ? lDAPMessageQueue.getMessageAgent() : lDAPMessageQueue.getMessageAgent();
        }
        messageAgent.sendMessage(this.conn, lDAPMessage, lDAPConstraints.getTimeLimit(), lDAPMessageQueue2, null);
        return lDAPMessageQueue2;
    }

    private LDAPResponseQueue sendRequestToServer(LDAPMessage lDAPMessage, int n, LDAPResponseQueue lDAPResponseQueue, BindProperties bindProperties) throws LDAPException {
        MessageAgent messageAgent;
        if (lDAPResponseQueue == null) {
            messageAgent = new MessageAgent();
            lDAPResponseQueue = new LDAPResponseQueue(messageAgent);
        } else {
            messageAgent = lDAPResponseQueue.getMessageAgent();
        }
        messageAgent.sendMessage(this.conn, lDAPMessage, n, lDAPResponseQueue, bindProperties);
        return lDAPResponseQueue;
    }

    Connection getConnection() {
        return this.conn;
    }

    String getConnectionName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReferralInfo getReferralConnection(String[] stringArray) throws LDAPReferralException {
        Object object;
        ReferralInfo referralInfo = null;
        Throwable throwable = null;
        LDAPConnection lDAPConnection = null;
        LDAPReferralHandler lDAPReferralHandler = this.defSearchCons.getReferralHandler();
        int n = 0;
        if (lDAPReferralHandler != null && !(lDAPReferralHandler instanceof LDAPAuthHandler)) {
            try {
                lDAPConnection = ((LDAPBindHandler)lDAPReferralHandler).bind(stringArray, this);
                if (lDAPConnection == null) {
                    LDAPReferralException lDAPReferralException = new LDAPReferralException("REFERRAL_ERROR");
                    lDAPReferralException.setReferrals(stringArray);
                    throw lDAPReferralException;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        object = new LDAPUrl(stringArray[i]);
                        if (!((LDAPUrl)object).getHost().equalsIgnoreCase(lDAPConnection.getHost()) || ((LDAPUrl)object).getPort() != lDAPConnection.getPort()) continue;
                        referralInfo = new ReferralInfo(lDAPConnection, stringArray, (LDAPUrl)object);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (referralInfo == null) {
                    throwable = new LDAPLocalException("REFERRAL_BIND_MATCH", 91);
                }
            }
            catch (Throwable throwable2) {
                lDAPConnection = null;
                throwable = throwable2;
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                String string = null;
                object = null;
                try {
                    lDAPConnection = new LDAPConnection(this.conn.getSocketFactory());
                    lDAPConnection.setConstraints(this.defSearchCons);
                    LDAPUrl lDAPUrl = new LDAPUrl(stringArray[n]);
                    lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
                    if (lDAPReferralHandler != null && lDAPReferralHandler instanceof LDAPAuthHandler) {
                        LDAPAuthProvider lDAPAuthProvider = ((LDAPAuthHandler)lDAPReferralHandler).getAuthProvider(lDAPUrl.getHost(), lDAPUrl.getPort());
                        string = lDAPAuthProvider.getDN();
                        object = lDAPAuthProvider.getPassword();
                    }
                    lDAPConnection.bind(3, string, (byte[])object);
                    throwable = null;
                    referralInfo = new ReferralInfo(lDAPConnection, stringArray, lDAPUrl);
                    lDAPConnection.getConnection().setActiveReferral(referralInfo);
                    break;
                }
                catch (Throwable throwable3) {
                    if (lDAPConnection == null) continue;
                    try {
                        lDAPConnection.disconnect();
                        lDAPConnection = null;
                        throwable = throwable3;
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        if (throwable == null) {
            return referralInfo;
        }
        if (throwable instanceof LDAPReferralException) {
            throw (LDAPReferralException)throwable;
        }
        LDAPException lDAPException = throwable instanceof LDAPException ? (LDAPException)throwable : new LDAPLocalException("SERVER_CONNECT_ERROR", new Object[]{this.conn.getHost()}, 91, throwable);
        object = new LDAPReferralException("REFERRAL_ERROR", lDAPException);
        ((LDAPReferralException)object).setReferrals(stringArray);
        ((LDAPReferralException)object).setFailedReferral(stringArray[stringArray.length - 1]);
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chkResultCode(LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints, LDAPResponse lDAPResponse) throws LDAPException {
        if (lDAPResponse.getResultCode() == 10 && lDAPConstraints.getReferralFollowing()) {
            ArrayList arrayList = null;
            try {
                this.chaseReferral(lDAPMessageQueue, lDAPConstraints, lDAPResponse, lDAPResponse.getReferrals(), 0, false, null);
            }
            finally {
                this.releaseReferralConnections(arrayList);
            }
        } else {
            lDAPResponse.chkResultCode();
        }
    }

    ArrayList chaseReferral(LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints, LDAPMessage lDAPMessage, String[] stringArray, int n, boolean bl, ArrayList arrayList) throws LDAPException {
        Externalizable externalizable;
        LDAPMessage lDAPMessage2;
        String[] stringArray2;
        ArrayList arrayList2 = arrayList;
        LDAPConnection lDAPConnection = null;
        ReferralInfo referralInfo = null;
        if (arrayList2 == null) {
            arrayList2 = new ArrayList(lDAPConstraints.getHopLimit());
        }
        if (stringArray != null) {
            stringArray2 = stringArray;
            lDAPMessage2 = lDAPMessage.getRequestingMessage();
        } else {
            externalizable = (LDAPResponse)lDAPMessageQueue.getResponse();
            if (externalizable.getResultCode() != 10) {
                externalizable.chkResultCode();
                return arrayList2;
            }
            stringArray2 = externalizable.getReferrals();
            lDAPMessage2 = externalizable.getRequestingMessage();
        }
        try {
            if (n++ > lDAPConstraints.getHopLimit()) {
                throw new LDAPLocalException("Max hops exceeded", 97);
            }
            referralInfo = this.getReferralConnection(stringArray2);
            lDAPConnection = referralInfo.getReferralConnection();
            externalizable = referralInfo.getReferralUrl();
            arrayList2.add(lDAPConnection);
            LDAPMessage lDAPMessage3 = this.rebuildRequest(lDAPMessage2, (LDAPUrl)externalizable, bl);
            try {
                MessageAgent messageAgent = lDAPMessageQueue instanceof LDAPResponseQueue ? lDAPMessageQueue.getMessageAgent() : lDAPMessageQueue.getMessageAgent();
                messageAgent.sendMessage(lDAPConnection.getConnection(), lDAPMessage3, this.defSearchCons.getTimeLimit(), lDAPMessageQueue, null);
            }
            catch (InterThreadException interThreadException) {
                LDAPReferralException lDAPReferralException = new LDAPReferralException("REFERRAL_SEND", 91, null, interThreadException);
                lDAPReferralException.setReferrals(stringArray);
                ReferralInfo referralInfo2 = lDAPConnection.getConnection().getActiveReferral();
                lDAPReferralException.setFailedReferral(referralInfo2.getReferralUrl().toString());
                throw lDAPReferralException;
            }
            if (stringArray != null) {
                return arrayList2;
            }
            arrayList2 = this.chaseReferral(lDAPMessageQueue, lDAPConstraints, null, null, n, false, arrayList2);
        }
        catch (Exception exception) {
            if (exception instanceof LDAPReferralException) {
                throw (LDAPReferralException)exception;
            }
            LDAPReferralException lDAPReferralException = new LDAPReferralException("REFERRAL_ERROR", exception);
            lDAPReferralException.setReferrals(stringArray2);
            if (referralInfo != null) {
                lDAPReferralException.setFailedReferral(referralInfo.getReferralUrl().toString());
            } else {
                lDAPReferralException.setFailedReferral(stringArray2[stringArray2.length - 1]);
            }
            throw lDAPReferralException;
        }
        return arrayList2;
    }

    private LDAPMessage rebuildRequest(LDAPMessage lDAPMessage, LDAPUrl lDAPUrl, boolean bl) throws LDAPException {
        String string = lDAPUrl.getDN();
        String string2 = null;
        switch (lDAPMessage.getType()) {
            case 3: {
                if (!bl) break;
                string2 = lDAPUrl.getFilter();
                break;
            }
            case 0: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 23: {
                break;
            }
            default: {
                throw new LDAPLocalException("IMPROPER_REFERRAL", new Object[]{new Integer(lDAPMessage.getType())}, 82);
            }
        }
        return lDAPMessage.clone(string, string2, bl);
    }

    void releaseReferralConnections(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = (LDAPConnection)arrayList.remove(i);
                lDAPConnection.disconnect();
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                continue;
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    public LDAPSchema fetchSchema(String string) throws LDAPException {
        LDAPEntry lDAPEntry = this.read(string, LDAPSchema.schemaTypeNames);
        return new LDAPSchema(lDAPEntry);
    }

    public String getSchemaDN() throws LDAPException {
        return this.getSchemaDN("");
    }

    public String getSchemaDN(String string) throws LDAPException {
        String[] stringArray = new String[]{"subschemaSubentry"};
        LDAPEntry lDAPEntry = this.read(string, stringArray);
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
        String[] stringArray2 = lDAPAttribute.getStringValueArray();
        if (stringArray2 == null || stringArray2.length < 1) {
            throw new LDAPLocalException("NO_SCHEMA", new Object[]{string}, 94);
        }
        if (stringArray2.length > 1) {
            throw new LDAPLocalException("MULTIPLE_SCHEMA", new Object[]{string}, 19);
        }
        return stringArray2[0];
    }
}

