/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.Connection;
import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPAbandonRequest;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.MessageVector;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.Debug;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcResponse;

class Message {
    private LDAPMessage msg;
    private Connection conn;
    private MessageAgent agent;
    private LDAPMessageQueue queue;
    private int mslimit;
    private Thread timer = null;
    private MessageVector replies = new MessageVector(5, 5);
    private int msgId;
    private boolean acceptReplies = true;
    private boolean waitForReply = true;
    private boolean complete = false;
    private String name;
    private BindProperties bindprops;

    Message(LDAPMessage lDAPMessage, int n, Connection connection, MessageAgent messageAgent, LDAPMessageQueue lDAPMessageQueue, BindProperties bindProperties) {
        this.msg = lDAPMessage;
        this.conn = connection;
        this.agent = messageAgent;
        this.queue = lDAPMessageQueue;
        this.mslimit = n;
        this.msgId = lDAPMessage.getMessageID();
        this.bindprops = bindProperties;
    }

    final void sendMessage() throws LDAPException {
        this.conn.writeMessage(this);
        if (this.mslimit != 0) {
            switch (this.msg.getType()) {
                case 2: 
                case 16: {
                    this.mslimit = 0;
                    break;
                }
                default: {
                    this.timer = new Timeout(this.mslimit, this);
                    this.timer.setDaemon(true);
                    this.timer.start();
                }
            }
        }
    }

    boolean hasReplies() {
        if (this.replies == null) {
            return false;
        }
        return this.replies.size() > 0;
    }

    int getCount() {
        int n = this.replies.size();
        if (this.complete) {
            return n > 0 ? n - 1 : n;
        }
        return n;
    }

    boolean acceptsReplies() {
        return this.acceptReplies;
    }

    void refuseReplies() {
        this.acceptReplies = false;
    }

    void setAgent(MessageAgent messageAgent) {
        this.agent = messageAgent;
    }

    void stopTimer() {
        if (this.timer != null) {
            this.timer.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleepersAwake() {
        MessageVector messageVector = this.replies;
        synchronized (messageVector) {
            this.replies.notify();
        }
        this.agent.sleepersAwake(false);
    }

    boolean isComplete() {
        return this.complete;
    }

    MessageAgent getMessageAgent() {
        return this.agent;
    }

    LDAPMessage getRequest() {
        return this.msg;
    }

    int getMessageID() {
        return this.msgId;
    }

    int getMessageType() {
        if (this.msg == null) {
            return -1;
        }
        return this.msg.getType();
    }

    void putReply(RfcLDAPMessage rfcLDAPMessage) {
        if (!this.acceptReplies) {
            return;
        }
        this.replies.addElement(rfcLDAPMessage);
        rfcLDAPMessage.setRequestingMessage(this.msg);
        switch (rfcLDAPMessage.getType()) {
            case 4: 
            case 19: 
            case 25: {
                break;
            }
            default: {
                int n;
                int n2;
                this.stopTimer();
                this.acceptReplies = false;
                this.complete = true;
                if (this.bindprops == null || (n2 = ((RfcResponse)((Object)rfcLDAPMessage.getResponse())).getResultCode().intValue()) == 14) break;
                if (n2 == 0) {
                    this.conn.setBindProperties(this.bindprops);
                }
                if (this.conn.isBindSemIdClear()) {
                    n = this.msgId;
                } else {
                    n = this.conn.getBindSemId();
                    this.conn.clearBindSemId();
                }
                this.conn.freeWriteSemaphore(n);
            }
        }
        this.sleepersAwake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object waitForReply() {
        if (this.replies == null) {
            return null;
        }
        MessageVector messageVector = this.replies;
        synchronized (messageVector) {
            Object var2_2 = null;
            while (this.waitForReply) {
                if (this.replies.isEmpty()) {
                    try {
                        this.replies.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.waitForReply) break;
                    continue;
                }
                var2_2 = this.replies.remove(0);
                if ((this.complete || !this.acceptReplies) && this.replies.isEmpty()) {
                    this.conn.removeMessage(this);
                }
                return var2_2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getReply() {
        Object e;
        if (this.replies == null) {
            return null;
        }
        MessageVector messageVector = this.replies;
        synchronized (messageVector) {
            if (this.replies.isEmpty()) {
                return null;
            }
            e = this.replies.remove(0);
        }
        if (this.conn != null && (this.complete || !this.acceptReplies) && this.replies.isEmpty()) {
            this.conn.removeMessage(this);
        }
        return e;
    }

    void abandon(LDAPConstraints lDAPConstraints, InterThreadException interThreadException) {
        if (!this.waitForReply) {
            Debug.trace("Messages", this.name + "Abandon request ignored");
            return;
        }
        this.acceptReplies = false;
        this.waitForReply = false;
        if (!this.complete) {
            try {
                if (this.bindprops != null) {
                    int n;
                    if (this.conn.isBindSemIdClear()) {
                        n = this.msgId;
                    } else {
                        n = this.conn.getBindSemId();
                        this.conn.clearBindSemId();
                    }
                    this.conn.freeWriteSemaphore(n);
                }
                LDAPControl[] lDAPControlArray = null;
                if (lDAPConstraints != null) {
                    lDAPControlArray = lDAPConstraints.getControls();
                }
                LDAPAbandonRequest lDAPAbandonRequest = new LDAPAbandonRequest(this.msgId, lDAPControlArray);
                this.conn.writeMessage(lDAPAbandonRequest);
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            if (interThreadException == null) {
                this.agent.abandon(this.msgId, null);
            }
            this.conn.removeMessage(this);
        }
        if (interThreadException != null) {
            this.replies.addElement(new LDAPResponse(interThreadException, this.conn.getActiveReferral()));
            this.stopTimer();
            this.sleepersAwake();
        } else {
            this.sleepersAwake();
            this.cleanup();
        }
    }

    private void cleanup() {
        this.stopTimer();
        try {
            this.acceptReplies = false;
            if (this.conn != null) {
                this.conn.removeMessage(this);
            }
            if (this.replies != null) {
                while (!this.replies.isEmpty()) {
                    this.replies.remove(0);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.conn = null;
        this.msg = null;
        this.queue = null;
        this.bindprops = null;
    }

    final boolean isBindRequest() {
        return this.bindprops != null;
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    private final class Timeout
    extends Thread {
        private int timeToWait = 0;
        private Message message;

        Timeout(int n, Message message2) {
            this.timeToWait = n;
            this.message = message2;
        }

        public final void run() {
            try {
                Timeout.sleep(this.timeToWait);
                this.message.acceptReplies = false;
                this.message.abandon(null, new InterThreadException("Client request timed out", null, 85, null, this.message));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

