/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.DOMWriter;
import com.novell.ldap.util.LDAPWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;

public class DSMLWriter
implements LDAPWriter {
    private static boolean fswitch = true;
    private Writer out = null;
    private int state = 0;
    private static final int NEW_BATCH = 0;
    private static final int REQUEST_BATCH = 1;
    private static final int RESPONSE_BATCH = 2;
    private static final int SEARCH_TAG = 3;
    private boolean indent = false;
    private String tabString = "    ";
    private String version = "2.0";
    private boolean resumeOnError;
    private static final String BATCH_REQUEST_START = "<batchRequest xmlns=\"urn:oasis:names:tc:DSML:2:0:core\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" onError=\"";
    private static final String BATCH_RESPONSE_START = "<batchResponse xmlns=\"urn:oasis:names:tc:DSML:2:0:core\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";

    public void setResumeOnError(boolean bl) {
        this.resumeOnError = bl;
    }

    public DSMLWriter(String string) throws FileNotFoundException {
        this(new FileOutputStream(string, true));
    }

    public DSMLWriter(OutputStream outputStream) {
        try {
            this.out = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding is not supported by JVM" + unsupportedEncodingException.toString());
        }
    }

    public DSMLWriter(Writer writer) {
        this.out = writer;
    }

    public void writeError(Exception exception) throws IOException {
        try {
            this.checkState(true);
        }
        catch (LDAPLocalException lDAPLocalException) {
            throw new IOException(lDAPLocalException.toString());
        }
        this.newLine(1);
        this.out.write("<errorResponse type=\"");
        if (exception instanceof LDAPException) {
            switch (((LDAPException)exception).getResultCode()) {
                case 2: 
                case 84: {
                    this.out.write("malformedRequest\">");
                    break;
                }
                case 82: {
                    this.out.write("gatewayInternalError\">");
                    break;
                }
                case 49: {
                    this.out.write("authenticationFailed\">");
                    break;
                }
                default: {
                    this.out.write("other\">");
                    break;
                }
            }
        } else {
            this.out.write("other\">");
        }
        this.newLine(2);
        this.out.write("<message>");
        this.newLine(3);
        if (exception instanceof LDAPException) {
            LDAPException lDAPException = (LDAPException)exception;
            String string = Integer.toString(lDAPException.getResultCode()) + ":" + lDAPException.getMessage();
            this.out.write(this.makeXMLSafe(string));
        } else {
            this.out.write(this.makeXMLSafe(exception.getMessage()));
        }
        this.newLine(2);
        this.out.write("</message>");
        this.newLine(1);
        this.out.write("</errorResponse>");
    }

    public void finish() throws IOException {
        this.newLine(0);
        switch (this.state) {
            case 1: {
                this.out.write("</batchRequest>");
                break;
            }
            case 2: {
                this.out.write("</batchResponse>");
                break;
            }
            case 3: {
                if (this.indent) {
                    this.out.write(this.tabString);
                }
                this.out.write("</searchResponse>");
                this.newLine(0);
                this.out.write("</batchResponse>");
                break;
            }
            case 0: {
                this.out.write("<batchResponse>");
                this.newLine(0);
                this.out.write("</batchResponse>");
            }
        }
        this.newLine(0);
        this.out.flush();
    }

    public void writeComments(String string) throws IOException {
        this.newLine(1);
        this.out.write("<!-- ");
        this.out.write(string);
        this.out.write(" -->");
    }

    public void writeMessage(LDAPMessage lDAPMessage) throws IOException, LDAPLocalException {
        if (lDAPMessage instanceof LDAPResponse || lDAPMessage instanceof LDAPSearchResult || lDAPMessage instanceof LDAPSearchResultReference) {
            this.checkState(true);
        } else {
            this.checkState(false);
        }
        switch (lDAPMessage.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 16: {
                throw new UnsupportedOperationException("Writing of this message is not supported");
            }
            case 3: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchRequest", lDAPMessage);
                    this.state = 1;
                }
                this.writeSearchRequest((LDAPSearchRequest)lDAPMessage);
                break;
            }
            case 23: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("extendedRequest", lDAPMessage);
                    this.state = 1;
                }
                this.writeExtendedRequest((LDAPExtendedRequest)lDAPMessage);
                break;
            }
            case 14: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("compareRequest", lDAPMessage);
                    this.state = 1;
                }
                this.writeCompareRequest((LDAPCompareRequest)lDAPMessage);
                break;
            }
            case 8: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("addRequest", lDAPMessage);
                    this.state = 1;
                }
                this.writeAddRequest((LDAPAddRequest)lDAPMessage);
                break;
            }
            case 6: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("modifyRequest", lDAPMessage);
                    this.state = 1;
                }
                this.writeModifyRequest((LDAPModifyRequest)lDAPMessage);
                break;
            }
            case 12: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("modDNRequest", lDAPMessage);
                    this.state = 1;
                }
                this.writeModifyDNRequest((LDAPModifyDNRequest)lDAPMessage);
                break;
            }
            case 10: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("delRequest", lDAPMessage);
                    this.state = 1;
                }
                this.writeDeleteRequest((LDAPDeleteRequest)lDAPMessage);
                break;
            }
            case 4: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchResponse", lDAPMessage);
                    this.state = 3;
                }
                this.writeSearchResponse((LDAPSearchResult)lDAPMessage);
                break;
            }
            case 19: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchResponse", lDAPMessage);
                    this.state = 3;
                }
                this.writeSearchResultReference((LDAPSearchResultReference)lDAPMessage);
                break;
            }
            case 5: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchResponse", lDAPMessage);
                }
                this.newLine(2);
                this.writeTagWithID("searchResultDone", lDAPMessage);
                this.writeResult((LDAPResponse)lDAPMessage, 3);
                this.newLine(2);
                this.out.write("</searchResultDone>");
                this.newLine(1);
                this.out.write("</searchResponse>");
                this.state = 2;
                break;
            }
            case 7: {
                this.newLine(1);
                this.writeTagWithID("modifyResponse", lDAPMessage);
                this.writeResult((LDAPResponse)lDAPMessage, 2);
                this.newLine(1);
                this.out.write("</modifyResponse>");
                break;
            }
            case 9: {
                this.newLine(1);
                this.writeTagWithID("addResponse", lDAPMessage);
                this.writeResult((LDAPResponse)lDAPMessage, 2);
                this.newLine(1);
                this.out.write("</addResponse>");
                break;
            }
            case 11: {
                this.newLine(1);
                this.writeTagWithID("delResponse", lDAPMessage);
                this.writeResult((LDAPResponse)lDAPMessage, 2);
                this.newLine(1);
                this.out.write("</delResponse>");
                break;
            }
            case 13: {
                this.newLine(1);
                this.writeTagWithID("modDNResponse", lDAPMessage);
                this.writeResult((LDAPResponse)lDAPMessage, 2);
                this.newLine(1);
                this.out.write("</modDNResponse>");
                break;
            }
            case 15: {
                this.newLine(1);
                this.writeTagWithID("compareResponse", lDAPMessage);
                this.writeResult((LDAPResponse)lDAPMessage, 2);
                this.newLine(1);
                this.out.write("</compareResponse>");
                break;
            }
            case 24: {
                this.newLine(1);
                LDAPExtendedResponse lDAPExtendedResponse = (LDAPExtendedResponse)lDAPMessage;
                this.writeTagWithID("extendedResponse", lDAPMessage);
                this.writeResult((LDAPResponse)lDAPMessage, 2);
                this.newLine(2);
                this.out.write("<responseName>");
                this.out.write(lDAPExtendedResponse.getID());
                this.out.write("</responseName>");
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray != null) {
                    this.newLine(2);
                    this.out.write("<response xsi:type=\"xsd:base64Binary\">");
                    this.out.write(Base64.encode(byArray));
                    this.out.write("</response>");
                }
                this.newLine(1);
                this.out.write("</extendedResponse>");
            }
        }
    }

    public void writeEntry(LDAPEntry lDAPEntry) throws IOException, LDAPLocalException {
        this.checkState(true);
        this.writeEntry(lDAPEntry, null, null);
    }

    public void writeEntry(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) throws IOException, LDAPLocalException {
        this.checkState(true);
        this.writeEntry(lDAPEntry, lDAPControlArray, null);
    }

    public void writeEntry(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(true);
        this.newLine(2);
        this.out.write("<searchResultEntry dn=\"");
        this.out.write(this.makeAttributeSafe(lDAPEntry.getDN()));
        if (string != null) {
            this.out.write("\" requestID=\"" + string);
        }
        this.out.write("\">");
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Iterator iterator = lDAPAttributeSet.iterator();
        while (iterator.hasNext()) {
            this.writeAttribute((LDAPAttribute)iterator.next());
        }
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(2);
        this.out.write("</searchResultEntry>");
    }

    private static String byteString(byte[] byArray) {
        String string = null;
        if (Base64.isValidUTF8(byArray, true)) {
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Default JVM does not support UTF-8 encoding" + unsupportedEncodingException);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] >= 0) {
                    stringBuffer.append("\\0");
                    stringBuffer.append(Integer.toHexString(byArray[i]));
                    continue;
                }
                stringBuffer.append("\\" + Integer.toHexString(byArray[i]).substring(6));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private void writeFilter(Iterator iterator) throws IOException, LDAPLocalException {
        int n = -1;
        block21: while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Integer) {
                n = (Integer)e;
                switch (n) {
                    case 0: {
                        this.newLine(3);
                        this.out.write("<and>");
                        break;
                    }
                    case 1: {
                        this.newLine(3);
                        this.out.write("<or>");
                        break;
                    }
                    case 2: {
                        this.newLine(3);
                        this.out.write("<not>");
                        break;
                    }
                    case 3: {
                        this.newLine(4);
                        this.out.write("<equalityMatch name=\"");
                        this.out.write((String)iterator.next());
                        this.out.write("\">");
                        byte[] byArray = (byte[])iterator.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(byArray));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</equalityMatch>");
                        break;
                    }
                    case 5: {
                        this.newLine(4);
                        this.out.write("<greaterOrEqual name=\"");
                        this.out.write((String)iterator.next());
                        this.out.write("\">");
                        byte[] byArray = (byte[])iterator.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(byArray));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</greaterOrEqual>");
                        break;
                    }
                    case 6: {
                        this.newLine(4);
                        this.out.write("<lessOrEqual name=\"");
                        this.out.write((String)iterator.next());
                        this.out.write("\">");
                        byte[] byArray = (byte[])iterator.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(byArray));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</lessOrEqual>");
                        break;
                    }
                    case 7: {
                        this.newLine(4);
                        this.out.write("<present name=\"");
                        this.out.write((String)iterator.next());
                        this.out.write("\">");
                        this.newLine(4);
                        this.out.write("</present>");
                        break;
                    }
                    case 8: {
                        this.newLine(4);
                        this.out.write("<approxMatch name=\"");
                        this.out.write((String)iterator.next());
                        this.out.write("\">");
                        byte[] byArray = (byte[])iterator.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(byArray));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</approxMatch>");
                        break;
                    }
                    case 4: {
                        this.newLine(4);
                        this.out.write("<substrings name=\"");
                        this.out.write((String)iterator.next());
                        this.out.write("\">");
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            switch (n) {
                                case 0: {
                                    this.newLine(5);
                                    this.out.write("<initial>");
                                    this.out.write((String)iterator.next());
                                    this.out.write("</initial>");
                                    bl = false;
                                    break;
                                }
                                case 1: {
                                    this.newLine(5);
                                    this.out.write("<any>");
                                    this.out.write((String)iterator.next());
                                    this.out.write("</any>");
                                    bl = false;
                                    break;
                                }
                                case 2: {
                                    this.newLine(5);
                                    this.out.write("<final>");
                                    this.out.write((String)iterator.next());
                                    this.out.write("</final>");
                                }
                            }
                        }
                        this.newLine(4);
                        this.out.write("</substrings>");
                    }
                }
                continue;
            }
            if (!(e instanceof Iterator)) continue;
            this.writeFilter((Iterator)e);
            switch (n) {
                case 0: {
                    if (fswitch) {
                        fswitch = false;
                        continue block21;
                    }
                    this.newLine(3);
                    this.out.write("</and>");
                    fswitch = true;
                    continue block21;
                }
                case 1: {
                    if (fswitch) {
                        fswitch = false;
                        continue block21;
                    }
                    this.newLine(3);
                    this.out.write("</or>");
                    fswitch = true;
                    continue block21;
                }
                case 2: {
                    this.newLine(3);
                    this.out.write("</not>");
                    continue block21;
                }
            }
        }
    }

    private void writeModifyDNRequestEntry(LDAPModifyDNRequest lDAPModifyDNRequest, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(false);
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(1);
        this.out.write("</modDNRequest>");
    }

    private void writeModifyRequestEntry(LDAPModifyRequest lDAPModifyRequest, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(false);
        LDAPModification[] lDAPModificationArray = lDAPModifyRequest.getModifications();
        for (int i = 0; i < lDAPModificationArray.length; ++i) {
            LDAPAttribute lDAPAttribute = lDAPModificationArray[i].getAttribute();
            this.newLine(2);
            this.out.write("<modification name=\"");
            this.out.write(lDAPAttribute.getName());
            this.out.write("\" operation=\"");
            switch (lDAPModificationArray[i].getOp()) {
                case 0: {
                    this.out.write("add");
                    break;
                }
                case 1: {
                    this.out.write("delete");
                    break;
                }
                case 2: {
                    this.out.write("replace");
                }
            }
            this.out.write("\">");
            String[] stringArray = lDAPAttribute.getStringValueArray();
            byte[][] byArray = lDAPAttribute.getByteValueArray();
            for (int j = 0; j < stringArray.length; ++j) {
                this.newLine(3);
                if (Base64.isValidUTF8(byArray[j], false)) {
                    this.out.write("<value>");
                    this.out.write(stringArray[j]);
                    this.out.write("</value>");
                    continue;
                }
                this.out.write("<value xsi:type=\"xsd:base64Binary\">");
                this.out.write(Base64.encode(byArray[j]));
                this.out.write("</value>");
            }
            this.newLine(2);
            this.out.write("</modification>");
        }
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(1);
        this.out.write("</modifyRequest>");
    }

    private void writeDeleteRequestEntry(LDAPDeleteRequest lDAPDeleteRequest, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(false);
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(1);
        this.out.write("</delRequest>");
    }

    private void writeExtendedRequestEntry(LDAPExtendedRequest lDAPExtendedRequest, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(false);
        this.newLine(2);
        this.out.write("<requestName>");
        this.out.write(lDAPExtendedRequest.getExtendedOperation().getID());
        this.out.write("</requestName>");
        byte[] byArray = lDAPExtendedRequest.getExtendedOperation().getValue();
        if (byArray != null) {
            this.newLine(2);
            this.out.write("<requestValue xsi:type=\"xsd:base64Binary\">");
            this.out.write(Base64.encode(byArray));
            this.out.write("</requestValue>");
        }
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(1);
        this.out.write("</extendedRequest>");
    }

    private void writeCompareRequestEntry(LDAPCompareRequest lDAPCompareRequest, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(false);
        this.newLine(2);
        this.out.write("<assertion name=\"" + lDAPCompareRequest.getAttributeDescription());
        this.out.write("\">");
        this.newLine(3);
        this.out.write("<value>");
        byte[] byArray = lDAPCompareRequest.getAssertionValue();
        if (Base64.isLDIFSafe(byArray)) {
            this.out.write(new String(byArray, "UTF-8"));
        } else {
            this.out.write(Base64.encode(byArray));
        }
        this.out.write("</value>");
        this.newLine(2);
        this.out.write("</assertion>");
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(1);
        this.out.write("</compareRequest>");
    }

    private void writeAddRequestEntry(LDAPAddRequest lDAPAddRequest, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(false);
        LDAPEntry lDAPEntry = lDAPAddRequest.getEntry();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Iterator iterator = lDAPAttributeSet.iterator();
        while (iterator.hasNext()) {
            this.writeAttribute((LDAPAttribute)iterator.next());
        }
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(1);
        this.out.write("</addRequest>");
    }

    private void writeSearchRequestEntry(LDAPSearchRequest lDAPSearchRequest, LDAPControl[] lDAPControlArray, String string) throws IOException, LDAPLocalException {
        this.checkState(false);
        this.newLine(2);
        this.out.write("<attributes>");
        String[] stringArray = lDAPSearchRequest.getAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.newLine(3);
            this.out.write("<attribute name=\"");
            this.out.write(stringArray[i]);
            this.out.write("\"/>");
        }
        this.newLine(2);
        this.out.write("</attributes>");
        this.newLine(2);
        this.out.write("<filter>");
        Iterator iterator = lDAPSearchRequest.getSearchFilter();
        this.writeFilter(iterator);
        this.newLine(2);
        this.out.write("</filter>");
        if (lDAPControlArray != null && lDAPControlArray.length != 0) {
            this.writeControls(lDAPControlArray, 3);
        }
        this.newLine(1);
        this.out.write("</searchRequest>");
    }

    private void writeTagWithID(String string, LDAPMessage lDAPMessage) throws IOException {
        String string2;
        this.out.write("<" + string + " requestID=\"" + DOMWriter.findRequestID(lDAPMessage) + "\"");
        if (lDAPMessage instanceof LDAPResponse && (string2 = ((LDAPResponse)lDAPMessage).getMatchedDN()) != null && !string2.equals("")) {
            this.out.write(" matchedDN=\"" + this.makeAttributeSafe(string2) + "\"");
        }
        if (lDAPMessage instanceof LDAPCompareRequest) {
            string2 = ((LDAPCompareRequest)lDAPMessage).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(string2) + "\"");
        }
        if (lDAPMessage instanceof LDAPExtendedRequest) {
            // empty if block
        }
        if (lDAPMessage instanceof LDAPDeleteRequest) {
            string2 = ((LDAPDeleteRequest)lDAPMessage).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(string2) + "\"");
        }
        if (lDAPMessage instanceof LDAPAddRequest) {
            string2 = ((LDAPAddRequest)lDAPMessage).getEntry().getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(string2) + "\"");
        }
        if (lDAPMessage instanceof LDAPModifyRequest) {
            string2 = ((LDAPModifyRequest)lDAPMessage).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(string2) + "\"");
        }
        if (lDAPMessage instanceof LDAPModifyDNRequest) {
            string2 = ((LDAPModifyDNRequest)lDAPMessage).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(string2) + "\"");
            this.out.write(" newrdn=\"");
            this.out.write(((LDAPModifyDNRequest)lDAPMessage).getNewRDN() + "\" deleteoldrdn=\"");
            this.out.write(((LDAPModifyDNRequest)lDAPMessage).getDeleteOldRDN() + "\" newSuperior=\"");
            this.out.write(((LDAPModifyDNRequest)lDAPMessage).getParentDN() + "\"");
        }
        if (lDAPMessage instanceof LDAPSearchRequest) {
            string2 = "";
            String string3 = "";
            String string4 = ((LDAPSearchRequest)lDAPMessage).getDN();
            int n = ((LDAPSearchRequest)lDAPMessage).getScope();
            int n2 = ((LDAPSearchRequest)lDAPMessage).getDereference();
            int n3 = ((LDAPSearchRequest)lDAPMessage).getMaxResults();
            int n4 = ((LDAPSearchRequest)lDAPMessage).getServerTimeLimit();
            boolean bl = ((LDAPSearchRequest)lDAPMessage).isTypesOnly();
            this.out.write(" dn=\"" + this.makeAttributeSafe(string4) + "\"");
            switch (n) {
                case 0: {
                    string2 = "baseObject";
                    break;
                }
                case 1: {
                    string2 = "singleLevel";
                    break;
                }
                default: {
                    string2 = "wholeSubtree";
                }
            }
            this.out.write(" scope=\"" + string2 + "\"");
            switch (n2) {
                case 1: {
                    string3 = "derefInSearching";
                    break;
                }
                case 2: {
                    string3 = "derefFindingBaseObj";
                    break;
                }
                case 3: {
                    string3 = "derefAlways";
                    break;
                }
                default: {
                    string3 = "neverDerefAliases";
                }
            }
            this.out.write(" derefAliases=\"" + string3 + "\"");
            this.out.write(" sizeLimit=\"" + n3 + "\"");
            this.out.write(" timeLimit=\"" + n4 + "\"");
            this.out.write(" typesOnly=\"" + bl + "\"");
        }
        this.out.write(">");
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequest() {
        return true;
    }

    private void writeResult(LDAPResponse lDAPResponse, int n) throws IOException {
        String[] stringArray;
        LDAPControl[] lDAPControlArray = lDAPResponse.getControls();
        if (lDAPControlArray != null) {
            this.writeControls(lDAPControlArray, n);
        }
        if ((stringArray = lDAPResponse.getReferrals()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.newLine(n);
                this.out.write("<referral>" + stringArray[i] + "</referral>");
            }
        }
        this.newLine(n);
        this.out.write("<resultCode code=\"");
        this.out.write(new Integer(lDAPResponse.getResultCode()).toString());
        this.out.write("\" descr=\"");
        this.out.write(LDAPException.resultCodeToString(lDAPResponse.getResultCode()));
        this.out.write("\" />");
        String string = lDAPResponse.getErrorMessage();
        if (string != null && string.length() > 0) {
            this.newLine(n);
            this.out.write("<errorMessage>");
            this.out.write(this.makeXMLSafe(string));
            this.out.write("</errorMessage>");
        }
    }

    private void writeControls(LDAPControl[] lDAPControlArray, int n) throws IOException {
        for (int i = 0; i < lDAPControlArray.length; ++i) {
            this.newLine(n);
            this.out.write("<control type=\"");
            this.out.write(lDAPControlArray[i].getID());
            this.out.write("\" criticality=\"" + lDAPControlArray[i].isCritical() + "\"");
            byte[] byArray = lDAPControlArray[i].getValue();
            if (byArray == null) {
                this.out.write(" / >");
                continue;
            }
            this.out.write(">");
            this.newLine(n + 1);
            this.out.write("<controlValue xsi:type=\"xsd:base64Binary\">");
            this.out.write(Base64.encode(byArray));
            this.out.write("</controlValue>");
            this.newLine(n);
            this.out.write("</control>");
        }
    }

    private void writeSearchResultReference(LDAPSearchResultReference lDAPSearchResultReference) throws IOException {
        String[] stringArray = lDAPSearchResultReference.getReferrals();
        this.newLine(2);
        this.writeTagWithID("searchResultReference", lDAPSearchResultReference);
        for (int i = 0; i < stringArray.length; ++i) {
            this.newLine(3);
            this.out.write("<ref>");
            this.out.write(stringArray[i]);
            this.out.write("</ref>");
        }
        this.newLine(2);
        this.out.write("</searchResultReference>");
    }

    private void writeSearchResponse(LDAPSearchResult lDAPSearchResult) throws IOException, LDAPLocalException {
        this.writeEntry(lDAPSearchResult.getEntry(), lDAPSearchResult.getControls(), DOMWriter.findRequestID(lDAPSearchResult));
    }

    private void writeSearchRequest(LDAPSearchRequest lDAPSearchRequest) throws IOException, LDAPLocalException {
        this.writeSearchRequestEntry(lDAPSearchRequest, lDAPSearchRequest.getControls(), DOMWriter.findRequestID(lDAPSearchRequest));
    }

    private void writeAddRequest(LDAPAddRequest lDAPAddRequest) throws IOException, LDAPLocalException {
        this.writeAddRequestEntry(lDAPAddRequest, lDAPAddRequest.getControls(), DOMWriter.findRequestID(lDAPAddRequest));
    }

    private void writeCompareRequest(LDAPCompareRequest lDAPCompareRequest) throws IOException, LDAPLocalException {
        this.writeCompareRequestEntry(lDAPCompareRequest, lDAPCompareRequest.getControls(), DOMWriter.findRequestID(lDAPCompareRequest));
    }

    private void writeModifyRequest(LDAPModifyRequest lDAPModifyRequest) throws IOException, LDAPLocalException {
        this.writeModifyRequestEntry(lDAPModifyRequest, lDAPModifyRequest.getControls(), DOMWriter.findRequestID(lDAPModifyRequest));
    }

    private void writeModifyDNRequest(LDAPModifyDNRequest lDAPModifyDNRequest) throws IOException, LDAPLocalException {
        this.writeModifyDNRequestEntry(lDAPModifyDNRequest, lDAPModifyDNRequest.getControls(), DOMWriter.findRequestID(lDAPModifyDNRequest));
    }

    private void writeDeleteRequest(LDAPDeleteRequest lDAPDeleteRequest) throws IOException, LDAPLocalException {
        this.writeDeleteRequestEntry(lDAPDeleteRequest, lDAPDeleteRequest.getControls(), DOMWriter.findRequestID(lDAPDeleteRequest));
    }

    private void writeExtendedRequest(LDAPExtendedRequest lDAPExtendedRequest) throws IOException, LDAPLocalException {
        this.writeExtendedRequestEntry(lDAPExtendedRequest, lDAPExtendedRequest.getControls(), DOMWriter.findRequestID(lDAPExtendedRequest));
    }

    private void writeAttribute(LDAPAttribute lDAPAttribute) throws IOException {
        this.newLine(3);
        this.out.write("<attr name=\"");
        this.out.write(lDAPAttribute.getName());
        this.out.write("\">");
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            this.newLine(4);
            if (Base64.isValidUTF8(byArray[i], true) && this.isXMLSafe(byArray[i])) {
                this.out.write("<value>");
                String string = stringArray[i];
                string = string.replaceAll("&", "&amp;");
                string = string.replaceAll("<", "&lt;");
                string = string.replaceAll(">", "&gt;");
                string = string.replaceAll("'", "&apos;");
                string = string.replaceAll("\"", "&quot;");
                this.out.write(string);
                this.out.write("</value>");
                continue;
            }
            this.out.write("<value xsi:type=\"xsd:base64Binary\">");
            this.out.write(Base64.encode(byArray[i]));
            this.out.write("</value>");
        }
        this.newLine(3);
        this.out.write("</attr>");
    }

    private void checkState(boolean bl) throws IOException, LDAPLocalException {
        if (this.state == 0) {
            if (bl) {
                this.out.write(BATCH_RESPONSE_START);
                this.state = 2;
            } else {
                this.out.write(BATCH_REQUEST_START + (this.resumeOnError ? "resume" : "exit") + "\">");
                this.state = 1;
            }
        } else {
            if (this.state == 1 && bl) {
                throw new LDAPLocalException("Attempted insertion of a response message in a request batch", 83);
            }
            if (this.state == 2 && !bl) {
                throw new LDAPLocalException("Attempted insertion of a request message in a response batch", 83);
            }
        }
    }

    private void newLine(int n) throws IOException {
        if (!this.indent) {
            return;
        }
        this.out.write("\n");
        for (int i = 0; i < n; ++i) {
            this.out.write(this.tabString);
        }
    }

    public void useIndent(boolean bl) {
        this.indent = bl;
    }

    public void setIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        this.tabString = stringBuffer.toString();
    }

    private boolean isXMLSafe(byte[] byArray) {
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < 0 || byArray[i] > 31) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private String makeXMLSafe(String string) {
        if (string == null) {
            return "";
        }
        byte[] byArray = string.getBytes();
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < 0 || byArray[i] > 31) continue;
            byArray[i] = 32;
        }
        return new String(byArray);
    }

    private String makeAttributeSafe(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("'", "&apos;");
        string2 = string2.replaceAll("\"", "&quot;");
        return string2;
    }
}

