/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class LDIFReader
implements LDAPReader {
    private boolean requestFile = true;
    private String version;
    private int reqType;
    private int lNumber;
    private int dnlNumber;
    private int fNumber = 0;
    private byte[] bytes = new byte[0];
    private boolean control = false;
    private String entryDN;
    private String[] modInfo;
    private ArrayList rFields = new ArrayList();
    private ArrayList cList = new ArrayList();
    private BufferedReader bufReader;
    private LDAPControl[] controls = null;
    private LDAPEntry currentEntry = null;
    private LDAPModification[] mods;
    private LDAPMessage currentRequest = null;

    public LDIFReader(InputStream inputStream) throws IOException, LDAPLocalException {
        this(inputStream, 1, 8192);
    }

    public LDIFReader(InputStream inputStream, int n) throws IOException, LDAPLocalException {
        this(inputStream, n, 8192);
    }

    public LDIFReader(InputStream inputStream, int n, int n2) throws IOException, LDAPLocalException {
        String string = null;
        if (n != 1) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.LDIFReader:found: " + n + ", Should be: 1");
        }
        this.setVersion(n);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
        this.bufReader = new BufferedReader(inputStreamReader);
        while ((string = this.bufReader.readLine()) != null && (string.length() == 0 || string.startsWith("#"))) {
            ++this.lNumber;
        }
        if (string == null) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: The file contains no LDIF info", 82);
        }
        ++this.lNumber;
        if (string.startsWith("version:")) {
            this.version = string.substring("version:".length()).trim();
            if (!this.version.equals("1")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: version: found '" + n + "' (on line " + this.lNumber + " of the file), should be '1'", 82);
            }
        } else {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Version line must be the first meaningful line(on line " + this.lNumber + " of the file)", 82);
        }
        do {
            this.bufReader.mark(n2);
            string = this.bufReader.readLine();
            if (string == null) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the LDIF file only contains version line.", 82);
            }
            ++this.lNumber;
        } while (string.length() == 0 || string.startsWith("#"));
        while ((string = this.bufReader.readLine()) != null) {
            if (string.startsWith(" ") || string.startsWith("#")) continue;
            if (string.length() != 0) break;
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the first record only has dn field(line " + this.lNumber + " of the file)", 82);
        }
        if (string == null) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the first record only has dn field(line " + this.lNumber + " of the file)", 82);
        }
        if (string.startsWith("changetype") || string.startsWith("control")) {
            this.setRequest(true);
        } else {
            this.setRequest(false);
        }
        this.bufReader.reset();
        --this.lNumber;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(int n) {
        this.version = String.valueOf(n);
    }

    public boolean isRequest() {
        return this.requestFile;
    }

    private void setRequest(boolean bl) {
        this.requestFile = bl;
    }

    public LDAPMessage readMessage() throws IOException, LDAPException {
        this.readRecordFields();
        if (this.rFields == null) {
            return null;
        }
        this.toRecordProperties();
        if (!this.isRequest()) {
            return new LDAPSearchResult(this.currentEntry, null);
        }
        switch (this.reqType) {
            case 4: {
                this.currentRequest = new LDAPAddRequest(this.currentEntry, this.controls);
                break;
            }
            case 8: {
                this.currentRequest = new LDAPAddRequest(this.currentEntry, this.controls);
                break;
            }
            case 10: {
                this.currentRequest = new LDAPDeleteRequest(this.entryDN, this.controls);
                break;
            }
            case 12: {
                boolean bl = Integer.parseInt(this.modInfo[1]) == 1;
                if (this.modInfo[2].length() == 0) {
                    this.currentRequest = new LDAPModifyDNRequest(this.entryDN, this.modInfo[0], null, bl, this.controls);
                    break;
                }
                this.currentRequest = new LDAPModifyDNRequest(this.entryDN, this.modInfo[0], this.modInfo[2], bl, this.controls);
                break;
            }
            case 6: {
                this.currentRequest = new LDAPModifyRequest(this.entryDN, this.mods, this.controls);
                break;
            }
        }
        return this.currentRequest;
    }

    private void readRecordFields() throws IOException, LDAPException {
        String string;
        StringBuffer stringBuffer = new StringBuffer(80);
        this.rFields.clear();
        while ((string = this.bufReader.readLine()) != null && (string.length() == 0 || string.startsWith("#"))) {
            ++this.lNumber;
        }
        ++this.lNumber;
        this.dnlNumber = this.lNumber;
        if (string == null) {
            this.rFields = null;
        } else {
            if (!string.startsWith("dn:")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReacer: Any record should start with 'dn:'(on line " + this.lNumber + " of the file).", 82);
            }
            stringBuffer.append(string);
            while ((string = this.bufReader.readLine()) != null && string.length() != 0) {
                if (!string.startsWith("#")) {
                    if (string.startsWith(" ")) {
                        stringBuffer.append(string.substring(1, string.length()));
                    } else {
                        stringBuffer = this.trimField(stringBuffer);
                        if (!this.control) {
                            this.rFields.add(stringBuffer);
                        }
                        stringBuffer = new StringBuffer(80);
                        stringBuffer.append(string);
                    }
                }
                ++this.lNumber;
            }
            stringBuffer = this.trimField(stringBuffer);
            this.rFields.add(stringBuffer);
            ++this.lNumber;
            this.fNumber = this.rFields.size();
        }
    }

    private void toRecordProperties() throws IOException, LDAPException {
        StringBuffer stringBuffer = (StringBuffer)this.rFields.get(0);
        if (stringBuffer.charAt(3) != ':') {
            this.entryDN = stringBuffer.substring(3, stringBuffer.length());
        } else {
            this.bytes = Base64.decode(stringBuffer, 4, stringBuffer.length());
            try {
                this.entryDN = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        if (!this.isRequest()) {
            this.toLDAPEntry();
        } else {
            int n = 10;
            StringBuffer stringBuffer2 = (StringBuffer)this.rFields.get(1);
            if (!stringBuffer2.substring(0, n).equalsIgnoreCase("changetype")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed changetype field in record starting on line " + this.dnlNumber + " of the file).", 82);
            }
            String string = stringBuffer2.substring(n + 1);
            if (string.equalsIgnoreCase("add")) {
                this.reqType = 8;
                this.toLDAPEntry();
            } else if (string.equalsIgnoreCase("delete")) {
                this.reqType = 10;
            } else if (string.equalsIgnoreCase("modrdn")) {
                this.reqType = 12;
                this.toModInfo();
            } else if (string.equalsIgnoreCase("moddn")) {
                this.reqType = 12;
                this.toModInfo();
            } else if (string.equalsIgnoreCase("modify")) {
                this.reqType = 6;
                this.toLDAPModifications();
            } else {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: unsupported request type '" + string + "' specified in changetype filed of the record starting " + "on line " + this.dnlNumber + " of the file.", 82);
            }
            if (this.cList.size() > 0) {
                this.controls = new LDAPControl[this.cList.size()];
            }
        }
    }

    private void toLDAPEntry() throws LDAPLocalException {
        String string = null;
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        int n = !this.isRequest() ? 1 : 2;
        for (int i = n; i < this.fNumber; ++i) {
            String string2;
            StringBuffer stringBuffer = (StringBuffer)this.rFields.get(i);
            int n2 = this.IndexOf(stringBuffer, 58);
            if (n2 == -1) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: missing ':' after attribute name in record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            string = stringBuffer.substring(0, n2);
            if (lDAPAttributeSet.getAttribute(string) == null) {
                lDAPAttributeSet.add(new LDAPAttribute(string));
            }
            if (stringBuffer.length() > n2 + 1) {
                if (stringBuffer.charAt(n2 + 1) == ':') {
                    lDAPAttributeSet.getAttribute(string).addBase64Value(stringBuffer.substring(n2 + 2));
                    continue;
                }
                if (stringBuffer.charAt(n2 + 1) == '<') {
                    lDAPAttributeSet.getAttribute(string).addBase64Value(stringBuffer.substring(n2 + 2));
                    continue;
                }
                string2 = stringBuffer.substring(n2 + 1).trim();
                lDAPAttributeSet.getAttribute(string).addValue(string2);
                continue;
            }
            if (stringBuffer.length() != n2 + 1) continue;
            string2 = new String("");
            lDAPAttributeSet.getAttribute(string).addValue(string2);
        }
        this.currentEntry = new LDAPEntry(this.entryDN, lDAPAttributeSet);
    }

    private void toModInfo() throws LDAPLocalException {
        int n = 6;
        int n2 = 2;
        this.modInfo = new String[3];
        StringBuffer stringBuffer = (StringBuffer)this.rFields.get(n2);
        if (!stringBuffer.substring(0, n + 1).equalsIgnoreCase("newrdn:")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed newrdn field in record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        if (stringBuffer.charAt(n + 1) != ':') {
            this.modInfo[0] = stringBuffer.substring(n + 1);
        } else {
            this.bytes = Base64.decode(stringBuffer, n + 2, stringBuffer.length());
            try {
                this.modInfo[0] = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        n = 13;
        stringBuffer = (StringBuffer)this.rFields.get(++n2);
        if (!stringBuffer.substring(0, n).equalsIgnoreCase("deleteoldrdn:")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed deleteoldrdn field in record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        char c = stringBuffer.charAt(n);
        if (c == '1') {
            this.modInfo[1] = new String("1");
        } else if (c == '0') {
            this.modInfo[1] = new String("0");
        } else {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: value for deleteoldrdn field should '0' or '1', found '" + c + "' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        stringBuffer = (StringBuffer)this.rFields.get(++n2);
        if (n2 == this.fNumber) {
            this.modInfo[2] = new String("");
        } else {
            n = 12;
            if (!stringBuffer.substring(0, n).equalsIgnoreCase("newsuperior:")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed newsuperior field in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            if (stringBuffer.charAt(n) != ':') {
                this.modInfo[2] = stringBuffer.substring(n);
            } else {
                this.bytes = Base64.decode(stringBuffer, n + 1, stringBuffer.length());
                this.modInfo[2] = new String(this.bytes);
            }
        }
    }

    private void toLDAPModifications() throws LDAPLocalException {
        int n = 2;
        LDAPAttribute lDAPAttribute = null;
        ArrayList<LDAPModification> arrayList = new ArrayList<LDAPModification>();
        if (!this.rFields.get(this.fNumber - 1).toString().equalsIgnoreCase("-")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: modify record not ends with '-' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        for (int i = n; i < this.fNumber; ++i) {
            int n2 = this.IndexOf((StringBuffer)this.rFields.get(i), 58);
            if (n2 == -1) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed opName:attrName field in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            StringBuffer stringBuffer = (StringBuffer)this.rFields.get(i);
            String string = stringBuffer.substring(0, n2);
            String string2 = stringBuffer.substring(n2 + 1);
            if ((stringBuffer = (StringBuffer)this.rFields.get(++i)).charAt(0) != '-') {
                while (stringBuffer.charAt(0) != '-') {
                    n2 = this.IndexOf(stringBuffer, 58);
                    if (n2 == -1) {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : no ':' found in attrName:attrValue field in the record starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    String string3 = stringBuffer.substring(0, n2);
                    if (!string3.equalsIgnoreCase(string2)) {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : found attribute name '" + string3 + "', should be '" + string2 + "' in attrName:attrValue field in the record " + "starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    lDAPAttribute = new LDAPAttribute(string2);
                    if (stringBuffer.charAt(n2 + 1) == ':') {
                        lDAPAttribute.addBase64Value(stringBuffer.substring(n2 + 2));
                    } else if (stringBuffer.charAt(n2 + 1) == '<') {
                        lDAPAttribute.addBase64Value(stringBuffer.substring(n2 + 2));
                    } else {
                        lDAPAttribute.addValue(stringBuffer.substring(n2 + 1));
                    }
                    if (string.equalsIgnoreCase("add")) {
                        arrayList.add(new LDAPModification(0, lDAPAttribute));
                    } else if (string.equalsIgnoreCase("delete")) {
                        arrayList.add(new LDAPModification(1, lDAPAttribute));
                    } else if (string.equalsIgnoreCase("replace")) {
                        arrayList.add(new LDAPModification(2, lDAPAttribute));
                    } else {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : Not supported modify  request (" + string + ") specified in " + "record starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    stringBuffer = (StringBuffer)this.rFields.get(++i);
                }
                continue;
            }
            lDAPAttribute = new LDAPAttribute(string2);
            if (string.equalsIgnoreCase("delete")) {
                arrayList.add(new LDAPModification(1, lDAPAttribute));
                continue;
            }
            if (string.equalsIgnoreCase("replace")) {
                arrayList.add(new LDAPModification(2, lDAPAttribute));
                continue;
            }
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: For '" + string + "', no value " + "specified for atribute '" + string2 + "' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        this.mods = new LDAPModification[arrayList.size()];
        this.mods = arrayList.toArray(this.mods);
    }

    private int IndexOf(StringBuffer stringBuffer, int n) {
        if (stringBuffer != null) {
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != n) continue;
                return i;
            }
        }
        return -1;
    }

    private StringBuffer trimField(StringBuffer stringBuffer) throws LDAPLocalException {
        char c;
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        if (stringBuffer == null || (n = this.IndexOf(stringBuffer, 58)) == -1) {
            return stringBuffer;
        }
        n2 = stringBuffer.length() - 1;
        while (stringBuffer.charAt(n2) == ' ') {
            --n2;
        }
        char[] cArray = new char[n2 + 1];
        if (n > 6 && stringBuffer.substring(0, n).equals("control")) {
            this.control = true;
            ++n;
            while (n <= n2 && stringBuffer.charAt(n) == ' ') {
                ++n;
            }
        } else {
            this.control = false;
            stringBuffer.getChars(0, n + 1, cArray, 0);
            n3 += n + 1;
            ++n;
        }
        if (!this.control) {
            CharSequence charSequence;
            if (n <= n2) {
                char c2 = stringBuffer.charAt(n);
                if (c2 == ':') {
                    cArray[n3++] = 58;
                    ++n;
                } else if (c2 == '<') {
                    cArray[n3++] = 60;
                    ++n;
                }
            }
            boolean bl4 = false;
            String string2 = stringBuffer.substring(n);
            if (string2.length() > 0 && string2.charAt(0) != '<' && ((String)(charSequence = string2.trim())).length() > 0 && ((String)charSequence).charAt(0) == '<') {
                bl4 = true;
            }
            while (n <= n2 && stringBuffer.charAt(n) == ' ') {
                ++n;
            }
            if (bl4) {
                --n;
            }
            if (n <= n2) {
                stringBuffer.getChars(n, n2 + 1, cArray, n3);
                charSequence = new StringBuffer(n2);
                ((StringBuffer)charSequence).append(cArray, 0, n3 += n2 - n + 1);
                return charSequence;
            }
            if (stringBuffer.length() == n) {
                charSequence = new StringBuffer();
                stringBuffer.getChars(n, n2 + 1, cArray, n3);
                ((StringBuffer)charSequence).append(cArray, 0, n3 += n2 - n + 1);
                return charSequence;
            }
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: a field contains no value after ':'. the field is in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        int n4 = n;
        while (n <= n2 && ((c = stringBuffer.charAt(n)) == '.' || Character.isDigit(c))) {
            ++n;
        }
        if (n4 == n) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Control with no oid in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        Object object = new char[n - n4];
        stringBuffer.getChars(n4, n, (char[])object, 0);
        string = new String((char[])object);
        if (n > n2) {
            object = new LDAPControl(string, false, new byte[0]);
            this.cList.add(object);
            return null;
        }
        c = stringBuffer.charAt(n);
        if (c == ' ') {
            while (n <= n2 && stringBuffer.charAt(n) == ' ') {
                ++n;
            }
        }
        if (n + 3 <= n2 && stringBuffer.substring(n, n + 4).equals("true")) {
            n += 4;
            bl3 = true;
        } else if (n + 4 <= n2 && stringBuffer.substring(n, n + 5).equals("false")) {
            n += 5;
            bl3 = false;
        }
        if (n > n2) {
            object = new LDAPControl(string, bl3, new byte[0]);
            this.cList.add(object);
            return null;
        }
        c = stringBuffer.charAt(n);
        if (c != ':') {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Unexcepted char '" + c + "'. Expecting " + "to see ':' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        if (++n > n2) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after ':' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        c = stringBuffer.charAt(n);
        if (c == ':') {
            bl = true;
            if (++n > n2) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after '::' in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
        } else if (c == '<') {
            bl2 = true;
            if (++n > n2) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after ':<' in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
        }
        while (n <= n2 && stringBuffer.charAt(n) == ' ') {
            ++n;
        }
        if (n <= n2) {
            object = new char[n2 + 1 - n];
            stringBuffer.getChars(n, n2 + 1, (char[])object, 0);
            this.bytes = bl ? Base64.decode(object) : (bl2 ? new String((char[])object).getBytes() : new String((char[])object).getBytes());
        }
        object = new LDAPControl(string, bl3, this.bytes);
        this.cList.add(object);
        return null;
    }
}

