/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.bean.attribute;

import java.io.NotSerializableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsException;
import org.mc4j.ems.connection.bean.attribute.AttributeChangeEvent;
import org.mc4j.ems.connection.bean.attribute.AttributeChangeListener;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.impl.jmx.connection.bean.DMBean;
import org.mc4j.ems.store.CompleteValueHistory;
import org.mc4j.ems.store.ValueHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAttribute
implements EmsAttribute {
    private static Log log = LogFactory.getLog(DAttribute.class);
    protected MBeanAttributeInfo info;
    protected DMBean bean;
    protected boolean loaded;
    protected boolean supportedType = true;
    protected Set<AttributeChangeListener> changeListeners;
    protected long lastRetrieved;
    protected Object currentValue;
    protected ValueHistory valueHistory;
    protected LinkedList<Throwable> failures;
    private static final Set<Class> NUMERIC_TYPES = new HashSet<Class>();
    private static final Map<String, Class> TYPES;

    public DAttribute(MBeanAttributeInfo info, DMBean bean) {
        this.info = info;
        this.bean = bean;
        this.init();
    }

    protected void init() {
        if (Boolean.valueOf(this.getControlProperty("Attribute.history", "true")).booleanValue()) {
            String historyClass = this.getControlProperty("Attribute.history.class", null);
            if (historyClass != null) {
                try {
                    this.valueHistory = (ValueHistory)Class.forName(historyClass).newInstance();
                }
                catch (InstantiationException e) {
                    throw new EmsException("Could not instantiate value history class", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new EmsException("Could not access value history class", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new EmsException("Configured ValueHistory class not found", (Throwable)e);
                }
            } else {
                this.valueHistory = new CompleteValueHistory(Integer.valueOf(this.getControlProperty("Attribute.history.depth", "1")).intValue());
            }
        }
    }

    private String getControlProperty(String property, String defaultValue) {
        return this.bean.getConnectionProvider().getConnectionSettings().getControlProperties().getProperty(property, defaultValue);
    }

    public synchronized void registerAttributeChangeListener(AttributeChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet<AttributeChangeListener>();
        }
        this.changeListeners.add(listener);
    }

    public Object getValue() {
        if (!this.loaded) {
            this.refresh();
        }
        return this.currentValue;
    }

    public int getValueSize() {
        if (this.valueHistory.getHistorySize() == 0) {
            return 0;
        }
        return 0;
    }

    public void setValue(Object newValue) throws Exception {
        try {
            MBeanServer server = this.bean.getConnectionProvider().getMBeanServer();
            server.setAttribute(this.bean.getObjectName(), new Attribute(this.getName(), newValue));
            this.alterValue(newValue);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        this.refresh();
    }

    public void alterValue(Object newValue) {
        if (newValue != null && !newValue.equals(this.currentValue) || newValue == null && this.currentValue != null) {
            if (this.changeListeners != null && this.changeListeners.size() > 0) {
                AttributeChangeEvent event = new AttributeChangeEvent((EmsAttribute)this, this.currentValue, newValue);
                for (AttributeChangeListener listener : this.changeListeners) {
                    listener.attributeChange(event);
                }
            }
            this.currentValue = newValue;
        }
    }

    protected boolean storeHistory(Object value) {
        return value instanceof Number;
    }

    public synchronized Object refresh() {
        this.loaded = true;
        Object newValue = null;
        try {
            MBeanServer server = this.bean.getConnectionProvider().getMBeanServer();
            newValue = server.getAttribute(this.bean.getObjectName(), this.getName());
        }
        catch (ReflectionException e) {
            this.supportedType = false;
            this.registerFailure(e);
            throw new EmsException("Could not load attribute value " + e.toString(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            this.registerFailure(e);
            throw new EmsException("Could not load attribute value, bean instance not found " + this.bean.getObjectName().toString(), (Throwable)e);
        }
        catch (MBeanException e) {
            this.registerFailure(e);
            Exception t = e.getTargetException();
            if (t != null) {
                throw new EmsException("Could not load attribute value, target bean threw exception " + t.getLocalizedMessage(), (Throwable)t);
            }
            throw new EmsException("Could not load attribute value " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            this.registerFailure(e);
            throw new EmsException("Could not load attribute value, attribute [" + this.getName() + "] not found", (Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            if (e.getUndeclaredThrowable() instanceof InvocationTargetException) {
                Throwable t = e.getCause();
                if (t.getCause() instanceof NotSerializableException) {
                    this.supportedType = false;
                    this.registerFailure(t.getCause());
                    throw new EmsException("Could not load attribute value " + t.getLocalizedMessage(), t.getCause());
                }
                throw new EmsException("Could not load attribute value " + t.getLocalizedMessage(), t);
            }
            throw new EmsException("Could not load attribute value " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException re) {
            this.supportedType = false;
            this.registerFailure(re);
            throw new EmsException("Could not load attribute value " + re.getLocalizedMessage(), (Throwable)re);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.supportedType = false;
            this.registerFailure(ncdfe);
            throw new EmsException("Could not load attribute value " + ncdfe.getLocalizedMessage(), (Throwable)ncdfe);
        }
        catch (Throwable t) {
            throw new EmsException("Could not load attribute value " + t.getLocalizedMessage(), t);
        }
        this.alterValue(newValue);
        return newValue;
    }

    public List<Throwable> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    protected void registerFailure(Throwable t) {
        if (this.failures == null) {
            this.failures = new LinkedList();
        }
        this.failures.add(t);
        if (this.failures.size() > 2) {
            this.failures.removeFirst();
        }
        log.debug((Object)("Attribute access failure " + t.getLocalizedMessage()), t);
    }

    public ValueHistory getValueHistory() {
        return this.valueHistory;
    }

    public String getName() {
        return this.info.getName();
    }

    public String getType() {
        return this.info.getType();
    }

    public Class getTypeClass() {
        if (TYPES.containsKey(this.getType())) {
            return TYPES.get(this.getType());
        }
        try {
            return Class.forName(this.getType(), true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean isNumericType() {
        return NUMERIC_TYPES.contains(this.getTypeClass());
    }

    public String getDescription() {
        return this.info.getDescription();
    }

    public boolean isWritable() {
        return this.info.isWritable();
    }

    public boolean isReadable() {
        return this.info.isReadable();
    }

    public boolean isSupportedType() {
        return this.supportedType;
    }

    public void setSupportedType(boolean supportedType) {
        this.supportedType = supportedType;
    }

    public int compareTo(Object o) {
        DAttribute otherAttribute = (DAttribute)o;
        return this.getName().compareTo(otherAttribute.getName());
    }

    static {
        NUMERIC_TYPES.add(Short.TYPE);
        NUMERIC_TYPES.add(Short.class);
        NUMERIC_TYPES.add(Integer.TYPE);
        NUMERIC_TYPES.add(Integer.class);
        NUMERIC_TYPES.add(Long.TYPE);
        NUMERIC_TYPES.add(Long.class);
        NUMERIC_TYPES.add(Float.TYPE);
        NUMERIC_TYPES.add(Float.class);
        NUMERIC_TYPES.add(Double.TYPE);
        NUMERIC_TYPES.add(Double.class);
        NUMERIC_TYPES.add(BigInteger.class);
        NUMERIC_TYPES.add(BigDecimal.class);
        TYPES = new HashMap<String, Class>();
        TYPES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        TYPES.put(Character.TYPE.getName(), Character.TYPE);
        TYPES.put(Byte.TYPE.getName(), Byte.TYPE);
        TYPES.put(Short.TYPE.getName(), Short.TYPE);
        TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        TYPES.put(Long.TYPE.getName(), Long.TYPE);
        TYPES.put(Float.TYPE.getName(), Float.TYPE);
        TYPES.put(Double.TYPE.getName(), Double.TYPE);
        TYPES.put(Void.TYPE.getName(), Void.TYPE);
    }
}

