/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionException;
import org.mc4j.ems.impl.jmx.connection.support.providers.AbstractConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.jaas.JBossCallbackHandler;
import org.mc4j.ems.impl.jmx.connection.support.providers.jaas.JBossConfiguration;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.GenericMBeanServerProxy;

public class JBossConnectionProvider
extends AbstractConnectionProvider {
    private static final String NAMING_CONTEXT_FACTORY_CLASS_NAME = "org.jnp.interfaces.NamingContextFactory";
    private MBeanServer mbeanServer;
    private GenericMBeanServerProxy proxy;
    private LoginContext loginContext;
    private static Log log = LogFactory.getLog(JBossConnectionProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect() throws Exception {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            System.setProperty("jmx.serial.form", "1.1");
            ClassLoader childLoader = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(childLoader);
            InitialContext context = this.getInitialContext();
            if (this.getConnectionSettings().getPrincipal() != null) {
                this.initJaasLoginContext();
            }
            Object rmiAdaptor = context.lookup(this.connectionSettings.getJndiName());
            if (this.proxy != null) {
                log.debug((Object)"Reconnecting to remote JBoss MBeanServer...");
                this.proxy.setRemoteServer(rmiAdaptor);
            } else {
                this.proxy = new GenericMBeanServerProxy(rmiAdaptor);
                this.proxy.setProvider(this);
                this.setStatsProxy(this.proxy);
                this.mbeanServer = this.proxy.buildServerProxy();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    private InitialContext getInitialContext() throws NamingException {
        Properties props = this.connectionSettings.getAdvancedProperties();
        if (!NAMING_CONTEXT_FACTORY_CLASS_NAME.equals(this.connectionSettings.getInitialContextName())) {
            log.warn((Object)("Unsupported initial context factory [" + this.connectionSettings.getInitialContextName() + "] - only " + NAMING_CONTEXT_FACTORY_CLASS_NAME + " is supported for JBoss connections; using that instead..."));
        }
        props.put("java.naming.factory.initial", NAMING_CONTEXT_FACTORY_CLASS_NAME);
        props.put("java.naming.provider.url", this.connectionSettings.getServerUrl());
        try {
            InitialContext context = new InitialContext(props);
            return context;
        }
        catch (NoInitialContextException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new ConnectionException("Necessary classes not found for remote connection, check installation path configuration.", e.getCause());
            }
            throw e;
        }
    }

    public void doDisconnect() {
        this.loginContext = null;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void login() throws LoginException {
        if (this.loginContext != null) {
            this.loginContext.login();
        }
    }

    public void logout() throws LoginException {
        if (this.loginContext != null) {
            this.loginContext.logout();
        }
    }

    private void initJaasLoginContext() throws LoginException {
        JBossConfiguration jaasConfig = new JBossConfiguration();
        Configuration.setConfiguration(jaasConfig);
        JBossCallbackHandler jaasCallbackHandler = new JBossCallbackHandler(this.connectionSettings.getPrincipal(), this.connectionSettings.getCredentials());
        this.loginContext = new LoginContext("jboss", jaasCallbackHandler);
    }
}

