/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers.local;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import org.mc4j.ems.connection.local.LocalVirtualMachine;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.management.ConnectorAddressLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVMConnector {
    public static void main(String[] args) throws Exception {
        List<VirtualMachineDescriptor> descriptors = VirtualMachine.list();
        for (VirtualMachineDescriptor vm : descriptors) {
            System.out.println("VM: " + vm.displayName());
        }
        MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
        Set<Integer> all = monitoredHost.activeVms();
        System.out.println("Providers List:");
        for (AttachProvider p : AttachProvider.providers()) {
            System.out.println("\t" + p);
        }
        Map<Integer, LocalVirtualMachine> m = LocalVMConnector.getAllVirtualMachines();
        Iterator<Map.Entry<Integer, LocalVirtualMachine>> i$ = m.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Integer, LocalVirtualMachine> e;
            Map.Entry<Integer, LocalVirtualMachine> entry = e = i$.next();
            System.out.println(entry.getKey() + "::" + entry.getValue());
            System.out.println("\tattachable: " + entry.getValue().isAttachable() + " manageable: " + entry.getValue().isManageable());
            if (!entry.getValue().isAttachable() || entry.getValue().isManageable()) continue;
            LocalVMConnector.startManagementAgent(entry.getValue());
            if (!entry.getValue().isManageable()) {
                throw new RuntimeException("Couldn't start management agent");
            }
            System.out.println("\tAddress is now: " + entry.getValue().getConnectorAddress());
        }
    }

    public MBeanServer getMBeanServer() {
        return null;
    }

    protected void doConnect() throws Exception {
    }

    public static Map<Integer, LocalVirtualMachine> getAllVirtualMachines() {
        HashMap<Integer, LocalVirtualMachine> hashmap = new HashMap<Integer, LocalVirtualMachine>();
        LocalVMConnector.getMonitoredVMs(hashmap);
        LocalVMConnector.getAttachableVMs(hashmap);
        return hashmap;
    }

    public static Map<Integer, LocalVirtualMachine> getAllMonitorableVirtualMachines() {
        Map<Integer, LocalVirtualMachine> vms = LocalVMConnector.getAllVirtualMachines();
        HashMap<Integer, LocalVirtualMachine> manageableVMs = new HashMap<Integer, LocalVirtualMachine>();
        for (Map.Entry<Integer, LocalVirtualMachine> entry : vms.entrySet()) {
            if (!entry.getValue().isAttachable() && !entry.getValue().isManageable()) continue;
            manageableVMs.put(entry.getKey(), entry.getValue());
        }
        return manageableVMs;
    }

    private static void getMonitoredVMs(Map<Integer, LocalVirtualMachine> map) {
        Set<Integer> set;
        MonitoredHost monitoredhost;
        try {
            monitoredhost = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
            set = monitoredhost.activeVms();
        }
        catch (URISyntaxException urisyntaxexception) {
            throw new InternalError(urisyntaxexception.getMessage());
        }
        catch (MonitorException monitorexception) {
            throw new InternalError(monitorexception.getMessage());
        }
        for (Integer obj : set) {
            if (!(obj instanceof Integer)) continue;
            int i = obj;
            String s = ((Object)obj).toString();
            boolean flag = false;
            String s1 = null;
            try {
                MonitoredVm monitoredvm = monitoredhost.getMonitoredVm(new VmIdentifier(s));
                s = MonitoredVmUtil.commandLine(monitoredvm);
                flag = MonitoredVmUtil.isAttachable(monitoredvm);
                s1 = ConnectorAddressLink.importFrom((int)i);
                monitoredvm.detach();
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put(obj, new LocalVirtualMachine(i, s, flag, s1));
        }
    }

    private static void getAttachableVMs(Map<Integer, LocalVirtualMachine> map) {
        List<VirtualMachineDescriptor> list = VirtualMachine.list();
        for (VirtualMachineDescriptor virtualmachinedescriptor : list) {
            try {
                Integer integer = Integer.valueOf(virtualmachinedescriptor.id());
                if (map.containsKey(integer)) continue;
                boolean flag = false;
                String s = null;
                try {
                    VirtualMachine virtualmachine = VirtualMachine.attach(virtualmachinedescriptor);
                    flag = true;
                    Properties properties = virtualmachine.getAgentProperties();
                    s = (String)properties.get("com.sun.management.jmxremote.localConnectorAddress");
                    virtualmachine.detach();
                }
                catch (AttachNotSupportedException attachnotsupportedexception) {
                }
                catch (IOException ioexception) {
                    // empty catch block
                }
                map.put(integer, new LocalVirtualMachine(integer.intValue(), virtualmachinedescriptor.displayName(), flag, s));
            }
            catch (NumberFormatException numberformatexception) {}
        }
    }

    public static void startManagementAgent(LocalVirtualMachine lvm) throws IOException {
        if (!lvm.isAttachable()) {
            throw new IOException("This virtual machine \"" + lvm.getVmid() + "\" does not support dynamic attach.");
        }
        VirtualMachine virtualmachine = null;
        String s = String.valueOf(lvm.getVmid());
        try {
            virtualmachine = VirtualMachine.attach(s);
        }
        catch (AttachNotSupportedException attachnotsupportedexception) {
            IOException ioexception = new IOException(attachnotsupportedexception.getMessage());
            ioexception.initCause(attachnotsupportedexception);
            throw ioexception;
        }
        String s1 = virtualmachine.getSystemProperties().getProperty("java.home");
        String s2 = s1 + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
        File file = new File(s2);
        if (!file.exists() && !(file = new File(s2 = s1 + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
            throw new IOException("Management agent not found");
        }
        s2 = file.getCanonicalPath();
        try {
            virtualmachine.loadAgent(s2, "com.sun.management.jmxremote");
        }
        catch (AgentLoadException agentloadexception) {
            IOException ioexception1 = new IOException(agentloadexception.getMessage());
            ioexception1.initCause(agentloadexception);
            throw ioexception1;
        }
        catch (AgentInitializationException agentinitializationexception) {
            IOException ioexception2 = new IOException(agentinitializationexception.getMessage());
            ioexception2.initCause(agentinitializationexception);
            throw ioexception2;
        }
        Properties properties = virtualmachine.getAgentProperties();
        lvm.setConnectorAddress((String)properties.get("com.sun.management.jmxremote.localConnectorAddress"));
        virtualmachine.detach();
    }
}

