/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.core;

import java.io.IOException;
import java.util.Objects;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadNotFoundException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorePatchRequestHandler
extends AbstractRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(CorePatchRequestHandler.class);

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        boolean found = true;
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (uploadInfo == null) {
            found = false;
        } else if (uploadInfo.isUploadInProgress()) {
            try {
                uploadInfo = uploadStorageService.append(uploadInfo, servletRequest.getContentInputStream());
            }
            catch (UploadNotFoundException e) {
                found = false;
            }
        }
        if (found) {
            servletResponse.setHeader("Upload-Offset", Objects.toString(uploadInfo.getOffset()));
            servletResponse.setStatus(204);
            if (!uploadInfo.isUploadInProgress()) {
                log.info("Upload with ID {} at location {} finished successfully", (Object)uploadInfo.getId(), (Object)servletRequest.getRequestURI());
            }
        } else {
            log.error("The patch request handler could not find the upload for URL " + servletRequest.getRequestURI() + ". This means something is really wrong the request validators!");
            servletResponse.sendError(500);
        }
    }
}

